#ifndef _ace_user_
#define _ace_user_

static inline
unsigned int __attribute__ ((always_inline))
ace_BitRd(const unsigned IdxS1, const unsigned Adr12, const unsigned BSel3)
{
  unsigned int Bout_ret;
  __asm__ __volatile__("BitRd\t%0,%1,%2,%3"
          : "=r" (Bout_ret)
          : "i" (IdxS1), "i" (Adr12), "i" (BSel3)
        );
  return Bout_ret;
}
static inline
void __attribute__ ((always_inline))
ace_BitWt(const unsigned IdxS1, const unsigned Adr16, const unsigned BSel3, const unsigned Bin)
{
  __asm__ __volatile__("BitWt\t%0,%1,%2,%3"
          : 
          : "i" (IdxS1), "i" (Adr16), "i" (BSel3), "i" (Bin)
        );
}
static inline
void __attribute__ ((always_inline))
ace_BitTg(const unsigned IdxS1, const unsigned Adr16, const unsigned BSel3)
{
  __asm__ __volatile__("BitTg\t%0,%1,%2"
          : 
          : "i" (IdxS1), "i" (Adr16), "i" (BSel3)
        );
}
static inline
void __attribute__ ((always_inline))
ace_HByteWt(const unsigned IdxS1, const unsigned Adr10, const unsigned HBS1, const unsigned HBM4, const unsigned HBD4)
{
  __asm__ __volatile__("HByteWt\t%0,%1,%2,%3,%4"
          : 
          : "i" (IdxS1), "i" (Adr10), "i" (HBS1), "i" (HBM4), "i" (HBD4)
        );
}
static inline
unsigned int __attribute__ ((always_inline))
ace_RBitXor(unsigned int Din, const unsigned MSel3, unsigned int Dm)
{
  unsigned int Dout_ret;
  __asm__ __volatile__("RBitXor\t%0,%1,%2,%3"
          : "=r" (Dout_ret)
          : "r" (Din), "i" (MSel3), "r" (Dm)
        );
  return Dout_ret;
}
static inline
unsigned int __attribute__ ((always_inline))
ace_RBitWt(unsigned int Din, const unsigned BSel5, const unsigned Bin)
{
  unsigned int Dout_ret;
  __asm__ __volatile__("RBitWt\t%0,%1,%2,%3"
          : "=r" (Dout_ret)
          : "r" (Din), "i" (BSel5), "i" (Bin)
        );
  return Dout_ret;
}
static inline
unsigned int __attribute__ ((always_inline))
ace_RBitTg(unsigned int Din, const unsigned BSel5)
{
  unsigned int Dout_ret;
  __asm__ __volatile__("RBitTg\t%0,%1,%2"
          : "=r" (Dout_ret)
          : "r" (Din), "i" (BSel5)
        );
  return Dout_ret;
}
static inline
void __attribute__ ((always_inline))
ace_mtar(unsigned int Din, const unsigned Idx4)
{
  __asm__ __volatile__("mtar\t%0,%1"
          : 
          : "r" (Din), "i" (Idx4)
        );
}
static inline
unsigned int __attribute__ ((always_inline))
ace_mfar(const unsigned Idx4)
{
  unsigned int Dout_ret;
  __asm__ __volatile__("mfar\t%0,%1"
          : "=r" (Dout_ret)
          : "i" (Idx4)
        );
  return Dout_ret;
}

#endif
