/*
 * System.h
 * 
 *  Created on: 2016/08/15
 *  Author: Robert.Wang
 *  Version : V0.0, 2016/08/15
 *  
 */

#ifndef SYSTEM_H_
#define SYSTEM_H_
#include "HY16F3981.h"

#ifndef E_FAIL
#define E_FAIL		1
#endif
#define E_DRVSYS_ARGUMENT E_FAIL

#ifndef E_SUCCESS
#define E_SUCCESS		0
#endif

typedef enum
{
	SYS_SleepMode=0,
	SYS_IdleMode =1,
	SYS_WaitMode =2
}SYS_LowPower_Mode;


#ifdef  SYSTEM_BASE
#define R_SYSTEM_FLAG (SYSTEM_BASE+OFFSET00)
#define R_SYSTEM_WORKMODE (SYSTEM_BASE+OFFSET04)
#endif

#define FLG_SLP    			3
#define FLG_WDog   			2
#define FLG_RSTn   			1
#define FLG_BORn   			0
#define FLG_SLP_MASK 		(FLG_SLP+MASK)
#define FLG_WDog_MASK		(FLG_WDog+MASK)
#define FLG_RSTn_MASK		(FLG_RSTn+MASK)
#define FLG_BORn_MASK		(FLG_BORn+MASK)


unsigned int SYS_SleepFlagRead(void);
void SYS_SleepFlagClear(void);
unsigned int SYS_WdogFlagRead(void);
void SYS_WdogFlagClear(void);
unsigned int SYS_ResetFlagRead(void);
void SYS_ResetFlagClear(void);
unsigned int SYS_BOR_FlagRead(void);
void SYS_BOR_FlagClear(void);
unsigned char SYS_EnableGIE(unsigned char uPriority,unsigned short intvector);
void SYS_DisableGIE(void);
unsigned char SYS_LowPower(unsigned char umode);
unsigned char SYS_INTPriority(unsigned short intvector,unsigned short upriority);


#endif /* SYSTEM_H_ */
