/*
 *  Created on: 2016/7/28
 *  Author: Robert.Wang
 *  Memo : HY16F3981 system.c is base on HY16F198B to modify
*/
#include <nds32_intrinsic.h>  //must include this command at line 1
#include "System.h"
#include "SpecialMacro.h"


unsigned int SYS_SleepFlagRead(void)
{
	unsigned int l_reg,ReturnVal;
	ReturnVal=0;
	l_reg=R_SYSTEM_WORKMODE;
	ReturnVal=((inw(l_reg)&0x8)>>FLG_SLP);
	return ReturnVal;
}

void SYS_SleepFlagClear(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_SYSTEM_WORKMODE;
	l_data=(1<<FLG_SLP_MASK);
	outw(l_reg,l_data);
}

unsigned int SYS_WdogFlagRead(void)
{
	unsigned int l_reg,ReturnVal;
	ReturnVal=0;
	l_reg=R_SYSTEM_WORKMODE;
	ReturnVal=((inw(l_reg)&0x04)>>FLG_WDog);
	return ReturnVal;
}

void SYS_WdogFlagClear(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_SYSTEM_WORKMODE;
	l_data=(1<<FLG_WDog_MASK);
	outw(l_reg,l_data);
}


unsigned int SYS_ResetFlagRead(void)
{
	unsigned int l_reg,ReturnVal;
	ReturnVal=0;
	l_reg=R_SYSTEM_WORKMODE;
	ReturnVal=((inw(l_reg)&0x02)>>FLG_RSTn);
	return ReturnVal;
}

void SYS_ResetFlagClear(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_SYSTEM_WORKMODE;
	l_data=(1<<FLG_RSTn_MASK);
	outw(l_reg,l_data);
}

unsigned int SYS_BOR_FlagRead(void)
{
	unsigned int l_reg,ReturnVal;
	ReturnVal=0;
	l_reg=R_SYSTEM_WORKMODE;
	ReturnVal=((inw(l_reg)&0x01)>>FLG_BORn);
	return ReturnVal;
}


void SYS_BOR_FlagClear(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_SYSTEM_WORKMODE;
	l_data=(1<<FLG_BORn_MASK);
	outw(l_reg,l_data);
}

/**********************************************************************
 * Name     : SYS_EnableGIE (unsigned char uPriority)
 * function : setting the interrupt priority and enable the interrupt on CPU
 * input    : upriority[in]
 *		  0: no interrupt source enable
 *		  1: only allows interrupt 0
 *		  2: only allows interrupt 0/1
 *		  3: only allows interrupt 0/1/2
 *		  4: only allows interrupt 0/1/2/3
  *		  5: only allows interrupt 0/1/2/3/4
 *		  6: only allows interrupt 0/1/2/3/4/5
 *		  7: only allows interrupt 0/1/2/3/4/5/6
 *            intvector[in] 0~0x1ff,ÿһλӦһжʸʹλHW0~HW8
 * output   : 0 success; 1 fail
 * version  : v1.1
 * date     : 13-12-20
 * modify   : change the operation about setting the 'INT_MASK'on cpu
              Ӳintvectorѡжʸ
 *********************************************************************/
unsigned char SYS_EnableGIE(unsigned char uPriority,unsigned short intvector)
{
	unsigned int l_data;
	unsigned char ReturnVal;
	ReturnVal=0;
	if (uPriority<8)
		{
		l_data=__nds32__mfsr(NDS32_SR_PSW);
		l_data=(0xff00fff0&l_data) |(uPriority<<16)|0x09;
		__nds32__mtsr(l_data, NDS32_SR_PSW);

		l_data=__nds32__mfsr(NDS32_SR_INT_MASK);
		l_data=(0xfffffe00&l_data)|intvector; //0x1ff; //(~(0xff<<uPriority)&0x1ff);
		SETBIT(l_data,31);
		__nds32__mtsr(l_data, NDS32_SR_INT_MASK);
	}else {ReturnVal=E_DRVSYS_ARGUMENT;}


	return ReturnVal;
}

void SYS_DisableGIE(void)
{
  unsigned int l_data;
  l_data=__nds32__mfsr(NDS32_SR_PSW);
  CLRBIT(l_data,0)
  __nds32__mtsr(l_data, NDS32_SR_PSW);
}


/**********************************************************************
 * Name     : unsigned char SYS_LowPower(unsigned char umode)
 * function : enable the low power work mode such as IDLE/SLEEP/WAIT mode
 * input    : umode
 *		  0: sleep  mode
 *		  1: idle mode
 *		  2: wait mode
 * output   : 0 success; 1 fail
 * version  : v1.0
 * date     : 13-12-17
 * modify   : ޸ĳʡģʽʹ 'syscall x'滻2014-9-04
 *********************************************************************/
unsigned char SYS_LowPower(unsigned char umode)
{
	if(umode<3)
	  {
		if(umode==2)
		  {
		    asm("syscall 10");  //wait mode
		  }
		else if(umode==1)
		  {
			asm("syscall 11"); //Idle mode
		  }
		else if(umode==0)
		  {
			asm("syscall 12"); //sleep mode
		  }
			return E_SUCCESS;
	  }
	else
		return E_FAIL;
}

/*******************************************************************
*name    : SYS_INTPriority()
*function: öӦжʸȨ
*input   : intvectorжʸupriorityȨ
*output  : 01
*Version : v1.0
*date    : 2014-8-19
*modify  : NO
*********************************************************************/
unsigned char SYS_INTPriority(unsigned short intvector,unsigned short upriority)
{
	unsigned int l_data;
	unsigned char ReturnVal;

	if ((upriority<4)&&(intvector<9))
		{
		l_data=__nds32__mfsr(NDS32_SR_IVB);
		SETBIT(l_data,0);
		SETBIT(l_data,11);
		__nds32__mtsr(l_data, NDS32_SR_IVB);

		l_data=__nds32__mfsr(NDS32_SR_INT_PRI);
		l_data=((0xffffffff^(0x3<<(intvector*2)))&l_data)|(upriority<<(intvector*2));
		__nds32__mtsr(l_data, NDS32_SR_INT_PRI);
		ReturnVal=0;
	}
	else {ReturnVal=1;}

	return ReturnVal;

}






