/*
 * SpecialMacro.h
 *
 *  Created on: 2011/11/1
 *      Author: Eric.Lai
 */

#ifndef SPECIALMACRO_H_
#define SPECIALMACRO_H_

//#include "stdint.h";
#ifndef ENABLE
#define ENABLE		1
#endif

#ifndef DISABLE
#define DISABLE        0
#endif

#ifndef _NDS32_INTRINSIC_H
#define _NDS32_INTRINSIC_H

/*
enum nds32_sr {
NDS32_SR_CPU_VER=1024,  //1024
NDS32_SR_ICM_CFG,  //1025
NDS32_SR_DCM_CFG,  //1026
NDS32_SR_MMU_CFG,  //1027
NDS32_SR_MSC_CFG,  //1028
NDS32_SR_CORE_ID, //1029
NDS32_SR_FUCOP_EXIST,  //1030
NDS32_SR_PSW,   //ir0,  //1031
NDS32_SR_IPSW,  //1032
NDS32_SR_P_IPSW,  //1033
NDS32_SR_IVB,  //1034
NDS32_SR_EVA,  //1035
NDS32_SR_P_EVA,  //1036
NDS32_SR_ITYPE,   //1037
NDS32_SR_P_ITYPE,  //1038
NDS32_SR_MERR,  //1039
NDS32_SR_IPC,  //1040
NDS32_SR_P_IPC,  //1041
NDS32_SR_OIPC,  //1042
NDS32_SR_P_P0,  //1043
NDS32_SR_P_P1,  //1044
NDS32_SR_INT_MASK, //ir14, //1045
NDS32_SR_INT_MASK2,
NDS32_SR_INT_PEND,
NDS32_SR_INT_PEND2,
NDS32_SR_SP_USR,
NDS32_SR_SP_PRIV,
NDS32_SR_INT_PRI,
NDS32_SR_INT_CTRL,
NDS32_SR_MMU_CTL,
NDS32_SR_L1_PPTB,
NDS32_SR_TLB_VPN,
NDS32_SR_TLB_DATA,
NDS32_SR_TLB_MISC,
NDS32_SR_VLPT_IDX,
NDS32_SR_ILMB,
NDS32_SR_DLMB,
NDS32_SR_CACHE_CTL,
NDS32_SR_HSMP_SADDR,
NDS32_SR_HSMP_EADDR,
NDS32_SR_SDZ_CTL,
NDS32_SR_N12MISC_CTL,
NDS32_SR_MISC_CTL,
NDS32_SR_BPC0,
NDS32_SR_BPC1,
NDS32_SR_BPC2,
NDS32_SR_BPC3,
NDS32_SR_BPC4,
NDS32_SR_BPC5,
NDS32_SR_BPC6,
NDS32_SR_BPC7,
NDS32_SR_BPA0,
NDS32_SR_BPA1,
NDS32_SR_BPA2,
NDS32_SR_BPA3,
NDS32_SR_BPA4,
NDS32_SR_BPA5,
NDS32_SR_BPA6,
NDS32_SR_BPA7,
NDS32_SR_BPAM0,
NDS32_SR_BPAM1,
NDS32_SR_BPAM2,
NDS32_SR_BPAM3,
NDS32_SR_BPAM4,
NDS32_SR_BPAM5,
NDS32_SR_BPAM6,
NDS32_SR_BPAM7,
NDS32_SR_BPV0,
NDS32_SR_BPV1,
NDS32_SR_BPV2,
NDS32_SR_BPV3,
NDS32_SR_BPV4,
NDS32_SR_BPV5,
NDS32_SR_BPV6,
NDS32_SR_BPV7,
NDS32_SR_BPCID0,
NDS32_SR_BPCID1,
NDS32_SR_BPCID2,
NDS32_SR_BPCID3,
NDS32_SR_BPCID4,
NDS32_SR_BPCID5,
NDS32_SR_BPCID6,
NDS32_SR_BPCID7,
NDS32_SR_EDM_CFG,
NDS32_SR_EDMSW,
NDS32_SR_EDM_CTL,
NDS32_SR_EDM_DTR,
NDS32_SR_BPMTC,
NDS32_SR_DIMBR,
NDS32_SR_TECR0,
NDS32_SR_TECR1,
NDS32_SR_EDM_PROBE,
NDS32_SR_PFMC0,
NDS32_SR_PFMC1,
NDS32_SR_PFMC2,
NDS32_SR_PFM_CTL,
NDS32_SR_FUCOP_CTL,
NDS32_SR_PRUSR_ACC_CTL,
NDS32_SR_DMA_CFG,
NDS32_SR_DMA_GCSW,
NDS32_SR_DMA_CHNSEL,
NDS32_SR_DMA_ACT,
NDS32_SR_DMA_SETUP,
NDS32_SR_DMA_ISADDR,
NDS32_SR_DMA_ESADDR,
NDS32_SR_DMA_TCNT,
NDS32_SR_DMA_STATUS,
NDS32_SR_DMA_2DSET,
NDS32_SR_DMA_2DSCTL
};
*/

#define __nds32__llw(a) (__builtin_nds32_llw ((a)))
#define __nds32__lwup(a) (__builtin_nds32_lwup ((a)))
#define __nds32__scw(a, b) (__builtin_nds32_scw ((a), (b)))
#define __nds32__swup(a, b) (__builtin_nds32_swup ((a), (b)))
#define __nds32__mfsr(srname) (__builtin_nds32_mfsr ((srname)))
#define __nds32__mfusr(usrname) (__builtin_nds32_mfusr ((usrname)))
#define __nds32__mtsr(val, srname) (__builtin_nds32_mtsr ((val), (srname)))
#define __nds32__mtusr(val, usrname) (__builtin_nds32_mtusr ((val), (usrname)))
#define __nds32__break(swid) (__builtin_nds32_break(swid))
#define __nds32__cctlva_lck(subtype, va) (__builtin_nds32_cctl_va_lck ((subtype), (va)))
#define __nds32__cctlidx_wbinval(subtype, idx) (__builtin_nds32_cctl_idx_wbinval ((subtype), (idx)))
#define __nds32__cctlva_wbinval_alvl(subtype, va) (__builtin_nds32_cctl_va_wbinval_la ((subtype), (va)))
#define __nds32__cctlva_wbinval_one_lvl(subtype, va) (__builtin_nds32_cctl_va_wbinval_l1 ((subtype), (va)))
#define __nds32__cctlidx_read(subtype, idx) (__builtin_nds32_cctl_idx_read ((subtype), (idx)))
#define __nds32__cctlidx_write(subtype, b, idxw) ( __builtin_nds32_cctl_idx_write ((subtype), (b), (idxw)))
#define __nds32__cctl_l1d_invalall  __builtin_nds32_cctl_l1d_invalall
#define __nds32__dsb __builtin_nds32_dsb
#define __nds32__isb __builtin_nds32_isb
#define __nds32__msync_store __builtin_nds32_msync_store
#define __nds32__msync_all __builtin_nds32_msync_all
#define __nds32__nop __builtin_nds32_nop
#define __nds32__standby_wait_done __builtin_nds32_standby_wait_done
#define __nds32__standby_no_wake_grant __builtin_nds32_standby_no_wake_grant
#define __nds32__standby_wake_grant __builtin_nds32_standby_wake_grant
#define __nds32__schedule_barrier __builtin_nds32_schedule_barrier
#define __nds32__setend_big __builtin_nds32_setend_big
#define __nds32__setend_little __builtin_nds32_setend_little
#define __nds32__setgie_en __builtin_nds32_setgie_en
#define __nds32__setgie_dis __builtin_nds32_setgie_dis
#define __nds32__dpref_qw(a, b, subtype) (__builtin_nds32_dpref_qw ((a), (b), (subtype)))
#define __nds32__dpref_hw(a, b, subtype) (__builtin_nds32_dpref_hw ((a), (b), (subtype)))
#define __nds32__dpref_w(a, b, subtype) (__builtin_nds32_dpref_w ((a), (b), (subtype)))
#define __nds32__dpref_dw(a, b, subtype) (__builtin_nds32_dpref_dw ((a), (b), (subtype)))
#define __nds32__teqz(a, swid) (__builtin_nds32_teqz ((a), (swid)))
#define __nds32__tnez(a, swid) ( __builtin_nds32_tnez ((a), (swid)))
#define __nds32__trap(swid) (__builtin_nds32_trap ((swid)))
#define __nds32__isync(a) (__builtin_nds32_isync ((a)))
#define __nds32__rotr(val, ror) (__builtin_nds32_rotr ((val), (ror)))
#define __nds32__wsbh(a) (__builtin_nds32_wsbh ((a)))
#define __nds32__syscall(a) (__builtin_nds32_syscall ((a)))
#define __nds32__return_address __builtin_nds32_return_address
#define __nds32__get_current_sp __builtin_nds32_get_current_sp
#define __nds32__set_current_sp(a) (__builtin_nds32_set_current_sp ((a)))
#define __nds32__ave(a, b) (__builtin_nds32_pe_ave ((a), (b)))
#define __nds32__bclr(a, pos) (__builtin_nds32_pe_bclr ((a), (pos)))
#define __nds32__bset(a, pos) (__builtin_nds32_pe_bset ((a), (pos)))
#define __nds32__btgl(a, pos) (__builtin_nds32_pe_btgl ((a), (pos)))
#define __nds32__btst(a, pos) (__builtin_nds32_pe_btst ((a), (pos)))
#define __nds32__clip(a, imm) (__builtin_nds32_pe_clip ((a), (imm)))
#define __nds32__clips(a, imm) (__builtin_nds32_pe_clips ((a), (imm)))
#define __nds32__clz(a) (__builtin_nds32_pe_clz ((a)))
#define __nds32__clo(a) (__builtin_nds32_pe_clo ((a)))
#define __nds32__bse(r, a, b) (__builtin_nds32_pe2_bse ((r), (a), (b)))
#define __nds32__bsp(r, a, b) (__builtin_nds32_pe2_bsp ((r), (a), (b)))
#define __nds32__pbsad(a, b) (__builtin_nds32_pe2_pbsad ((a), (b)))
#define __nds32__pbsada(acc, a, b) (__builtin_nds32_pe2_pbsada ((acc), (a), (b)))
#define __nds32__ffb(a, b) (__builtin_nds32_se_ffb ((a), (b)))
#define __nds32__ffmism(a, b) (__builtin_nds32_se_ffmism ((a), (b)))
#define __nds32__flmism(a, b) (__builtin_nds32_se_flmism ((a), (b)))
#define __nds32__fcpynsd(a, b) (__builtin_nds32_fcpynsd ((a), (b)))
#define __nds32__fcpynss(a, b) (__builtin_nds32_fcpynss ((a), (b)))
#define __nds32__fcpysd(a, b) (__builtin_nds32_fcpysd ((a), (b)))
#define __nds32__fcpyss(a, b) (__builtin_nds32_fcpyss ((a), (b)))
#define __nds32__fmfcsr __builtin_nds32_fmfcsr
#define __nds32__fmtcsr(fpcsr) (__builtin_nds32_fmtcsr ((fpcsr)))
#define __nds32__fmfcfg __builtin_nds32_fmfcfg

#endif

#define	inw(reg)		(*((volatile unsigned int *) (reg)))
#define	outw(reg, data) 	((*((volatile unsigned int *)(reg)))=(unsigned int)(data))
#define SETBIT(x,n)  x=x|(1<<n);
#define CLRBIT(x,n)  x=x&~(1<<n);
#define BITS(value32u,m,n)  ((unsigned int)(value32u<<(7-(n)))>>((7-(n)))+(m)));

typedef volatile unsigned char  vu8;
typedef volatile unsigned long  vu32;
typedef volatile unsigned short vu16;
#define M8(adr)  (*((vu8  *) (adr)))
#define M16(adr) (*((vu16 *) (adr)))
#define M32(adr) (*((vu32 *) (adr)))

#define outpw(port,value)	*((volatile unsigned int *)(port))=value
#define inpw(port)			(*((volatile unsigned int *)(port)))
#define outpb(port,value)	*((volatile unsigned char *)(port))=value
#define inpb(port)			(*((volatile unsigned char *)(port)))
#define outps(port,value)	*((volatile unsigned short *)(port))=value
#define inps(port)			(*((volatile unsigned short *)(port)))

#define outp32(port,value)	*((volatile unsigned int *)(port))=value
#define inp32(port)			(*((volatile unsigned int *)(port)))
#define outp8(port,value)	*((volatile unsigned char *)(port))=value
#define inp8(port)			(*((volatile unsigned char *)(port)))
#define outp16(port,value)	*((volatile unsigned short *)(port))=value
#define inp16(port)			(*((volatile unsigned short *)(port)))



/*
 * NDS32_REG_WRITE(addr, data)
 * Write data to specified location at addr
 *
 * Operation: *addr = data
 * */
#define NDS32_REG_WRITE(addr, data) \


#endif /* SPECIALMACRO_H_ */
