﻿/*
 * HY16F198.h
 *
 *  Created on: 2011/11/1
 *      Author: Eric.Lai
 */
#ifndef HY16F188_H_
#define HY16F188_H_

#include "stdint.h"
#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE 1
#endif

#ifndef E_SUCCESS
#define E_SUCCESS		0
#endif

#ifndef E_FAIL
#define E_FAIL		1
#endif

#ifndef NULL
#define NULL        0
#endif


#define	OFFSET00	0x0
#define	OFFSET04   	0x4
#define	OFFSET08	0x8
#define	OFFSET0C   	0xC
#define	OFFSET10	0x10
#define	OFFSET14   	0x14
#define	OFFSET18   	0x18
#define	OFFSET1C   	0x1C
#define	OFFSET20	0x20
#define	OFFSET24   	0x24
#define	OFFSET28   	0x28
#define	OFFSET2C   	0x2C
#define	OFFSET30	0x30
#define	OFFSET34   	0x34
#define	OFFSET38   	0x38
#define	OFFSET3C   	0x3C
#define	OFFSET40	0x40
#define	OFFSET44   	0x44
#define	OFFSET48   	0x48
#define	OFFSET4C   	0x4C


#define	MASK   	    0x8

#define	INT_Rsv_OFFSET	   	0x0
#define	INT_Flag_OFFSET		0x4



/******************************************************************************/
/*                Device Specific Peripheral registers structures             */
/******************************************************************************/
/*--------------------- Interrupt Control ------------------------------------*/
typedef struct
{ //# 以下順序相反會有bug 暫存器有新增
	__O  uint32_t COM_H_MASK:8;  
	__I  uint32_t RESERVE1:2;//5-->2
	__IO uint32_t UART_TXIE:1;
	__IO uint32_t UART_RXIE:1;
	__IO uint32_t SPI_IE:1;
	__O  uint32_t COM_L_MASK:8;
	__I  uint32_t RESERVE2:2;//5-->2
	__IO uint32_t UART_TXIF:1;
	__IO uint32_t UART_RXIF:1;
	__IO uint32_t SPI_IF:1;
}INT_COM_T;

typedef struct
{
	__O  uint32_t TMR_H_MASK:8;
	__I  uint32_t RESERVE1:2;
	__IO uint32_t RTCIE:1;
	__IO uint32_t WDTIE:1;
	__IO uint32_t TMRC1IE:1;
	__IO uint32_t TMRC0IE:1;
	__IO uint32_t TMRBIE:1;
	__IO uint32_t TMRAIE:1;
	__O  uint32_t TMR_L_MASK:8;
	__I  uint32_t RESERVE2:2;
	__IO uint32_t RTCIF:1;
	__IO uint32_t WDTIF:1;
	__IO uint32_t TMRC1IF:1;
	__IO uint32_t TMRC0IF:1;
	__IO uint32_t TMRBIF:1;
	__IO uint32_t TMRAIF:1;
}INT_TMR_T;

typedef struct
{
	__O  uint32_t ADC_H_MASK:8;
	__I  uint32_t RESERVE1:7;
	__IO uint32_t ADCIE:1;
	__O  uint32_t ADC_L_MASK:8;
	__I  uint32_t RESERVE2:7;
	__IO uint32_t ADCIF:1;
}INT_ADC_T;

typedef struct
{
	__O  uint32_t CMP_H_MASK:8;
	__I  uint32_t RESERVE1:6;
	__IO uint32_t CMPIE:1;
	__IO uint32_t OPIE:1;
	__O  uint32_t CMP_L_MASK:8;
	__I  uint32_t RESERVE2:6;
	__IO uint32_t CMPIF:1;
	__IO uint32_t OPIF:1;
}INT_CMP_T;

typedef struct
{
	__O  uint32_t GPIO_H_MASK:8;
	__IO uint32_t GPIOIE:8;
	__O  uint32_t GPIO_L_MASK:8;
	__IO uint32_t GPIOIF:8;
}INT_GPIO_T;

typedef struct
{
	INT_COM_T      COM;
	INT_TMR_T      TIME;
	INT_ADC_T      ADC;
	INT_CMP_T      CMP;
	INT_GPIO_T     GPIO;
}INT_T;

/*--------------------- General Purpose Input and Output ---------------------*/
typedef __IO uint32_t GPIO_PHOE_T;
typedef __IO uint32_t GPIO_IEOD_T;
typedef __IO uint32_t GPIO_ID_T;
typedef struct
{
    __IO uint32_t PTDe_GLITCH:8;
    __IO uint32_t PT_7:3;
    __IO uint32_t PT_6:3;
    __IO uint32_t PT_5:3;
    __IO uint32_t PT_4:3;
    __IO uint32_t PT_3:3;
    __IO uint32_t PT_2:3;
    __IO uint32_t PT_1:3;
    __IO uint32_t PT_0:3;
} GPIO_ITR_T;

typedef struct
{
	GPIO_PHOE_T     PHOE;
	GPIO_IEOD_T     IEOD;
	GPIO_ID_T       DOUT;
	GPIO_ITR_T      ITR;
} GPIO_T;

/*----------------------------- RTC Controller -------------------------------*/
typedef struct
{
    __IO uint32_t  RTCEn:1;
    __IO uint32_t  CKS:1;
    __IO uint32_t  HRF:1;
    __IO uint32_t  TAEn:1;
    __IO uint32_t  WUEn:1;
    __IO uint32_t  PTEn:1;
    __I  uint32_t  RESERVE0:2;
    __O  uint32_t  MASK0:6;
    __IO uint32_t  TAF:1;
    __I  uint32_t  WUF:1;
    __IO uint32_t  PTF:1;
    __I  uint32_t  LPYF:1;
    __IO uint32_t  KEY:4;
    __O  uint32_t  MASK1:4;
    __I  uint32_t  RESERVE1:2;
} RTC_State_T;

typedef struct
{
	__IO uint32_t  PT:3;
    __I  uint32_t  RESERVE0:1;
    __IO uint32_t  CKH:1;
    __I  uint32_t  RESERVE1:3;
    __O uint32_t   MASK0:3;
    __I uint32_t   RESERVE2:1;
    __O uint32_t   MASK1:1;
    __I uint32_t  RESERVE3:3;
    __IO uint32_t  CM:7;
    __I uint32_t  RESERVE4:1;
    __O  uint32_t  MASK2:7;
    __I uint32_t  RESERVE5:1;
} RTC_Correction_T;

typedef struct
{
	__IO uint32_t  HR1:4;
    __IO uint32_t  HR10:2;
    __IO uint32_t  PM:1;
    __I  uint32_t  RESERVE0:1;
    __O uint32_t   MASK0:7;
    __I uint32_t   RESERVE1:17;
} RTC_APH_T;

typedef struct
{
	__IO uint32_t  SEC1:4;
    __IO uint32_t  SEC10:3;
    __I  uint32_t  RESERVE0:1;
    __O  uint32_t  MASK0:7;
    __I  uint32_t  RESERVE1:1;
    __IO uint32_t  MIN1:4;
    __IO uint32_t  MIN10:3;
    __I  uint32_t  RESERVE2:1;
    __O  uint32_t  MASK1:7;
    __I  uint32_t  RESERVE3:1;
} RTC_MS_T;

typedef struct
{
	__IO uint32_t  MO1:4;
    __IO uint32_t  MO10:1;
    __I  uint32_t  RESERVE0:3;
    __O  uint32_t  MASK0:5;
    __I  uint32_t  RESERVE1:3;
    __IO uint32_t  YEAR1:4;
    __IO uint32_t  YEAR10:4;
    __O  uint32_t  MASK1:8;
} RTC_YM_T;

typedef struct
{
	__IO uint32_t  WDA:3;
    __I  uint32_t  RESERVE0:5;
    __O  uint32_t  MASK0:3;
    __I  uint32_t  RESERVE1:5;
    __IO uint32_t  DAT1:4;
    __IO uint32_t  DAT10:2;
    __I  uint32_t  RESERVE2:2;
    __O  uint32_t  MASK1:6;
    __I  uint32_t  RESERVE3:2;
} RTC_DW_T;

typedef struct
{
	__IO uint32_t  CSE1:4;
    __IO uint32_t  CSE10:3;
    __I  uint32_t  RESERVE0:1;
    __IO uint32_t  CMI1:4;
    __IO uint32_t  CMI10:3;
    __I  uint32_t  RESERVE1:1;
    __IO uint32_t  CHR1:4;
    __IO uint32_t  CHR10:2;
    __IO uint32_t  CPM:1;
    __I  uint32_t  RESERVE2:9;
} RTC_AHMS_T;

typedef struct
{
	__IO uint32_t  CDAT1:4;
    __IO uint32_t  CDAT10:2;
    __I  uint32_t  RESERVE0:2;
    __IO uint32_t  CMO1:4;
    __IO uint32_t  CMO10:1;
    __I  uint32_t  RESERVE1:3;
    __IO uint32_t  CYE1:4;
    __IO uint32_t  CYE10:4;
    __I  uint32_t  RESERVE2:8;
} RTC_AYMD_T;

typedef struct
{
	RTC_State_T      State;
	RTC_Correction_T Correction;
	RTC_APH_T        APH;
	RTC_MS_T         MS;
	RTC_YM_T         YM;
	RTC_DW_T         DW;
	RTC_AHMS_T       AHMS;
	RTC_AYMD_T       AYMD;
} RTC_T;

/*----------------------------- I2C Controller -------------------------------*/
typedef struct
{
    __IO uint32_t  I2CEn:1;
    __IO uint32_t  TOEn:1;
    __IO uint32_t  GCRst:1;
    __I  uint32_t  RESERVE0:5;
    __O  uint32_t  MASK0:8;
    __I  uint32_t  RESERVE1:16;
} I2C_CFG_T;

typedef struct
{
    __IO uint32_t  ANA:1;
    __IO uint32_t  IRQFg:1;
    __IO uint32_t  STOP:1;
    __IO uint32_t  START:1;
    __IO uint32_t  EIRQFg:1;
    __IO uint32_t  En3B:1;
    __IO uint32_t  En10b:1;
    __IO uint32_t  SEn:1;
    //__I  uint32_t  RESERVE0:5;  //# 多餘會有bug
    __O  uint32_t  MASK0:8;
    __I  uint32_t  ARB:1;
    __I  uint32_t  GC:1;
    __I  uint32_t  ANAFg:1;
    __I  uint32_t  DF:1;
    __I  uint32_t  RW:1;
    __I  uint32_t  RStart:1;
    __I  uint32_t  SAct:1;
    __I  uint32_t  MAct:1;
    __I  uint32_t  RESERVE1:8;
} I2C_ACT_T;

typedef struct
{
    __IO uint32_t  TOLimit:4;
    __IO uint32_t  TOps:3;
    __IO uint32_t  TOFg:1;
    __O  uint32_t  MASK0:8;
    __IO uint32_t  CGR:8;
    __O  uint32_t  MASK1:8;
} I2C_CTCR_T;

typedef struct
{
    __IO uint32_t  Valid0:1;
    __IO uint32_t  SlaveID0:7;
    __IO uint32_t  Valid1:1;
    __IO uint32_t  SlaveID1:7;
    __I  uint32_t  RESERVE0:1;
    __IO uint32_t  SID0MASK:7;
    __IO uint32_t  SID1MASK:8;
} I2C_SID_T;

typedef struct
{
    __IO uint32_t  RWD0:1;
    __IO uint32_t  RAD:7;
    __I  uint32_t  RESERVE0:24;
} I2C_RAD_T;

typedef struct
{
    __IO uint32_t  TWD0:1;
    __IO uint32_t  TAD0:7;
    __IO uint32_t  TAD1:8;
    __IO uint32_t  TAD2:8;
} I2C_TAD_T;

typedef struct
{
	I2C_CFG_T      CFG;
	I2C_ACT_T      ACT;
	I2C_CTCR_T     CTCR;
	I2C_SID_T      SID;
	I2C_RAD_T      RAD;
	I2C_TAD_T      TAD;
} I2C_T;
/******************************************************************************/
/*                         Peripheral memory map                              */
/******************************************************************************/
#define INTERRUPT_BASE		0x00040000  /* Interrupt base address */
#define SYSTEM_BASE		0x00040100  /* System base address */
#define WATCHDOG_BASE         0x00040108  /* Watch dog base address */
#define Timer_BASE            0x00040c00  /* Timer base address */
#define CLOCK_BASE		0x00040300  /* CLOCK base address */
#define PMU_BASE			0x00040400  /* PMU base address */
#define GPIO_BASE			0x00040800  /* GPIO base address */
#define UART_BASE			0x00040e00  /* UART base address */
#define SPI_BASE			0x00040f00  /* SPI base address */
#define ADC_BASE			0x00041100  /* ADC base address */
#define DAC_BASE			0x00041700  /* DAC base address */
#define CMP_BASE		   	0x00041800  /* CMP base address */
#define OP_BASE		     	0x00041900  /* OP base address */
#define LCD_BASE              0x00041B00  /* LCD base address */
#define DEBUG_BASE		0x0004ff00  /* DEBUG base address */

/* Peripheral and SRAM base address */
#define ILM_BASE            ((     uint32_t)0x00080000)
#define DLM_BASE            ((     uint32_t)0x00000000)
#define APB_BASE            ((     uint32_t)0x00040000)

/* Peripheral memory map */
#define _INT_BASE          (APB_BASE        + 0x0000)
#define _TIME_BASE         (APB_BASE        + 0x0004)
#define _INT_GPIO_BASE     (APB_BASE        + 0x0010)

#define _GPIO_BASE         (APB_BASE        + 0x0800)
#define _PT1_BASE          (GPIO_BASE               )
#define _PT2_BASE          (GPIO_BASE       + 0x0010)

#define RTC_BASE           (APB_BASE        + 0x1A00)
#define I2C_BASE           (APB_BASE        + 0x1000)

/******************************************************************************/
/*                         Peripheral declaration                             */
/******************************************************************************/
#define _INT_GPIO          ((GPIO_T *) _INT_GPIO_BASE)
#define INT_TIME           ((INT_T *) _INT_BASE)
#define INT_COM            ((INT_T *) _INT_BASE)
#define _PT1               ((GPIO_T *) _PT1_BASE)
#define _PT2               ((GPIO_T *) _PT2_BASE)

#define RTC                ((RTC_T *) RTC_BASE)
#define I2C                ((I2C_T *) I2C_BASE)

extern int BurnWord(unsigned int addr,unsigned int DelayTime,unsigned int data);
extern int BurnPage(unsigned int addr,unsigned int DelayTime,int* data);

#endif /* HY16F188_H_ */







