/*
 * FPGA_register_initial.c
 *
 *  Created on: 2011/11/11
 *      Author: Eric.Lai
 */
#include "HY16F3981.h"
#include "DrvCMP.h"
#include "DrvOP.h"
#include "DrvADC.h"
//#include "DrvSPI.h"
#include "DrvPMU.h"
#include "DrvUART.h"
#include "DrvDAC.h"
#include "DrvClock.h"
#include "SpecialMacro.h"
#include "System.h"
#include "DrvTimer.h"
#include "DrvGPIO.h"

void Initial_CMP_Register(void)
{
	unsigned int l_reg;
	l_reg=CMP_INPUT;
	outw(l_reg,0xff00ff00);
	l_reg=CMP_CTRL0;
	outw(l_reg,0xff00ff00);
}

void Initial_OP_Register(void)
{
	unsigned int l_reg;
	l_reg=OP_INPUT;
	outw(l_reg,0xff00ff00);
	l_reg=OP_CTRL;
	outw(l_reg,0xff00ff00);
}

void Initial_ADC_Register(void)
{
	unsigned int l_reg;
	l_reg=R_ADC_CTRL1;
	outw(l_reg,0xff00ff00);
	l_reg=R_ADC_CTRL2;
	outw(l_reg,0x0000ff00);
}

void Initial_PMU_Register(void)
{
	unsigned int l_reg;
	l_reg=PMU_CTRL;
	outw(l_reg,0xff00ff00);
}

/*void Initial_SPI_Register(void)
{
	unsigned int l_reg;
	l_reg=R_SPI_CTRL;
	outw(l_reg,0xff00ff00);
	l_reg=R_SPI_FLAG;
	outw(l_reg,0x00000000);
	l_reg=R_SPI_INPUT_BUFFER;
	outw(l_reg,0x00000000);
	l_reg=R_SPI_OUTPUT_BUFFER;
	outw(l_reg,0x00000000);
}*/

void Initial_UART_Register(void)
{
	unsigned int l_reg;
	l_reg=R_UART_CTRL1;
	outw(l_reg,0x0000ff00);
	//l_reg=R_UART_FLAG;
	//outw(l_reg,0x00000000);
	l_reg=R_UART_CTRL2;
	outw(l_reg,0x0000ff00);
	l_reg=R_UART_BRGRH;
	outw(l_reg,0x00000000);
	l_reg=R_UART_BRGRL;
	outw(l_reg,0x00000000);
	l_reg=R_UART_TXREG;
	outw(l_reg,0x00000000);
}

void Initial_DAC_Register(void)
{
	unsigned int l_reg;
	l_reg=R_DAC_CTRL1;
	outw(l_reg,0x0000ff00);
	l_reg=R_DAC_CTRL2;
	outw(l_reg,0x00000000);
}

void Initial_Clock_Register(void)
{
	unsigned int l_reg;
	l_reg=R_CLOCK_CTRL1;
	outw(l_reg,0x00000101);
	l_reg=R_CLOCK_CTRL1;
	outw(l_reg,0x0000fe01);
	l_reg=R_CLOCK_TRIM;
	outw(l_reg,0x00000080);
	l_reg=R_CLOCK_CTRL2;
	outw(l_reg,0xff00ff00);
}

void Initial_SYS_Register(void)
{
	unsigned int l_reg;
	l_reg=R_SYSTEM_FLAG;
	outw(l_reg,0xff00fe00);
}

void Initial_INT_Register(void)
{
	unsigned int l_reg;
	l_reg=INTERRUPT_BASE+OFFSET00;
	outw(l_reg,0xff00ff00);
	l_reg=INTERRUPT_BASE+OFFSET04;
	outw(l_reg,0xff00ff00);
	l_reg=INTERRUPT_BASE+OFFSET08;
	outw(l_reg,0xff00ff00);
	l_reg=INTERRUPT_BASE+OFFSET0C;
	outw(l_reg,0xff00ff00);
	l_reg=INTERRUPT_BASE+OFFSET10;
	outw(l_reg,0xff00ff00);
	l_reg=INTERRUPT_BASE+OFFSET14;
	outw(l_reg,0xff00ff00);
}

void Initial_WDT_Register(void)
{
	unsigned int l_reg;
	l_reg=WATCHDOG_BASE;
	outw(l_reg,0x0000ff00);
}

void Initial_TIMER_Register(void)
{
	unsigned int l_reg;
	l_reg=TMA_BASE;
	outw(l_reg,0x0000ff0f);
	l_reg=TMB_BASE;
	outw(l_reg,0xff00ff00);
	l_reg=TMB_BASE+OFFSET08;
	outw(l_reg,0x0000ffff);
	l_reg=TMB_BASE+OFFSET0C;
	outw(l_reg,0xffffffff);
	l_reg=TMC_BASE;
	outw(l_reg,0xff00ff00);
}
void Initial_GPIO_Register(void)
{
	unsigned int l_reg;
	l_reg=GPIO_BASE;
	outw(l_reg,0xff00ff00);
	l_reg=GPIO_BASE+OFFSET04;
	outw(l_reg,0xff00ff00);
	l_reg=GPIO_BASE+OFFSET08;
	outw(l_reg,0x00000000);
	l_reg=GPIO_BASE+OFFSET0C;
	outw(l_reg,0x00000000);
	l_reg=GPIO_BASE+OFFSET10;
	outw(l_reg,0xff00ff00);
	l_reg=GPIO_BASE+OFFSET14;
	outw(l_reg,0xff00ff00);
	l_reg=GPIO_BASE+OFFSET18;
	outw(l_reg,0x00000000);
	l_reg=GPIO_BASE+OFFSET1C;
	outw(l_reg,0x00000000);
	l_reg=GPIO_BASE+OFFSET20;
	outw(l_reg,0xff00ff00);
	l_reg=GPIO_BASE+OFFSET24;
	outw(l_reg,0xff00ff00);
	l_reg=GPIO_BASE+OFFSET28;
	outw(l_reg,0x00000000);
	l_reg=GPIO_BASE+OFFSET2C;
	outw(l_reg,0x00000000);
	l_reg=GPIO_BASE+OFFSET30;
	outw(l_reg,0xff00ff00);
	l_reg=GPIO_BASE+OFFSET34;
	outw(l_reg,0xff00ff00);
	l_reg=GPIO_BASE+OFFSET38;
	outw(l_reg,0x00000000);
	l_reg=GPIO_BASE+OFFSET3C;
	outw(l_reg,0x00000000);
	l_reg=GPIO_BASE+OFFSET40;
	outw(l_reg,0xff00ff00);
	l_reg=GPIO_BASE+OFFSET44;
	outw(l_reg,0x0000ff00);
}

void Initial_DEBUG_Register(void)
{
	unsigned int l_reg;
	l_reg=DEBUG_BASE;
	outw(l_reg,0xff00ff00);
	l_reg=DEBUG_BASE+OFFSET04;
	outw(l_reg,0xff00ff03);
}

void MCU_Initial(void)
{
	//Initial_CMP_Register();
	//Initial_OP_Register();
	//Initial_ADC_Register();
	//Initial_SPI_Register();
	//Initial_PMU_Register();
	//Initial_UART_Register();
	//Initial_DAC_Register();
	//Initial_Clock_Register();
	//Initial_SYS_Register();
	//Initial_INT_Register();
	//Initial_WDT_Register();
	//Initial_TIMER_Register();
	//Initial_GPIO_Register();
	//Initial_DEBUG_Register();
}












