/*
 * DrvUART.h
 *
 * Created on: 2014/06/3
 * Author: MARCK
 */

#ifndef DRVUART_H_
#define DRVUART_H_
#include "HY16F3981.h"

#ifndef E_FAIL
#define E_FAIL		1
#endif
#define E_DRVUART_ARGUMENT E_FAIL

#ifndef E_SUCCESS
#define E_SUCCESS		0
#endif

typedef enum
{
	E_UART_ERR_CLOCK = 2,
	E_UART_ERR_BAUDRAET,
	E_UART_ERR_PARITY,
	E_UART_ERR_DATABIT,
	E_UART_ERR_STOPBIT,
	E_UART_ERR_OUTPIN
} E_UART_ERROR_MESSAGE;

typedef enum
{
	B1200  =1200,
	B2400  =2400,
	B4800  =4800,
	B9600  =9600,
	B14400 =14400,
	B19200 =19200,
	B38400 =38400,
	B57600 =57600,
	B115200 =115200
} E_BAUD_RATE_SETTINGS;

typedef enum
{
	DRVUART_PARITY_NONE  = 0,
	DRVUART_PARITY_EVEN,
	DRVUART_PARITY_ODD
} E_PARITY_SETTINGS;

typedef enum
{
	DRVUART_DATABITS_5 = 0,
	DRVUART_DATABITS_6,
	DRVUART_DATABITS_7,
	DRVUART_DATABITS_8
} E_DATABITS_SETTINGS;
typedef enum
{
	DRVUART_STOPBITS_05 = 0,
	DRVUART_STOPBITS_1,
	DRVUART_STOPBITS_15,
	DRVUART_STOPBITS_2
} E_STOPBITS_SETTINGS;
#ifdef  UART_BASE
#define R_UART_CTRL1 (UART_BASE+OFFSET00)
                                          //#define R_UART_FLAG  (UART_BASE+OFFSET04)
#define R_UART_CTRL2 (UART_BASE+OFFSET04) //R_UART_CTRL2 (UART_BASE+OFFSET08)
#define R_UART_BAUDRATE (UART_BASE+OFFSET08)  //HY16F198
#define R_UART_BRGRH (UART_BASE+OFFSET0C)
#define R_UART_BRGRL (UART_BASE+OFFSET10)
#define R_UART_TXREG (UART_BASE+OFFSET0C)
#define R_UART_RCREG (UART_BASE+OFFSET0C)

#define R_UART2_CTRL1 (UART_BASE+OFFSET10)                                    
#define R_UART2_CTRL2 (UART_BASE+OFFSET14) 
#define R_UART2_BAUDRATE (UART_BASE+OFFSET18)  
#define R_UART2_TXREG (UART_BASE+OFFSET1C)
#define R_UART2_RCREG (UART_BASE+OFFSET1C)
#endif

#ifdef  CLOCK_BASE
#define R_UART_CLOCK (CLOCK_BASE+OFFSET08)
#define R_UART2_CLOCK (CLOCK_BASE+OFFSET10)
#endif

#ifdef  INTERRUPT_BASE
#define R_UART_INT_CTRL  (INTERRUPT_BASE+OFFSET00)
#define R_UART2_INT_CTRL (INTERRUPT_BASE+OFFSET18)
#endif

#ifdef GPIO_BASE
#define R_UART_GPIO     (GPIO_BASE+OFFSET44)
#define R_UART2_GPIO    (GPIO_BASE+OFFSET4C)
#endif

//0X40E00
#define PLEN   		    6
#define DLEN    		    4
#define RXIT                3
#define RXEN   		    2
#define TXIT                1
#define TXEN		    0
#define PLEN_MASK  	    (PLEN+MASK)
#define DLEN_MASK  	    (DLEN+MASK)
#define RXIT_MASK  	    (RXIT+MASK)
#define RXEN_MASK  	    (RXEN+MASK)
#define TXIT_MASK		    (TXIT+MASK)
#define TXEN_MASK	          (TXEN+MASK)


//0X40E04

#define ABDF                  4
#define ABDEN   		      3
#define RXWUEN    		2
#define PRTEN	            1
#define PRTODD	            0
#define ABDF_MASK  		(ABDF+MASK)
#define ABDEN_MASK  		(ABDEN+MASK)
#define RXWUEN_MASK 		(RXWUEN+MASK)
#define PRTEN_MASK	      (PRTEN+MASK)
#define PRTODD_MASK	      (PRTODD+MASK)

#define OERR    		      23
#define NERR    			22
#define FERR   			21
#define PERR    			20
#define TXBUSY                19
#define TXBF                  18
#define RXBUSY   		      17
#define RXBF	            16
#define OERR_MASK  	     (OERR+MASK)
#define NERR_MASK            (NERR+MASK)
#define FERR_MASK  	     (FERR+MASK)
#define PERR_MASK  	     (PERR+MASK)
#define TXBUSY_MASK          (TXBUSY+MASK)
#define TXBF_MASK  	     (TXBF+MASK)
#define RXBUSY_MASK          (RXBUSY+MASK)
#define RXBF_MASK            (RXBF+MASK)


#define USel    			21
#define UCLK_En    			20
#define UCLK_Div   			16
#define USel_MASK    		(USel+MASK)
#define UCLK_En_MASK 		(UCLK_En+MASK)
#define UCLK_Div_MASK		(UCLK_Div+MASK)
#define UCLK_Div_MAX		15

//0x40844
#define UAPS  			    1
#define UAPTOE 			    0
#define UAPS_MASK  		    (UAPS+MASK)
#define UAPTOE_MASK		    (UAPTOE+MASK)
#define UAPS_MAX  		    7

#define UART_TXIE     		19
#define UART_RXIE     		18
#define UART_TXIF     		3
#define UART_RXIF     		2
#define UART_TXIE_MASK      (UART_TXIE+MASK)
#define UART_RXIE_MASK      (UART_RXIE+MASK)
#define UART_TXIF_MASK      (UART_TXIF+MASK)
#define UART_RXIF_MASK      (UART_RXIF+MASK)

unsigned int DrvUART_Open(
		       unsigned int uClock,
		unsigned int uBaudRate ,
		unsigned int uParity,
		unsigned int uDataBits,
		unsigned int uStopBits,
		unsigned int uOuputPin);
void DrvUART_Close(void);
void DrvUART_Enable(void);
unsigned int DrvUART_EnableInt(unsigned int uTXIE, unsigned int uRXIE);
unsigned int DrvUART_IntType(unsigned int uTXIT, unsigned int uRXIT);
unsigned int DrvUART_GetTxFlag(void);
unsigned int DrvUART_GetRxFlag(void);
void DrvUART_ClrTxFlag(void);
void DrvUART_ClrRxFlag(void);
unsigned int DrvUART_Read(void);

void DrvUART_Write(unsigned int uData);

void DrvUART_EnableWakeUp(void);
void DrvUART_DisableWakeUp(void);

void DrvUART_Enable_AutoBaudrate(void);
void DrvUART_Disable_AutoBaudrate(void);

unsigned int DrvUART_GetPERR(void);
unsigned int DrvUART_GetFERR(void);
unsigned int DrvUART_GetOERR(void);
unsigned int DrvUART_GetNERR(void);
unsigned int DrvUART_GetABDOVF(void);

void DrvUART_ClrNERR(void);
void DrvUART_ClrOERR(void);
void DrvUART_ClrPERR(void);
void DrvUART_ClrFERR(void);
void DrvUART_ClrABDOVF(void);

unsigned int DrvUART_TRStatus(unsigned int uMode);
unsigned int DrvUART_CheckTRMT(void);
unsigned int DrvUART_ClkEnable(unsigned int uclk,unsigned int uprescale);
void DrvUART_ClkDisable(void);

unsigned char DrvUART_ConfigIO(unsigned char ioen,unsigned int uOuputPin);

//UART2 SUBROUTINE
unsigned int DrvUART2_Open(
		       unsigned int uClock,
		unsigned int uBaudRate ,
		unsigned int uParity,
		unsigned int uDataBits,
		unsigned int uStopBits,
		unsigned int uOuputPin);
void DrvUART2_Close(void);
void DrvUART2_Enable(void);
unsigned int DrvUART2_EnableInt(unsigned int uTXIE, unsigned int uRXIE);
unsigned int DrvUART2_IntType(unsigned int uTXIT, unsigned int uRXIT);
unsigned int DrvUART2_GetTxFlag(void);
unsigned int DrvUART2_GetRxFlag(void);
void DrvUART2_ClrTxFlag(void);
void DrvUART2_ClrRxFlag(void);
unsigned int DrvUART2_Read(void);

void DrvUART2_Write(unsigned int uData);

void DrvUART2_EnableWakeUp(void);
void DrvUART2_DisableWakeUp(void);

void DrvUART2_Enable_AutoBaudrate(void);
void DrvUART2_Disable_AutoBaudrate(void);

unsigned int DrvUART2_GetPERR(void);
unsigned int DrvUART2_GetFERR(void);
unsigned int DrvUART2_GetOERR(void);
unsigned int DrvUART2_GetNERR(void);
unsigned int DrvUART2_GetABDOVF(void);

void DrvUART2_ClrNERR(void);
void DrvUART2_ClrOERR(void);
void DrvUART2_ClrPERR(void);
void DrvUART2_ClrFERR(void);
void DrvUART2_ClrABDOVF(void);

unsigned int DrvUART2_TRStatus(unsigned int uMode);
unsigned int DrvUART2_CheckTRMT(void);
unsigned int DrvUART2_ClkEnable(unsigned int uclk,unsigned int uprescale);
void DrvUART2_ClkDisable(void);

unsigned char DrvUART2_ConfigIO(unsigned char ioen,unsigned int uOuputPin);

#endif /* DRVUART_H_ */


