/*
 *  Created on: 2016/7/28
 *  Author: Robert.Wang
 *  Memo : HY16F3981 DrvUART.c is base on HY16F198B to modify
*/

#include "DrvUART.h"
#include "SpecialMacro.h"

/****************************************************************************
*name:     DrvUART_Open()
*function: setting the CLOCK /BaudRate/DataBits/SotpBits/outputPin for UART
*input:    uclock uBaudRate uParity uDataBits uStopBits uOutpin
*output:
*version:  v1.0
*date:     2014-5-31
*modify:
*2016-1-11 : change 'uclock' data type from 'unsigned int' to 'float';
*change'l_data=(uClock*1000000/(1<<l_temp)/uBaudRate/4);' to 'l_data=(uClock*1000000/(1<<l_temp)/uBaudRate/4)-1;'
****************************************************************************/
unsigned int DrvUART_Open(
		unsigned int uClock,
		unsigned int uBaudRate ,
		unsigned int uParity,
		unsigned int uDataBits,
		unsigned int uStopBits,
		unsigned int uOuputPin)
{
	unsigned int l_reg,l_data,ReturnVal,l_temp;
	unsigned int l_uClock_division_uBaudRate_quotient, l_uClock_division_uBaudRate_remainder,
	l_uClock_division_l_temp_quotient, l_uClock_division_l_temp_remainder,
	l_uClock_division_4_quotient,l_uClock_division_4_remainder;

	ReturnVal=0;
	if(uClock>20000){return E_UART_ERR_CLOCK;}
	if(uBaudRate==0){return E_UART_ERR_BAUDRAET;}
	else{
		l_reg=R_UART_CLOCK;
		l_temp=((inw(l_reg)&(UCLK_Div_MAX<<UCLK_Div))>>UCLK_Div);
		//GoalBaudRate=((uClock*1000/(1<<l_temp)/uBaudRate/4)-1)+0.5;

		l_uClock_division_uBaudRate_quotient=((uClock*1000)/uBaudRate);
		l_uClock_division_uBaudRate_remainder=(((uClock*1000)%uBaudRate)*100)/uBaudRate;
		if(l_uClock_division_uBaudRate_remainder>=50)  //If decimal point >= 0.50  -->2021/09/06 robert modify
		{
		  l_uClock_division_uBaudRate_quotient++;
		}

		l_uClock_division_l_temp_quotient=l_uClock_division_uBaudRate_quotient/(1<<l_temp);
		l_uClock_division_l_temp_remainder=((l_uClock_division_uBaudRate_quotient%(1<<l_temp))*100)/l_uClock_division_uBaudRate_quotient;

		if(l_uClock_division_l_temp_remainder>=50)  //If decimal point >= 0.50  -->2021/09/06 robert modify
		{
		  l_uClock_division_l_temp_quotient++;
		}

		l_uClock_division_4_quotient=l_uClock_division_l_temp_quotient/4;
		l_uClock_division_4_remainder=((l_uClock_division_l_temp_quotient%4)*100)/4;  //-->2021/09/06 robert modify

		if(l_uClock_division_4_remainder>=50)  //If decimal point >= 0.50  -->2021/09/06 robert modify
		{
		  l_uClock_division_4_remainder++;
		}

		l_uClock_division_4_quotient=l_uClock_division_4_quotient-1;  //get the final result

		l_reg=R_UART_BAUDRATE;
		outw(l_reg,(l_uClock_division_4_quotient&0x0000ffff));
	}

	if(uParity>2){return E_UART_ERR_PARITY;}
	else{
		switch(uParity)
		{
		    case 0:
		    	l_temp=(0<<PRTEN)|(1<<PRTEN_MASK);
		    	l_data=(0<<PRTODD)|(1<<PRTODD_MASK);
		    break;
		    case 1:
		    	l_temp=(1<<PRTEN)|(1<<PRTEN_MASK);
		    	l_data=(0<<PRTODD)|(1<<PRTODD_MASK);
		    break;
		    case 2:
		    	l_temp=(1<<PRTEN)|(1<<PRTEN_MASK);
		    	l_data=(1<<PRTODD)|(1<<PRTODD_MASK);
		    break;
		    default: break;
		}
		l_temp=l_data|l_temp;
		l_reg=R_UART_CTRL2;
		outw(l_reg,l_temp);

	}
	if(uDataBits>3){return E_UART_ERR_DATABIT;}
	else{
		if(uParity==0)uDataBits--;
		l_data=(uDataBits<<DLEN)|(0x3<<DLEN_MASK);
		l_reg=R_UART_CTRL1;
		outw(l_reg,l_data);
	}
	if(uStopBits>3){return E_UART_ERR_STOPBIT;}
	else{
		l_data=(uStopBits<<PLEN)|(0x3<<PLEN_MASK);
		l_reg=R_UART_CTRL1;
		outw(l_reg,l_data);
	}
	if(uOuputPin>UAPS_MAX){return E_UART_ERR_OUTPIN;}
	else{l_data=(uOuputPin<<UAPS)|(UAPS_MAX<<UAPS_MASK)|(1<<UAPTOE)|(1<<UAPTOE_MASK);
	   l_reg=R_UART_GPIO;
	   outw(l_reg,l_data);
	}
	l_data=(0X1<<RXEN)|(0X1<<RXEN_MASK)|(0X1<<TXEN)|(0X1<<TXEN_MASK);
	l_reg=R_UART_CTRL1;
	outw(l_reg,l_data);

	return ReturnVal;
}


/****************************************************************************
*name:     DrvUART_Enable(void)
*function: enable UART
*input:    NO
*output:
*version:  v1.0
*date:     2014-5-31
*modify:   NO
****************************************************************************/
void DrvUART_Enable(void)
{
	unsigned int l_reg,l_data;
	l_data=(0X1<<RXEN)|(0X1<<RXEN_MASK)|(0X1<<TXEN)|(0X1<<TXEN_MASK);
	l_reg=R_UART_CTRL1;
	outw(l_reg,l_data);
}
/****************************************************************************
*name:     DrvUART_Close(void)
*function: disable UART
*input:    NO
*output:
*version:  v1.0
*date:     2014-5-31
*modify:   NO
****************************************************************************/
void DrvUART_Close(void)
{
	unsigned int l_reg,l_data;
	l_data=(0X1<<RXEN_MASK)|(0X1<<TXEN_MASK);
	l_reg=R_UART_CTRL1;
	outw(l_reg,l_data);
}
/****************************************************************************
*name    : DrvUART_EnableInt(unsigned int uTXIE, unsigned int uRXIE)
*function: Enable the RX AND TX interrupt
*input   : uTXIE/uRXIE
*          0 disable the interrupt
*          1 enable the interrupt
*output  : 0 success
*          others: fail
*version : v1.0
*date    : 2014-5-30
*modify  : NO
****************************************************************************/
unsigned int DrvUART_EnableInt(unsigned int uTXIE, unsigned int uRXIE)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=R_UART_INT_CTRL;
	if(uTXIE>1){return E_DRVUART_ARGUMENT;}
	else if(uTXIE==0){l_data=(0<<UART_TXIE)|(1<<UART_TXIE_MASK);}
	else if(uTXIE==1){l_data=(1<<UART_TXIE)|(1<<UART_TXIE_MASK);}
	if(uRXIE>1){return E_DRVUART_ARGUMENT;}
	else if(uRXIE==0){l_data|=(0<<UART_RXIE)|(1<<UART_RXIE_MASK);}
	else if(uRXIE==1){l_data|=(1<<UART_RXIE)|(1<<UART_RXIE_MASK);}
	outw(l_reg,l_data);
	if((uTXIE==1)||(uRXIE==1)){
	    //l_data=__nds32__mfsr(NDS32_SR_INT_MASK);
	    //SETBIT(l_data,0);
	    //__nds32__mtsr(l_data, NDS32_SR_INT_MASK);
	}
	else{
		//l_data=__nds32__mfsr(NDS32_SR_INT_MASK);
		//CLRBIT(l_data,0);
		//__nds32__mtsr(l_data, NDS32_SR_INT_MASK);
	}
	return ReturnVal;
}

/****************************************************************************
*name    : DrvUART_IntType(unsigned int uTXIT, unsigned int uRXIT)
*function: SETTING The RX AND TX interrupt TYPE
*input   : uTXIT/uRXIT
*          uTXIT:
*          0 the interrupt happen when the TX data buffer is empty,till write data to TX buffer
*          1 the interrupt happen when the data be transimited
*          uRXIT:
*          0 the interrupt happen when the RX data buffer is full,till the data be read.
*          1 the interrupt happen when receivce the data.
*output  : 0 success
*          others: fail
*version : v1.0
*date    : 2014-5-31
*modify  : NO
****************************************************************************/
unsigned int DrvUART_IntType(unsigned int uTXIT, unsigned int uRXIT)
{
	unsigned int l_reg,l_data;
	if((uTXIT>1)||(uRXIT>1))
		return E_FAIL;
	l_data=(uTXIT<<TXIT)|(0X1<<TXIT_MASK)|(uRXIT<<RXIT)|(0X1<<RXIT_MASK);
	l_reg=R_UART_CTRL1;
	outw(l_reg,l_data);
	return E_SUCCESS;
}

/****************************************************************************
*name    : DrvUART_GetTxFlag()
*function: read the TXIF
*input   : no
*output  : TXIF value
*version : v1.0
*date    : 2014-5-30
*modify  : NO
****************************************************************************/
unsigned int DrvUART_GetTxFlag()
{
	unsigned int l_reg,ReturnVal;
	ReturnVal=0;
	l_reg=R_UART_INT_CTRL;
	//Robert Add 2016/8/5
	//ReturnVal=((inw(l_reg)&(1<<UART_TXIF))>>UART_TXIF);
	//return ReturnVal;
	ReturnVal=((inw(l_reg)&0x08)>>(3));  //Read 0x40000[3]
	return ReturnVal;
}
/****************************************************************************
*name    : DrvUART_GetRxFlag()
*function: read the RXIF
*input   : no
*output  : RXIF value
*version : v1.0
*date    : 2014-5-30
*modify  : NO
****************************************************************************/
unsigned int DrvUART_GetRxFlag(void)
{
	unsigned int l_reg,ReturnVal;
	ReturnVal=0;
	l_reg=R_UART_INT_CTRL;
	//Robert Add 2016/8/5
	//ReturnVal=((inw(l_reg)&(1<<UART_RXIF))>>UART_RXIF);
	//return ReturnVal;
	ReturnVal=((inw(l_reg)&0x04)>>(2));  //Read 0x40000[2]
	return ReturnVal;
}

void DrvUART_ClrTxFlag(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_UART_INT_CTRL;
	l_data=(1<<UART_TXIF_MASK);
	outw(l_reg,l_data);
}

void DrvUART_ClrRxFlag(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_UART_INT_CTRL;
	l_data=(1<<UART_RXIF_MASK);
	outw(l_reg,l_data);
}

/****************************************************************************
*name    : DrvUART_Read(void)
*function: read the RX data
*input   : no
*output  : RX data value of 5~9 Bits
*version : v1.0
*date    : 2014-5-30
*modify  : NO
****************************************************************************/
unsigned int DrvUART_Read(void)
{
	unsigned int l_reg;
	l_reg=R_UART_RCREG;
	return (inw(l_reg)&0x000001ff);
}
/****************************************************************************
*name    : DrvUART_Write(unsigned int uData)
*function: write data to TX buffer
*input   : uData :5~9 Bits
*output  : NO
*version : v1.0
*date    : 2014-5-30
*modify  : NO
****************************************************************************/
void DrvUART_Write(unsigned int uData)
{
	unsigned int l_reg,l_data;
	l_reg=R_UART_TXREG;
	l_data=(uData<<16)+(inw(l_reg)&0xffff);
	outw(l_reg,l_data);
}

void DrvUART_EnableWakeUp(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_UART_CTRL2;
	l_data=(1<<RXWUEN)|(1<<(RXWUEN_MASK));
	outw(l_reg,l_data);
}

void DrvUART_DisableWakeUp(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_UART_CTRL2;
	l_data=(1<<RXWUEN_MASK);
	outw(l_reg,l_data);
}

void DrvUART_Enable_AutoBaudrate(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_UART_CTRL2;
	l_data=(1<<ABDEN)|(1<<(ABDEN_MASK));
	outw(l_reg,l_data);
}

void DrvUART_Disable_AutoBaudrate(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_UART_CTRL2;
	l_data=(1<<ABDEN_MASK);
	outw(l_reg,l_data);
}

/*
modify: change '&0xff000000' to '&0x100000'  20150922
*/
unsigned int DrvUART_GetPERR(void)
{
	unsigned int l_reg,ReturnVal;
	ReturnVal=0;
	l_reg=R_UART_CTRL1;
	ReturnVal=((inw(l_reg)&0X100000)>>PERR);
	return ReturnVal;
}
/*
modify: change '&0xff000000' to '&0x200000'  20150922
*/
unsigned int DrvUART_GetFERR(void)
{
	unsigned int l_reg,ReturnVal;
	ReturnVal=0;
	l_reg=R_UART_CTRL1;
	ReturnVal=((inw(l_reg)&0X200000)>>FERR);
	return ReturnVal;
}
/*
modify: change '&0xff000000' to '&0x800000'  20150922
*/
unsigned int DrvUART_GetOERR(void)
{
	unsigned int l_reg,ReturnVal;
	ReturnVal=0;
	l_reg=R_UART_CTRL1;
	ReturnVal=((inw(l_reg)&0X800000)>>OERR);
	return ReturnVal;
}
/*
modify: change '&0xff000000' to '&0x400000'  20150922
*/
unsigned int DrvUART_GetNERR(void)
{
	unsigned int l_reg,ReturnVal;
	ReturnVal=0;
	l_reg=R_UART_CTRL1;
	ReturnVal=((inw(l_reg)&0X400000)>>NERR);
	return ReturnVal;
}


void DrvUART_ClrFERR(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_UART_CTRL1;
	l_data=(1<<FERR_MASK);
	outw(l_reg,l_data);
}

void DrvUART_ClrPERR(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_UART_CTRL1;
	l_data=(1<<PERR_MASK);
	outw(l_reg,l_data);
}

void DrvUART_ClrOERR(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_UART_CTRL1;
	l_data=(1<<OERR_MASK);
	outw(l_reg,l_data);
}

void DrvUART_ClrNERR(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_UART_CTRL1;
	l_data=(1<<NERR_MASK);
	outw(l_reg,l_data);
}

unsigned int DrvUART_GetABDOVF(void)
{
	unsigned int l_reg,ReturnVal;
	ReturnVal=0;
	l_reg=R_UART_CTRL2;
	ReturnVal=((inw(l_reg)&0X10)>>ABDF);
	return ReturnVal;
}

void DrvUART_ClrABDOVF(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_UART_CTRL1;
	l_data=(1<<ABDF_MASK);
	outw(l_reg,l_data);
}

/****************************************************************************
*name    : DrvUART_TRStatus(unsigned int uMode)
*function: get the TX OR RX work status,include the RX/TX buffer;
*input   : umode :choose the TX OR RX work chanel
*          0 RXBF; 1 RXBUSY; 2 TXBF; 3 TXBUSY
*output  : the status value of UART(0X40E00);
*          TXBUSY: 0 idle; 1 Busy
*          TXBF  : 0 empty; 1  full
*          RXBUSY: 0 idle; 1 Busy
*          RXBF  : 0 empty; 1  full
*version : v1.0
*date    : 2014-6-3
*modify  : no
****************************************************************************/

unsigned int DrvUART_TRStatus(unsigned int uMode)
{
	unsigned int l_reg,l_data;
	if (uMode>3) return 0XFF;
	l_reg=R_UART_CTRL1;
	l_data=(inw(l_reg)>>(uMode+16))&0x01;
	return l_data;
}
/****************************************************************************
*name:     DrvUART_CheckTRMT(void)
*function: read transmit shift status bit TXBF;
*input:    no
*output:   the TXBF bit value of UART(0X40E00);
*version:  v1.0
*date:     2014-6-3
*modify:   no
****************************************************************************/
unsigned int DrvUART_CheckTRMT(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_UART_CTRL1;
	l_data=(inw(l_reg)&0x040000)>>TXBF;
	return l_data;
}
/****************************************************************************
*name    : DrvUART_ClkEnable();
*function: setting the UART clock source and setting divier;
*input   : uclk: clock source
*              0: external high speed osc
*              1: internal high speed osc
*          uprescale: clock divier;
*output  :
*version : v1.0
*date    : 2014-5-30
*modify  : no
****************************************************************************/
unsigned int DrvUART_ClkEnable(unsigned int uclk,unsigned int uprescale)
{
	unsigned int Return_value;
	unsigned int Reg_addr,l_data;
	Return_value=0;
	Reg_addr=R_UART_CLOCK;
	if(uprescale<16)
	{
		l_data=inw(Reg_addr)&0xfff0ffff;
		l_data=l_data+((uprescale<<16)&0x000f0000);
		l_data=0xff00ff00+l_data;

	}
	else
	{
		Return_value=1;
		return Return_value;
	}
	if(uclk==0)
	{
		CLRBIT(l_data,USel);
	}
	else
	{
		SETBIT(l_data,USel);
	}
	SETBIT(l_data,UCLK_En);
	outw(Reg_addr,l_data);
	return Return_value;
}
/****************************************************************************
*name     : DrvUART_ClkDisable();
*function : disable UART clock;
*input    : void
*output   : void
*version  : v1.0
*date     : 2013-11-28
*modify   : no
****************************************************************************/
void DrvUART_ClkDisable(void)
{
	unsigned int l_reg;
	l_reg=R_UART_CLOCK;
	outw(l_reg,0x10000000);
}

/*******************************************************************
*name    : DrvUART_ConfigIO
*function: ?离IO諳葩??UART籵?諳???寁IO?
*input   : ioen: 0 壽?IO諳葩?髡夔?1 羲?IO諳葩?髡?
*          uoutputPin: ??籵?IO?
*output  : 0?SUCCESS ?坻?扢离囮??
*Version : v1.0
*date    : 2014-5-30
*modify  : none
*********************************************************************/
unsigned char DrvUART_ConfigIO(unsigned char ioen,unsigned int uOuputPin)
{
	unsigned int l_reg,l_data;
	if((uOuputPin>UAPS_MAX)|(ioen>1)){return E_UART_ERR_OUTPIN;}
	else
	{
	    l_data=(uOuputPin<<UAPS)|(UAPS_MAX<<UAPS_MASK)|(ioen<<UAPTOE)|(1<<UAPTOE_MASK);
	    l_reg=R_UART_GPIO;
	    outw(l_reg,l_data);
	    return E_SUCCESS;
	}
}
/***************************UART2 FUNCTION*************************************/

/****************************************************************************
*name:     DrvUART2_Open()
*function: setting the CLOCK /BaudRate/DataBits/SotpBits/outputPin for UART2
*input:    uclock uBaudRate uParity uDataBits uStopBits uOutpin
*output:
*version:  v1.0
*date:     2014-5-31
*modify:
*2016-1-11 : change 'uclock' data type from 'unsigned int' to 'float';
*change'l_data=(uClock*1000000/(1<<l_temp)/uBaudRate/4);' to 'l_data=(uClock*1000000/(1<<l_temp)/uBaudRate/4)-1;'
****************************************************************************/
unsigned int DrvUART2_Open(
		unsigned int uClock,
		unsigned int uBaudRate ,
		unsigned int uParity,
		unsigned int uDataBits,
		unsigned int uStopBits,
		unsigned int uOuputPin)
{
	unsigned int l_reg,l_data,ReturnVal,l_temp;
	unsigned int l_uClock_division_uBaudRate_quotient, l_uClock_division_uBaudRate_remainder,
	l_uClock_division_l_temp_quotient, l_uClock_division_l_temp_remainder,
	l_uClock_division_4_quotient,l_uClock_division_4_remainder;

	ReturnVal=0;
	if(uClock>20000){return E_UART_ERR_CLOCK;}
	if(uBaudRate==0){return E_UART_ERR_BAUDRAET;}
	else{
		l_reg=R_UART2_CLOCK;
		l_temp=((inw(l_reg)&(UCLK_Div_MAX<<UCLK_Div))>>UCLK_Div);
		//GoalBaudRate=((uClock*1000/(1<<l_temp)/uBaudRate/4)-1)+0.5;

		l_uClock_division_uBaudRate_quotient=((uClock*1000)/uBaudRate);
		l_uClock_division_uBaudRate_remainder=(((uClock*1000)%uBaudRate)*100)/uBaudRate;
		if(l_uClock_division_uBaudRate_remainder>=50)  //If decimal point >= 0.50 -->2021/09/06 robert modify
		{
		  l_uClock_division_uBaudRate_quotient++;
		}

		l_uClock_division_l_temp_quotient=l_uClock_division_uBaudRate_quotient/(1<<l_temp);
		l_uClock_division_l_temp_remainder=((l_uClock_division_uBaudRate_quotient%(1<<l_temp))*100)/l_uClock_division_uBaudRate_quotient;

		if(l_uClock_division_l_temp_remainder>=50)  //If decimal point >= 0.50 -->2021/09/06 robert modify
		{
		  l_uClock_division_l_temp_quotient++;
		}

		l_uClock_division_4_quotient=l_uClock_division_l_temp_quotient/4;
		l_uClock_division_4_remainder=((l_uClock_division_l_temp_quotient%4)*100)/4;  //-->2021/09/06 robert modify

		if(l_uClock_division_4_remainder>=50)  //If decimal point >= 0.50  -->2021/09/06 robert modify
		{
		  l_uClock_division_4_remainder++;
		}

		l_uClock_division_4_quotient=l_uClock_division_4_quotient-1;  //get the final result

		l_reg=R_UART2_BAUDRATE;
		outw(l_reg,(l_uClock_division_4_quotient&0x0000ffff));
	}


	if(uParity>2){return E_UART_ERR_PARITY;}
	else{
		switch(uParity)
		{
		    case 0:
		    	l_temp=(0<<PRTEN)|(1<<PRTEN_MASK);
		    	l_data=(0<<PRTODD)|(1<<PRTODD_MASK);
		    break;
		    case 1:
		    	l_temp=(1<<PRTEN)|(1<<PRTEN_MASK);
		    	l_data=(0<<PRTODD)|(1<<PRTODD_MASK);
		    break;
		    case 2:
		    	l_temp=(1<<PRTEN)|(1<<PRTEN_MASK);
		    	l_data=(1<<PRTODD)|(1<<PRTODD_MASK);
		    break;
		    default: break;
		}
		l_temp=l_data|l_temp;
		l_reg=R_UART2_CTRL2;
		outw(l_reg,l_temp);

	}
	if(uDataBits>3){return E_UART_ERR_DATABIT;}
	else{
		if(uParity==0)uDataBits--;
		l_data=(uDataBits<<DLEN)|(0x3<<DLEN_MASK);
		l_reg=R_UART2_CTRL1;
		outw(l_reg,l_data);
	}
	if(uStopBits>3){return E_UART_ERR_STOPBIT;}
	else{

		l_data=(uStopBits<<PLEN)|(0x3<<PLEN_MASK);
		l_reg=R_UART2_CTRL1;
		outw(l_reg,l_data);
	}
	if(uOuputPin>UAPS_MAX){return E_UART_ERR_OUTPIN;}
	else{l_data=(uOuputPin<<UAPS)|(UAPS_MAX<<UAPS_MASK)|(1<<UAPTOE)|(1<<UAPTOE_MASK);
	   l_reg=R_UART2_GPIO;
	   outw(l_reg,l_data);
	}
	l_data=(0X1<<RXEN)|(0X1<<RXEN_MASK)|(0X1<<TXEN)|(0X1<<TXEN_MASK);
	l_reg=R_UART2_CTRL1;
	outw(l_reg,l_data);

	return ReturnVal;
}
/****************************************************************************
*name:     DrvUART2_Enable(void)
*function: enable UART2
*input:    NO
*output:
*version:  v1.0
*date:     2014-5-31
*modify:   NO
****************************************************************************/
void DrvUART2_Enable(void)
{
	unsigned int l_reg,l_data;
	l_data=(0X1<<RXEN)|(0X1<<RXEN_MASK)|(0X1<<TXEN)|(0X1<<TXEN_MASK);
	l_reg=R_UART2_CTRL1;
	outw(l_reg,l_data);
}
/****************************************************************************
*name:     DrvUART2_Close(void)
*function: disable UART2
*input:    NO
*output:
*version:  v1.0
*date:     2014-5-31
*modify:   NO
****************************************************************************/
void DrvUART2_Close(void)
{
	unsigned int l_reg,l_data;
	l_data=(0X1<<RXEN_MASK)|(0X1<<TXEN_MASK);
	l_reg=R_UART2_CTRL1;
	outw(l_reg,l_data);
}
/****************************************************************************
*name    : DrvUART2_EnableInt(unsigned int uTXIE, unsigned int uRXIE)
*function: Enable the RX AND TX interrupt
*input   : uTXIE/uRXIE
*          0 disable the interrupt
*          1 enable the interrupt
*output  : 0 success
*          others: fail
*version : v1.0
*date    : 2014-5-30
*modify  : NO
****************************************************************************/
unsigned int DrvUART2_EnableInt(unsigned int uTXIE, unsigned int uRXIE)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=R_UART2_INT_CTRL;
	if(uTXIE>1){return E_DRVUART_ARGUMENT;}
	else if(uTXIE==0){l_data=(0<<UART_TXIE)|(1<<UART_TXIE_MASK);}
	else if(uTXIE==1){l_data=(1<<UART_TXIE)|(1<<UART_TXIE_MASK);}
	if(uRXIE>1){return E_DRVUART_ARGUMENT;}
	else if(uRXIE==0){l_data|=(0<<UART_RXIE)|(1<<UART_RXIE_MASK);}
	else if(uRXIE==1){l_data|=(1<<UART_RXIE)|(1<<UART_RXIE_MASK);}
	outw(l_reg,l_data);
	if((uTXIE==1)|(uRXIE==1)){
	    //l_data=__nds32__mfsr(NDS32_SR_INT_MASK);
	    //SETBIT(l_data,0);
	    //__nds32__mtsr(l_data, NDS32_SR_INT_MASK);
	}
	else{
		//l_data=__nds32__mfsr(NDS32_SR_INT_MASK);
		//CLRBIT(l_data,0);
		//__nds32__mtsr(l_data, NDS32_SR_INT_MASK);
	}
	return ReturnVal;
}

/****************************************************************************
*name    : DrvUART2_IntType(unsigned int uTXIT, unsigned int uRXIT)
*function: SETTING The RX AND TX interrupt TYPE
*input   : uTXIT/uRXIT
*          uTXIT:
*          0 the interrupt happen when the TX data buffer is empty,till write data to TX buffer
*          1 the interrupt happen when the data be transimited
*          uRXIT:
*          0 the interrupt happen when the RX data buffer is full,till the data be read.
*          1 the interrupt happen when receivce the data.
*output  : 0 success
*          others: fail
*version : v1.0
*date    : 2014-5-31
*modify  : NO
****************************************************************************/
unsigned int DrvUART2_IntType(unsigned int uTXIT, unsigned int uRXIT)
{
	unsigned int l_reg,l_data;
	if((uTXIT>1)||(uRXIT>1))
		return E_FAIL;
	l_data=(uTXIT<<TXIT)|(0X1<<TXIT_MASK)|(uRXIT<<RXIT)|(0X1<<RXIT_MASK);
	l_reg=R_UART2_CTRL1;
	outw(l_reg,l_data);
	return E_SUCCESS;
}

/****************************************************************************
*name    : DrvUART2_GetTxFlag()
*function: read the TXIF
*input   : no
*output  : TXIF value
*version : v1.0
*date    : 2014-5-30
*modify  : NO
****************************************************************************/
unsigned int DrvUART2_GetTxFlag()
{
	unsigned int l_reg,ReturnVal;
	ReturnVal=0;
	l_reg=R_UART2_INT_CTRL;
	//Robert add 2016/8/5
	//ReturnVal=((inw(l_reg)&(1<<UART_TXIF))>>UART_TXIF);
	//return ReturnVal;
	ReturnVal=((inw(l_reg)&0x08)>>(3));  //Read 0x40018[3]
	return ReturnVal;
}
/****************************************************************************
*name    : DrvUART2_GetRxFlag()
*function: read the RXIF
*input   : no
*output  : RXIF value
*version : v1.0
*date    : 2014-5-30
*modify  : NO
****************************************************************************/
unsigned int DrvUART2_GetRxFlag(void)
{
	unsigned int l_reg,ReturnVal;
	ReturnVal=0;
	l_reg=R_UART2_INT_CTRL;
	//Robert add 2016/8/5
	//ReturnVal=((inw(l_reg)&(1<<UART_RXIF))>>UART_RXIF);
	//return ReturnVal;
	ReturnVal=((inw(l_reg)&0x04)>>(2));  //Read 0x40018[2]
	return ReturnVal;
}

void DrvUART2_ClrTxFlag(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_UART2_INT_CTRL;
	l_data=(1<<UART_TXIF_MASK);
	outw(l_reg,l_data);
}

void DrvUART2_ClrRxFlag(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_UART2_INT_CTRL;
	l_data=(1<<UART_RXIF_MASK);
	outw(l_reg,l_data);
}

/****************************************************************************
*name    : DrvUART2_Read(void)
*function: read the RX data
*input   : no
*output  : RX data value of 5~9 Bits
*version : v1.0
*date    : 2014-5-30
*modify  : NO
****************************************************************************/
unsigned int DrvUART2_Read(void)
{
	unsigned int l_reg;
	l_reg=R_UART2_RCREG;
	return (inw(l_reg)&0x000001ff);
}
/****************************************************************************
*name    : DrvUART2_Write(unsigned int uData)
*function: write data to TX buffer
*input   : uData :5~9 Bits
*output  : NO
*version : v1.0
*date    : 2014-5-30
*modify  : NO
****************************************************************************/
void DrvUART2_Write(unsigned int uData)
{
	unsigned int l_reg,l_data;
	l_reg=R_UART2_TXREG;
	l_data=(uData<<16)+(inw(l_reg)&0xffff);
	outw(l_reg,l_data);
}

void DrvUART2_EnableWakeUp(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_UART2_CTRL2;
	l_data=(1<<RXWUEN)|(1<<(RXWUEN_MASK));
	outw(l_reg,l_data);
}

void DrvUART2_DisableWakeUp(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_UART2_CTRL2;
	l_data=(1<<RXWUEN_MASK);
	outw(l_reg,l_data);
}

void DrvUART2_Enable_AutoBaudrate(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_UART2_CTRL2;
	l_data=(1<<ABDEN)|(1<<(ABDEN_MASK));
	outw(l_reg,l_data);
}

void DrvUART2_Disable_AutoBaudrate(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_UART2_CTRL2;
	l_data=(1<<ABDEN_MASK);
	outw(l_reg,l_data);
}

/*
modify: change '&0xff000000' to '&0x100000'  20150922
*/
unsigned int DrvUART2_GetPERR(void)
{
	unsigned int l_reg,ReturnVal;
	ReturnVal=0;
	l_reg=R_UART2_CTRL1;
	ReturnVal=((inw(l_reg)&0X100000)>>PERR);
	return ReturnVal;
}
/*
modify: change '&0xff000000' to '&0x200000'  20150922
*/
unsigned int DrvUART2_GetFERR(void)
{
	unsigned int l_reg,ReturnVal;
	ReturnVal=0;
	l_reg=R_UART2_CTRL1;
	ReturnVal=((inw(l_reg)&0X200000)>>FERR);
	return ReturnVal;
}
/*
modify: change '&0xff000000' to '&0x800000'  20150922
*/
unsigned int DrvUART2_GetOERR(void)
{
	unsigned int l_reg,ReturnVal;
	ReturnVal=0;
	l_reg=R_UART2_CTRL1;
	ReturnVal=((inw(l_reg)&0X800000)>>OERR);
	return ReturnVal;
}
/*
modify: change '&0xff000000' to '&0x400000'  20150922
*/
unsigned int DrvUART2_GetNERR(void)
{
	unsigned int l_reg,ReturnVal;
	ReturnVal=0;
	l_reg=R_UART2_CTRL1;
	ReturnVal=((inw(l_reg)&0X400000)>>NERR);
	return ReturnVal;
}


void DrvUART2_ClrFERR(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_UART2_CTRL1;
	l_data=(1<<FERR_MASK);
	outw(l_reg,l_data);
}

void DrvUART2_ClrPERR(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_UART2_CTRL1;
	l_data=(1<<PERR_MASK);
	outw(l_reg,l_data);
}

void DrvUART2_ClrOERR(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_UART2_CTRL1;
	l_data=(1<<OERR_MASK);
	outw(l_reg,l_data);
}

void DrvUART2_ClrNERR(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_UART2_CTRL1;
	l_data=(1<<NERR_MASK);
	outw(l_reg,l_data);
}

unsigned int DrvUART2_GetABDOVF(void)
{
	unsigned int l_reg,ReturnVal;
	ReturnVal=0;
	l_reg=R_UART2_CTRL2;
	ReturnVal=((inw(l_reg)&0X10)>>ABDF);
	return ReturnVal;
}
void DrvUART2_ClrABDOVF(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_UART2_CTRL1;
	l_data=(1<<ABDF_MASK);
	outw(l_reg,l_data);
}

/****************************************************************************
*name    : DrvUART2_TRStatus(unsigned int uMode)
*function: get the TX OR RX work status,include the RX/TX buffer;
*input   : umode :choose the TX OR RX work chanel
*          0 RXBF; 1 RXBUSY; 2 TXBF; 3 TXBUSY
*output  : the status value of UART(0X40E00);
*          TXBUSY: 0 idle; 1 Busy
*          TXBF  : 0 empty; 1  full
*          RXBUSY: 0 idle; 1 Busy
*          RXBF  : 0 empty; 1  full
*version : v1.0
*date    : 2014-6-3
*modify  : no
****************************************************************************/
unsigned int DrvUART2_TRStatus(unsigned int uMode)
{
	unsigned int l_reg,l_data;
	if (uMode>3) return 0XFF;
	l_reg=R_UART2_CTRL1;
	l_data=(inw(l_reg)>>(uMode+16))&0x01;
	return l_data;
}

/****************************************************************************
*name:     DrvUART2_CheckTRMT(void)
*function: read transmit shift status bit TXBF;
*input:    no
*output:   the TXBF bit value of UART(0X40E00);
*version:  v1.0
*date:     2014-6-3
*modify:   no
****************************************************************************/
unsigned int DrvUART2_CheckTRMT(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_UART2_CTRL1;
	l_data=(inw(l_reg)&0x040000)>>TXBF;
	return l_data;
}

/****************************************************************************
*name    : DrvUART2_ClkEnable();
*function: setting the UART2 clock source and setting divier;
*input   : uclk: clock source
*              0: external high speed osc
*              1: internal high speed osc
*          uprescale: clock divier;
*output  :
*version : v1.0
*date    : 2014-5-30
*modify  : no
****************************************************************************/
unsigned int DrvUART2_ClkEnable(unsigned int uclk,unsigned int uprescale)
{
	unsigned int Return_value;
	unsigned int Reg_addr,l_data;
	Return_value=0;
	Reg_addr=R_UART2_CLOCK;
	if(uprescale<16)
	{
		l_data=inw(Reg_addr)&0xfff0ffff;
		l_data=l_data+((uprescale<<16)&0x000f0000);
		l_data=0xff00ff00+l_data;

	}
	else
	{
		Return_value=1;
		return Return_value;
	}
	if(uclk==0)
	{
		CLRBIT(l_data,USel);
	}
	else
	{
		SETBIT(l_data,USel);
	}
	SETBIT(l_data,UCLK_En);
	outw(Reg_addr,l_data);
	return Return_value;
}
/****************************************************************************
*name     : DrvUART2_ClkDisable();
*function : disable UART2 clock;
*input    : void
*output   : void
*version  : v1.0
*date     : 2013-11-28
*modify   : no
****************************************************************************/
void DrvUART2_ClkDisable(void)
{
	unsigned int l_reg;
	l_reg=R_UART2_CLOCK;
	outw(l_reg,0x10000000);
}

/*******************************************************************
*name    : DrvUART2_ConfigIO
*function: ?离IO諳葩??UART籵?諳???寁IO?
*input   : ioen: 0 壽?IO諳葩?髡夔?1 羲?IO諳葩?髡?
*          uoutputPin: ??籵?IO?
*output  : 0?SUCCESS ?坻?扢离囮??
*Version : v1.0
*date    : 2014-5-30
*modify  : none
*********************************************************************/
unsigned char DrvUART2_ConfigIO(unsigned char ioen,unsigned int uOuputPin)
{
	unsigned int l_reg,l_data;
	if((uOuputPin>UAPS_MAX)|(ioen>1)){return E_UART_ERR_OUTPIN;}
	else
	{
	    l_data=(uOuputPin<<UAPS)|(UAPS_MAX<<UAPS_MASK)|(ioen<<UAPTOE)|(1<<UAPTOE_MASK);
	    l_reg=R_UART2_GPIO;
	    outw(l_reg,l_data);
	    return E_SUCCESS;
	}
}



