/*
 * DrvTimer.h
 *
 *  Created on: 2016/08/15
 *  Author: Robert.Wang
 *  Version : V0.0, 2016/08/15
 *  
 */

#ifndef DRVTIMER_H_
#define DRVTIMER_H_

#include "HY16F3981.h"
#include "SpecialMacro.h"

#ifndef E_SUCCESS
#define E_SUCCESS		0
#endif

#ifndef E_FAIL
#define E_FAIL		1
#endif
#define E_DRVTIMER_ARGUMENT E_FAIL
#define E_DRVWDT_FAIL E_FAIL
#define E_DRVTIMER_CHANNEL E_FAIL

#ifdef Timer_BASE
#define TMA_BASE  Timer_BASE
#define TMB_BASE  (Timer_BASE+OFFSET04)
#define PWM_BASE  (Timer_BASE+OFFSET04)
#define PWM_CONDITION  (Timer_BASE+OFFSET10)
#define TMC_BASE  (Timer_BASE+OFFSET14)
#define CAPTURE_BASE  (Timer_BASE+OFFSET14)
#endif

#ifdef INTERRUPT_BASE
#define TMA_INTERRUPT_CTRL  (INTERRUPT_BASE+OFFSET04)
#define TMB_INTERRUPT_CTRL  (INTERRUPT_BASE+OFFSET04)
#define TMB2_INTERRUPT_CTRL (INTERRUPT_BASE+OFFSET1C)   
#define TMC0_INTERRUPT_CTRL  (INTERRUPT_BASE+OFFSET04)
#define TMC1_INTERRUPT_CTRL  (INTERRUPT_BASE+OFFSET04)
#define WDT_INTERRUPT_CTRL  (INTERRUPT_BASE+OFFSET04)
#endif

#ifdef CLOCK_BASE
#define TMA_CLOCK_CTRL      (CLOCK_BASE+OFFSET08)
#define TMB_CLOCK_CTRL      (CLOCK_BASE+OFFSET08)
#define TMB2_CLOCK_CTRL     (CLOCK_BASE+OFFSET14)
#endif

#ifdef GPIO_BASE
#define PWM_PIN_CTRL      (GPIO_BASE+OFFSET40)
#define CAPTURE_PIN_CTRL      (GPIO_BASE+OFFSET40)
#endif

#define CPI1R     23
#define CPI1S     20
#define CPI1R_MASK  (CPI1R+MASK)
#define CPI1S_MASK  (CPI1S+MASK)

#define CPI3R    23
#define CPI3S    20
#define CPI3R_MASK  (CPI3R+MASK)
#define CPI3S_MASK  (CPI3S+MASK)


//2021/09/10 robert add
#define PTPW0E        0
#define PTPW1E        1
#define PTPW0E_MASK  (PTPW0E+0x8)
#define PTPW1E_MASK  (PTPW1E+0x8)
#define PTPW2E        0
#define PTPW3E        1
#define PTPW2E_MASK  (PTPW2E+0x8)
#define PTPW3E_MASK  (PTPW3E+0x8)
#define PTPW          2
#define PTPW_MASK    (PTPW+0x8)

typedef enum{
	E_IRQ     = 0,
	E_NMI     = 1
} E_WDT_MODE ;

typedef enum{
	E_PRE_SCALER_D2     = 0,
	E_PRE_SCALER_D8,
	E_PRE_SCALER_D32,
	E_PRE_SCALER_D128,
	E_PRE_SCALER_D512,
	E_PRE_SCALER_D2048,
	E_PRE_SCALER_D8192,
	E_PRE_SCALER_D32768
} E_WDT_PRE_SCALER ;

typedef enum{
	E_TMA     = 0,
	E_TMB     = 1,
	E_TMC0    = 2,
	E_TMC1    = 3,
	E_WDT     = 4,
	E_TMB2    = 5
} E_TIMER_CHANNEL ;

typedef enum{
	E_TMB_MODE0   = 0,
	E_TMB_MODE1   = 1,
	E_TMB_MODE2   = 2,
	E_TMB_MODE3   = 3
} E_TMB_MODE ;

typedef enum{
	E_TMB_NORMAL    = 0,
	E_TMB_CMP_HIGH  = 1,
	E_TMB_OP_HIGH   = 2,
	E_TMB_GPIO_HIGH = 3
} E_TRIGGER_SOURCE ;
typedef enum{
	E_PWMA    = 0,
	E_PWMB  = 1,
	E_PWMC   = 2,
	E_PWMD = 3,
	E_PWME  =4 ,
	E_PWMF  = 5,
	E_PWMG  = 6
} E_PWM_MODE ;
typedef enum{      //CAPTURE1 INPUT SOURCE
	E_TMC_CMPO = 0,
	E_TMC_OPOD = 1,
	E_TMC_LSCK = 2,
	E_TMC_TCI0 = 3
}E_TC1_SOURCE;
typedef enum{
	E_TMC_TCI1 = 0,
	E_TMC_ASTC0 = 1
}E_TC2_SOURCE;
/*
#ifndef E_DRVGPIO_CLK_SOURCE
typedef enum   
{
    E_HS_CK= 0,
    E_LS_CK
} E_DRVTIMER_CLOCK_SOURCE;
#endif
*/

unsigned int DrvWDT_Open(unsigned int eMode , unsigned int eWDTpreScaler);
unsigned int DrvWDT_CounterRead(void);
void DrvWDT_ClearWDT(void);
void DrvWDT_ResetEnable(void);

unsigned int DrvTMA_Open(unsigned int eTMAOV,unsigned int uclk);
void DrvTMA_Close(void);
unsigned int DrvTMA_CounterRead(void);
void DrvTMA_ClearTMA(void);

unsigned int DrvTIMER_EnableInt(unsigned int ch);
unsigned int DrvTIMER_DisableInt(unsigned int ch);
unsigned int DrvTIMER_GetIntFlag(unsigned int ch);
unsigned int DrvTIMER_ClearIntFlag(unsigned int ch);

unsigned int DrvTMB_Open(unsigned int uTMBmode ,unsigned int uTriSource ,unsigned int uTMBOV);
unsigned int DrvTMBC_Clk_Source(unsigned int uclk,unsigned int uPerScale);
void DrvTMBC_Clk_Disable(void) ;
void DrvTMB_ClearTMB(void);
unsigned int DrvTMB_CounterRead(void);
void DrvTMB_Close(void);

unsigned int DrvPWM0_Open(unsigned int uPWM_Mode,unsigned int uInv,unsigned int uOuputPin);
unsigned int DrvPWM1_Open(unsigned int uPWM_Mode,unsigned int uInv,unsigned int uOuputPin);
void DrvPWM_CountCondition(unsigned int uTBC2 ,unsigned int uTBC1);
void DrvPWM0_Close(void);
void DrvPWM1_Close(void);

unsigned int DrvCapture1_Open(unsigned int uChannel ,unsigned int uDivider,unsigned int uEdge);
unsigned int DrvCapture2_Open(unsigned int uChannel ,unsigned int uEdge);
unsigned int DrvCapture1_Read(void);
unsigned int DrvCapture2_Read(void);
unsigned int DrvCapture_Iport(unsigned int uInputPin);
unsigned char DrvTMB_TCI1Edge(unsigned int uedge);
unsigned char DrvTMB_CPI1Input(unsigned int usource);


unsigned int DrvTMB2_Open(unsigned int uTMBmode ,unsigned int uTriSource ,unsigned int uTMBOV);
void DrvTMB2_Close(void);
unsigned int DrvTMB2_Clk_Source(unsigned int uclk,unsigned int uPerScale);
void DrvTMB2_Clk_Disable(void);
void DrvTMB2_ClearTMB(void);
unsigned int DrvTMB2_CounterRead(void);

unsigned int DrvPWM2_Open(unsigned int uPWM_Mode,unsigned int uInv,unsigned int uOuputPin);
unsigned int DrvPWM3_Open(unsigned int uPWM_Mode,unsigned int uInv,unsigned int uOuputPin);
void DrvTMB2PWM_CountCondition(unsigned int uTBC2 ,unsigned int uTBC1);
void DrvPWM2_Close(void);
void DrvPWM3_Close(void);

unsigned char DrvTMB2_CPI3Input(unsigned int usource);
unsigned char DrvTMB2_TCI3Edge(unsigned int uedge);

#endif /* DRVTIMER_H_ */
