/*
 *  Created on: 2016/7/28
 *  Author: Robert.Wang
 *  Memo : HY16F3981 DrvTimer.c is base on HY16F198B to modify
*/

#include "DrvTimer.h"

unsigned int DrvWDT_Open(unsigned int eMode , unsigned int eWDTpreScaler)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=WATCHDOG_BASE;
    if (eMode>1) ReturnVal=E_DRVWDT_FAIL;
    else if (eMode==1) l_data=0x0000ff50;
    else l_data=0x0000ff10;
    if (eWDTpreScaler>7) ReturnVal=E_DRVWDT_FAIL;
    else l_data=l_data+eWDTpreScaler;
    outw(l_reg, l_data);

    l_reg=CLOCK_BASE+OFFSET08;
    l_data=0x40400000;
    outw(l_reg, l_data);

	return ReturnVal;
}

unsigned int DrvWDT_CounterRead(void)
{
	//Robert modify 2016/7/6
	//return ((inw(WATCHDOG_BASE)&0x00ff0000)>>15);
	return ((inw(WATCHDOG_BASE)&0xfffff000)>>15); //Get 0x40108[30:15]

}

void DrvWDT_ClearWDT(void)
{
	outw(WATCHDOG_BASE, 0x00002020);
}

void DrvWDT_ResetEnable(void)
{
  unsigned int l_reg,l_data;
  l_reg=WATCHDOG_BASE;
  l_data=0x00004040;
  outw(l_reg, l_data);	//0x40108[6]=1b

}

unsigned int DrvTMA_Open(unsigned int eTMAOV,unsigned int uclk)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	if (eTMAOV<16){
	  l_reg=TMA_BASE;
	  l_data=0x00002f20+eTMAOV;
	  outw(l_reg, l_data);
	}else{
		ReturnVal=E_DRVTIMER_ARGUMENT;
	}

	/*if (uclk<2){
	  l_reg=CLOCK_BASE+OFFSET08;
	  l_data=0x00000c04+uclk*8;
	  outw(l_reg, l_data);
	}else{
		ReturnVal=E_DRVTIMER_ARGUMENT;
	}*/

	//Robert  modify 2016/7/6
	// if uclk=0=closed, uclk=1=HS_CK, uclk=2=HS_CB,  uclk=3=LS_CK
	if (uclk<4){
	  l_reg=CLOCK_BASE+OFFSET08;
	  l_data=0x00000c00+uclk*4;
	  outw(l_reg, l_data);
	}else{
		ReturnVal=E_DRVTIMER_ARGUMENT;
	}

	return ReturnVal;
}

void DrvTMA_Close(void)
{
	unsigned int l_reg,l_data;
	l_reg=TMA_BASE;
	l_data=0x00002000;
	outw(l_reg, l_data);
}

/**********************************************************************
 * Name     : DrvWDT_CounterRead (void)
 * function : get the timer A counter value
 * input    : NO
 * output   : Timer A counter value
 * version  : v1.1
 * date     : 13-12-4
 * modify   : change the output value with 16bit
 *********************************************************************/
unsigned int DrvTMA_CounterRead(void)
{
	return ((inw(TMA_BASE)&0xffff0000)>>16);
}


void DrvTMA_ClearTMA(void)
{
	unsigned int l_reg,l_data;
	l_reg=TMA_BASE;
	l_data=0x00001010;
	outw(l_reg, l_data);
}

/**********************************************************************
 * Name     : DrvTIMER_EnableInt (unsigned int ch)
 * function : ENABLE THE TIMER INTERRUPT,for WDT TMA TMB1/TMB2 TMC
 * input    : ch: 0  TMA; 1 TMB1; 2 TMC0; 3 TMC1; 4 WDT; 5 TMB2;
 * output   :
 * version  : v1.0
 * date     : 14-5-26
 * modify   : NO
 *********************************************************************/
unsigned int DrvTIMER_EnableInt(unsigned int ch)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	if (ch==0) {
	  l_reg=TMA_INTERRUPT_CTRL;
	  l_data=0x01010000;
	}
	else if (ch==1) {
	  l_reg=TMB_INTERRUPT_CTRL;
	  l_data=0x02020000;
	}
	else if (ch==2) {
	  l_reg=TMC0_INTERRUPT_CTRL;
	  l_data=0x04040000;
	}
	else if (ch==3) {
	  l_reg=TMC1_INTERRUPT_CTRL;
	  l_data=0x08080000;
	}
	else if (ch==4) {
	  l_reg=WDT_INTERRUPT_CTRL;
	  l_data=0x10100000;
	}
	else if (ch==5){
	  l_reg=TMB2_INTERRUPT_CTRL;
	  l_data=0x02020000;
	}
	else {return E_DRVTIMER_ARGUMENT;}
	outw(l_reg, l_data);
	return ReturnVal;
}
/**********************************************************************
 * Name     : DrvTIMER_DisableInt (unsigned int ch)
 * function : DISABLE THE TIMER INTERRUPT,for WDT TMA TMB1/TMB2 TMC
 * input    : ch: 0  TMA; 1 TMB1; 2 TMC0; 3 TMC1; 4 WDT; 5 TMB2;
 * output   :
 * version  : v1.0
 * date     : 14-5-26
 * modify   : NO
 *********************************************************************/
unsigned int DrvTIMER_DisableInt(unsigned int ch)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	if (ch==0) {
	  l_reg=TMA_INTERRUPT_CTRL;
	  l_data=0x01000000;
	}
	else if (ch==1) {
	  l_reg=TMB_INTERRUPT_CTRL;
	  l_data=0x02000000;
	}
	else if (ch==2) {
	  l_reg=TMC0_INTERRUPT_CTRL;
	  l_data=0x04000000;
	}
	else if (ch==3) {
	  l_reg=TMC1_INTERRUPT_CTRL;
	  l_data=0x08000000;
	}
	else if (ch==4) {
	  l_reg=WDT_INTERRUPT_CTRL;
	  l_data=0x10000000;
	}
	else if (ch==5) {
	  l_reg=TMB2_INTERRUPT_CTRL;
	  l_data=0x02000000;
	}
	else {ReturnVal=E_DRVTIMER_ARGUMENT;}
	outw(l_reg, l_data);
	return ReturnVal;
}
/**********************************************************************
 * Name     : DrvTIMER_GetIntFlag (unsigned int ch)
 * function : GET THE TIMER INTERRUPT FLAG,for WDT TMA TMB1/TMB2 TMC
 * input    : ch: 0  TMA; 1 TMB1; 2 TMC0; 3 TMC1; 4 WDT; 5 TMB2;
 * output   :
 * version  : v1.0
 * date     : 14-5-26
 * modify   : NO
 *********************************************************************/
unsigned int DrvTIMER_GetIntFlag(unsigned int ch)
{
	//Robert add 2016/8/5
	unsigned int l_reg,ReturnVal;
	//unsigned int l_reg,l_data;
	if (ch==0) {
	  l_reg=TMA_INTERRUPT_CTRL;
	  //Robert add 2016/8/5
	  ReturnVal=((inw(l_reg)&0x01)>>(0));  //Read 0x40004[0]
	  return ReturnVal;
	  //l_data=inw(l_reg)&0x00000001;
	  //outw(l_reg, l_data);
	  //if (l_data>0) return 1; else return 0;
	}
	else if (ch==1) {
	  l_reg=TMB_INTERRUPT_CTRL;
	  //Robert add 2016/8/5
	  ReturnVal=((inw(l_reg)&0x02)>>(1));  //Read 0x40004[1]
	  return ReturnVal;
	  //l_data=inw(l_reg)&0x00000002;
	  //outw(l_reg, l_data);
	  //if (l_data>0) return 1; else return 0;
	}
	else if (ch==2) {
	  l_reg=TMC0_INTERRUPT_CTRL;
	  //Robert add 2016/8/5
	  ReturnVal=((inw(l_reg)&0x04)>>(2));  //Read 0x40004[2]
	  return ReturnVal;
	  //l_data=inw(l_reg)&0x00000004;
	  //outw(l_reg, l_data);
	  //if (l_data>0) return 1; else return 0;
	}
	else if (ch==3) {
	  l_reg=TMC1_INTERRUPT_CTRL;
	  //Robert add 2016/8/5
	  ReturnVal=((inw(l_reg)&0x08)>>(3));  //Read 0x40004[3]
	  return ReturnVal;
	  //l_data=inw(l_reg)&0x00000008;
	  //if (l_data>0) return 1; else return 0;
	}
	else if (ch==4) {
	  l_reg=WDT_INTERRUPT_CTRL;
	  //Robert add 2016/8/5
	  ReturnVal=((inw(l_reg)&0x10)>>(4));  //Read 0x40004[4]
	  return ReturnVal;
	  //l_data=inw(l_reg)&0x00000010;
	  //outw(l_reg, l_data);
	  //if (l_data>0) return 1; else return 0;
	}
	else if (ch==5) {
	  l_reg=TMB2_INTERRUPT_CTRL;
	  //Robert add 2016/8/5
	  ReturnVal=((inw(l_reg)&0x02)>>(1));  //Read 0x4001C[1]
	  return ReturnVal;
	  //l_data=inw(l_reg)&0x00000002;
	  //outw(l_reg,l_data);
	  //if (l_data>0) return 1; else return 0;
	}
	//Robert add 2016/8/5
	//else {return E_DRVTIMER_ARGUMENT;}
	else {return 0;}
}


/**********************************************************************
 * Name     : DrvTIMER_ClearIntFlag (unsigned int ch)
 * function : GET THE TIMER INTERRUPT FLAG,for WDT TMA TMB1/TMB2 TMC
 * input    : ch: 0  TMA; 1 TMB1; 2 TMC0; 3 TMC1; 4 WDT; 5 TMB2;
 * output   :
 * version  : v1.0
 * date     : 14-5-26
 * modify   : NO
 *********************************************************************/
unsigned int DrvTIMER_ClearIntFlag(unsigned int ch)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	if (ch==0) {
	  l_reg=TMA_INTERRUPT_CTRL;
	  l_data=0x00000100;
	}
	else if (ch==1) {
	  l_reg=TMB_INTERRUPT_CTRL;
	  l_data=0x00000200;
	}
	else if (ch==2) {
	  l_reg=TMC0_INTERRUPT_CTRL;
	  l_data=0x00000400;
	}
	else if (ch==3) {
	  l_reg=TMC1_INTERRUPT_CTRL;
	  l_data=0x00000800;
	}
	else if (ch==4) {
	  l_reg=WDT_INTERRUPT_CTRL;
	  l_data=0x00001000;
	}
	else if (ch==5) {
	  l_reg=TMB2_INTERRUPT_CTRL;
	  l_data=0x00000200;
	}
	else {ReturnVal=E_DRVTIMER_CHANNEL;}
	outw(l_reg, l_data);
	return ReturnVal;
}


/**********************************************************************
 * Name     : DrvTMB_Open
 * function : open TMB1
 * input    :
 * output   :
 * version  : v1.0
 * date     : 14-5-30
 * modify   : NO
 *********************************************************************/
unsigned int DrvTMB_Open(unsigned int uTMBmode ,unsigned int uTriSource ,unsigned int uTMBOV)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	if (uTMBOV<0x10000){
	  l_reg=TMB_BASE+OFFSET08;
	  outw(l_reg, uTMBOV);
	}else{
		ReturnVal=E_DRVTIMER_ARGUMENT;
	}

	if ((uTMBmode<4)&&(uTriSource<4)){
	  l_reg=TMB_BASE;
	  l_data=uTMBmode<<2;
	  l_data=(l_data|0x00002f20)+uTriSource;
	  outw(l_reg, l_data);
	}else{
		ReturnVal=E_DRVTIMER_ARGUMENT;
	}
	return ReturnVal;
}

unsigned int DrvTMBC_Clk_Source(unsigned int uclk,unsigned int uPerScale)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;

	l_reg=TMB_CLOCK_CTRL;
	if (uPerScale<4){
		l_data=uPerScale<<4;
	}else{
		ReturnVal=E_DRVTIMER_ARGUMENT;
	}

	/*
	if (uclk==0)
		l_data|=0x0000f040;
	else if (uclk==1)
		l_data|=0x0000f0c0;
	else
		ReturnVal=E_DRVTIMER_ARGUMENT;
	outw(l_reg, l_data);

	return ReturnVal;
	*/

	//Robert  modify 2016/7/7
	// if uclk=0=closed, uclk=1=HS_CK, uclk=2=HS_CB,  uclk=3=LS_CK
	if (uclk==0)
		l_data|=0x0000f000;
	else if (uclk==1)
		l_data|=0x0000f040;
	else if (uclk==2)
		l_data|=0x0000f080;
	else if (uclk==3)
		l_data|=0x0000f0c0;
	else
		ReturnVal=E_DRVTIMER_ARGUMENT;
	outw(l_reg, l_data);

	return ReturnVal;
}


void DrvTMBC_Clk_Disable(void)
{
	unsigned int l_reg,l_data;

	l_reg=TMB_CLOCK_CTRL;
	//Robert add 2016-7-7
	//l_data=0x00004000;
	l_data=0x0000C000;
	outw(l_reg, l_data);
}


void DrvTMB_ClearTMB(void)
{
	unsigned int l_reg,l_data;
	l_reg=TMB_BASE;
	l_data=0x00001010;
	outw(l_reg, l_data);
}


unsigned int DrvTMB_CounterRead(void)
{
	return (inw(TMB_BASE+OFFSET04)&0x0000FFFF);
}


void DrvTMB_Close (void)
{
	unsigned int l_reg,l_data;
	l_reg=TMB_BASE;
	l_data=0x00002000;
	outw(l_reg, l_data);
}


unsigned int DrvPWM0_Open(unsigned int uPWM_Mode,unsigned int uInv,unsigned int uOuputPin)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=PWM_PIN_CTRL;
	if(uOuputPin<8)
	  l_data=(uOuputPin<<2);
	else
	  ReturnVal=E_DRVTIMER_ARGUMENT;
	SETBIT(l_data,0);
	//l_data+=(l_data<<8);
	l_data=l_data+(7<<PTPW_MASK)+(1<<PTPW0E_MASK);  //2021/09/10 robert add 
	if(ReturnVal!=E_DRVTIMER_ARGUMENT)
	  outw(l_reg, l_data);

	l_reg=PWM_BASE;
	if (uPWM_Mode<8){
		l_data=(uPWM_Mode<<16);
		if (uInv==0){CLRBIT(l_data,19);}
		else if (uInv==1){SETBIT(l_data,19);}
		else ReturnVal=E_DRVTIMER_ARGUMENT;
		l_data|=0x0f000000;
	}else
		ReturnVal=E_DRVTIMER_ARGUMENT;
	if(ReturnVal!=E_DRVTIMER_ARGUMENT)
		outw(l_reg, l_data);
	return ReturnVal;
}

unsigned int DrvPWM1_Open(unsigned int uPWM_Mode,unsigned int uInv,unsigned int uOuputPin)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=PWM_PIN_CTRL;
	if(uOuputPin<8)
	  l_data=(uOuputPin<<2);
	else
	  ReturnVal=E_DRVTIMER_ARGUMENT;
	SETBIT(l_data,1);
	//l_data+=(l_data<<8);
	l_data=l_data+(7<<PTPW_MASK)+(1<<PTPW1E_MASK);  //2021/09/10 robert add 
	if(ReturnVal!=E_DRVTIMER_ARGUMENT)
	  outw(l_reg, l_data);

	l_reg=PWM_BASE;
	if (uPWM_Mode<8){
		l_data=(uPWM_Mode<<20);
		if (uInv==0){CLRBIT(l_data,23);}
		else if (uInv==1){SETBIT(l_data,23);}
		else ReturnVal=E_DRVTIMER_ARGUMENT;
		l_data|=0xf0000000;
	}else
		ReturnVal=E_DRVTIMER_ARGUMENT;
	if(ReturnVal!=E_DRVTIMER_ARGUMENT)
		outw(l_reg, l_data);
	return ReturnVal;
}

/*******************************************************************
*name    : DrvPWM_Countcondition()
*function: setting the PWM0 AND PWM1 duty
*input   : uTBC1/uTBC2
*output  : no
*Version : v1.1
*date    : 2013-11-29
*modify  : EXCHANGE input parameter between uTBC1 and uTBC2
*********************************************************************/
void DrvPWM_CountCondition(unsigned int uTBC2 ,unsigned int uTBC1)
{
	unsigned int l_reg,l_data;
	l_reg=PWM_CONDITION;
	l_data=(uTBC2<<16)+uTBC1;
	outw(l_reg, l_data);
}


void DrvPWM0_Close(void)
{
	unsigned int l_reg,l_data;
	l_reg=PWM_PIN_CTRL;
	l_data=0x00000100;
	outw(l_reg, l_data);
}

void DrvPWM1_Close(void)
{
	unsigned int l_reg,l_data;
	l_reg=PWM_PIN_CTRL;
	l_data=0x00000200;
	outw(l_reg, l_data);
}



unsigned int DrvCapture1_Open(unsigned int uChannel ,unsigned int uDivider,unsigned int uEdge)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=CAPTURE_BASE;
	if(uDivider<16)
		l_data=(uDivider<<16);
	else
		ReturnVal=E_DRVTIMER_ARGUMENT;

	if(uChannel<4)
		l_data|=(uChannel<<20);
	else
		ReturnVal=E_DRVTIMER_ARGUMENT;

	if(uEdge==0){CLRBIT(l_data,1);}
	else if(uEdge==1){SETBIT(l_data,1);}
	else {ReturnVal=E_DRVTIMER_ARGUMENT;}

	if(ReturnVal!=E_DRVTIMER_ARGUMENT)
	{
		SETBIT(l_data,0);
		l_data|=0x3f000300;
		outw(l_reg, l_data);
	}
	return ReturnVal;
}

unsigned int DrvCapture2_Open(unsigned int uChannel ,unsigned int uEdge)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=CAPTURE_BASE;
	l_data=0;
	if(uChannel==1)
	    {SETBIT(l_data,22);}
	else if(uChannel==0)
		{CLRBIT(l_data,22);}
	else
		ReturnVal=E_DRVTIMER_ARGUMENT;

	if(uEdge==0){CLRBIT(l_data,2);}
	else if(uEdge==1){SETBIT(l_data,2);}
	else {ReturnVal=E_DRVTIMER_ARGUMENT;}

	if(ReturnVal!=E_DRVTIMER_ARGUMENT)
	{
		SETBIT(l_data,0);
		l_data|=0x40000500;
		outw(l_reg, l_data);
	}
	return ReturnVal;
}


unsigned int DrvCapture1_Read(void)
{
	return (inw(CAPTURE_BASE+OFFSET04)&0x0000FFFF);
}


unsigned int DrvCapture2_Read(void)
{
	return ((inw(CAPTURE_BASE+OFFSET04)&0xffff0000)>>16);
}


unsigned int DrvCapture_Iport(unsigned int uInputPin)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=CAPTURE_PIN_CTRL;
	if(uInputPin<8)
		l_data=(uInputPin<<5)+(uInputPin<<13);
	else
		ReturnVal=E_DRVTIMER_ARGUMENT;

	if(ReturnVal!=E_DRVTIMER_ARGUMENT)
	{
	    outw(l_reg, l_data);
	}
	return E_SUCCESS;
}


unsigned char DrvTMB_TCI1Edge(unsigned int uedge)
{
	unsigned int l_reg,l_data;
	if(uedge>1)
		return E_FAIL;
	l_data=(uedge<<CPI1R)|(1<<CPI1R_MASK);
	l_reg=TMC_BASE;
	outw(l_reg,l_data);
	return E_SUCCESS;
}


unsigned char DrvTMB_CPI1Input(unsigned int usource)
{
	unsigned int l_reg,l_data;
	if(usource>3)
		return E_FAIL;
	l_data=(usource<<CPI1S)|(0x3<<CPI1S_MASK);
	l_reg=TMC_BASE;
	outw(l_reg,l_data);
	return E_SUCCESS;
}


/**********************************************************************
 * Name     : DrvTMB2_Open
 * function : OPEN TMB2
 * input    :
 * output   : NO
 * version  : v1.0
 * date     : 14-5-30
 * modify   : NO
 *********************************************************************/
unsigned int DrvTMB2_Open(unsigned int uTMBmode ,unsigned int uTriSource ,unsigned int uTMBOV)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	if (uTMBOV<0x10000){
	  l_reg=TMB_BASE+OFFSET28;
	  outw(l_reg, uTMBOV);
	}else{
		ReturnVal=E_DRVTIMER_ARGUMENT;
	}

	if ((uTMBmode<4)&&(uTriSource<4)){
	  l_reg=TMB_BASE+0x20;
	  l_data=uTMBmode<<2;
	  l_data=(l_data|0x00002f20)+uTriSource;
	  outw(l_reg, l_data);
	}else{
		ReturnVal=E_DRVTIMER_ARGUMENT;
	}
	return ReturnVal;
}

/**********************************************************************
 * Name     : DrvTMB_ClearTMB (void)
 * function : close TMB2
 * input    : NO
 * output   : NO
 * version  : v1.0
 * date     : 14-5-30
 * modify   : NO
 *********************************************************************/
void DrvTMB2_Close(void)
{
	unsigned int l_reg,l_data;
	l_reg=TMB_BASE+OFFSET20;
	l_data=0x00002000;
	outw(l_reg, l_data);
}

/**********************************************************************
 * Name     : DrvTMB2_Clk_Source (unsigned int uclk,unsigned int uPerScale)
 * function : SETTING TMB2 CLOCK SOURCE
 * input    : NO
 * output   : NO
 * version  : v1.0
 * date     : 14-5-30
 * modify   : NO
 *********************************************************************/
unsigned int DrvTMB2_Clk_Source(unsigned int uclk,unsigned int uPerScale)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;

      	l_reg=TMB2_CLOCK_CTRL;
	if (uPerScale<4){
		l_data=uPerScale<<4;
	}else{
		ReturnVal=E_DRVTIMER_ARGUMENT;
	}

	/*
	if (uclk==0)
		l_data|=0x0000f040;
	else if (uclk==1)
		l_data|=0x0000f0c0;
	else
		ReturnVal=E_DRVTIMER_ARGUMENT;
	outw(l_reg, l_data);

	return ReturnVal;
	*/
	//Robert  modify 2016/7/7
	// if uclk=0=closed, uclk=1=HS_CK, uclk=2=HS_CB,  uclk=3=LS_CK
	if (uclk==0)
		l_data|=0x0000f000;
	else if (uclk==1)
		l_data|=0x0000f040;
	else if (uclk==2)
		l_data|=0x0000f080;
	else if (uclk==3)
		l_data|=0x0000f0c0;
	else
		ReturnVal=E_DRVTIMER_ARGUMENT;
	outw(l_reg, l_data);

	return ReturnVal;

}

/**********************************************************************
 * Name     : DrvTMB2_Clk_Disable (void)
 * function : close TMB2 CLOCK SOURCE
 * input    : NO
 * output   : NO
 * version  : v1.0
 * date     : 14-5-30
 * modify   : NO
 *********************************************************************/
void DrvTMB2_Clk_Disable(void)
{
	unsigned int l_reg,l_data;

    l_reg=TMB2_CLOCK_CTRL;
    //Robert add 2016-7-7
    //l_data=0x00004000;
	l_data=0x0000C000;
	outw(l_reg, l_data);

}

/**********************************************************************
 * Name     : DrvTMB2_ClearTMB (void)
 * function : clear TMB2 counter
 * input    : NO
 * output   : NO
 * version  : v1.0
 * date     : 14-5-30
 * modify   : NO
 *********************************************************************/
void DrvTMB2_ClearTMB(void)
{
	unsigned int l_reg,l_data;
	l_reg=TMB_BASE+OFFSET20;
	l_data=0x00001010;
	outw(l_reg, l_data);
}


/**********************************************************************
 * Name     : DrvTMB2_CounterRead(void)
 * function : read TMB2 counter
 * input    : tmb: 0 TMB1; 1 TMB2
 * output   : NO
 * version  : v1.0
 * date     : 14-5-30
 * modify   : NO
 *********************************************************************/
unsigned int DrvTMB2_CounterRead(void)
{
	return (inw(TMB_BASE+OFFSET24)&0x0000FFFF);
}

/**********************************************************************
 * Name     : DrvPWM2_Open()
 * function : open PWM2 OF TMB2
 * input    : NO
 * output   : NO
 * version  : v1.0
 * date     : 14-5-30
 * modify   : NO
 *********************************************************************/
unsigned int DrvPWM2_Open(unsigned int uPWM_Mode,unsigned int uInv,unsigned int uOuputPin)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=PWM_PIN_CTRL+OFFSET08;
	if(uOuputPin<8)
	  l_data=(uOuputPin<<2);
	else
	  ReturnVal=E_DRVTIMER_ARGUMENT;
	SETBIT(l_data,0);
	//l_data+=(l_data<<8);
	l_data=l_data+(7<<PTPW_MASK)+(1<<PTPW2E_MASK);  //Robert add 2021/09/10
	if(ReturnVal!=E_DRVTIMER_ARGUMENT)
	  outw(l_reg, l_data);

	l_reg=PWM_BASE+OFFSET20;
	if (uPWM_Mode<8){
		l_data=(uPWM_Mode<<16);
		if (uInv==0){CLRBIT(l_data,19);}
		else if (uInv==1){SETBIT(l_data,19);}
		else ReturnVal=E_DRVTIMER_ARGUMENT;
		l_data|=0x0f000000;
	}else
		ReturnVal=E_DRVTIMER_ARGUMENT;
	if(ReturnVal!=E_DRVTIMER_ARGUMENT)
		outw(l_reg, l_data);
	return ReturnVal;
}
/**********************************************************************
 * Name     : DrvPWM3_Open()
 * function : open  PWM3 OF TMB2
 * input    : NO
 * output   : NO
 * version  : v1.0
 * date     : 14-5-30
 * modify   : NO
 *********************************************************************/
unsigned int DrvPWM3_Open(unsigned int uPWM_Mode,unsigned int uInv,unsigned int uOuputPin)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=PWM_PIN_CTRL+OFFSET08;
	if(uOuputPin<8)
	  l_data=(uOuputPin<<2);
	else
	  ReturnVal=E_DRVTIMER_ARGUMENT;
	SETBIT(l_data,1);
	//l_data+=(l_data<<8);
	l_data=l_data+(7<<PTPW_MASK)+(1<<PTPW3E_MASK);  //2021/09/10 robert add
	if(ReturnVal!=E_DRVTIMER_ARGUMENT)
	  outw(l_reg, l_data);

	l_reg=PWM_BASE+OFFSET20;
	if (uPWM_Mode<8){
		l_data=(uPWM_Mode<<20);
		if (uInv==0){CLRBIT(l_data,23);}
		else if (uInv==1){SETBIT(l_data,23);}
		else ReturnVal=E_DRVTIMER_ARGUMENT;
		l_data|=0xf0000000;
	}else
		ReturnVal=E_DRVTIMER_ARGUMENT;
	if(ReturnVal!=E_DRVTIMER_ARGUMENT)
		outw(l_reg, l_data);
	return ReturnVal;
}


/*******************************************************************
*name    : DrvTMB2PWM_Countcondition()
*function: setting the PWM0 AND PWM1 duty
*input   : uTBC1/uTBC2
*output  : no
*Version : v1.0
*date    : 2014-5-30
*modify  : NO
*********************************************************************/
void DrvTMB2PWM_CountCondition(unsigned int uTBC2 ,unsigned int uTBC1)
{
	unsigned int l_reg,l_data;
	l_reg=PWM_CONDITION+OFFSET20;
	l_data=(uTBC2<<16)+uTBC1;
	outw(l_reg, l_data);
}


/*******************************************************************
*name    : DrvPWM2_Close()
*function: close PWM2 OF TMB2
*input   : NO
*output  : no
*Version : v1.0
*date    : 2014-5-30
*modify  : NO
*********************************************************************/
void DrvPWM2_Close(void)
{
	unsigned int l_reg,l_data;
	l_reg=PWM_PIN_CTRL+OFFSET08;
	l_data=0x00000100;
	outw(l_reg, l_data);
}
/*******************************************************************
*name    : DrvPWM3_Close()
*function: close PWM3 OF TMB2
*input   : NO
*output  : no
*Version : v1.0
*date    : 2014-5-30
*modify  : NO
*********************************************************************/
void DrvPWM3_Close(void)
{
	unsigned int l_reg,l_data;
	l_reg=PWM_PIN_CTRL+OFFSET08;
	l_data=0x00000200;
	outw(l_reg, l_data);
}


unsigned char DrvTMB2_CPI3Input(unsigned int usource)
{
	unsigned int l_reg,l_data;
	if(usource>3)
		return E_FAIL;
	l_data=(usource<<CPI3S)|(0x3<<CPI3S_MASK);
	l_reg=TMB_BASE+OFFSET30;
	outw(l_reg,l_data);
	return E_SUCCESS;
}



unsigned char DrvTMB2_TCI3Edge(unsigned int uedge)
{
	unsigned int l_reg,l_data;
	if(uedge>1)
		return E_FAIL;
	l_data=(uedge<<CPI3R)|(1<<CPI3R_MASK);
	l_reg=TMB_BASE+OFFSET30;
	outw(l_reg,l_data);
	return E_SUCCESS;
}







