/*
 * DrvSPI32.h
 *
 *  Created on: 2016/08/15
 *  Author: Robert.Wang
 *  Version : V0.0, 2016/08/15
 *  
 */

#ifndef DRVSPI32_H_
#define DRVSPI32_H_
#include "HY16F3981.h"
#ifndef E_FAIL
#define E_FAIL		1
#endif
#define E_DRVSPI_ARGUMENT E_FAIL

#ifndef E_SUCCESS
#define E_SUCCESS		0
#endif

#ifdef  SPI_BASE
#define R_SPI32_CTRL1 (SPI_BASE+OFFSET00);
#define R_SPI32_CTRL2 (SPI_BASE+OFFSET04);
#define R_SPI32_INPUT_BUFFER (SPI_BASE+OFFSET08);
#define R_SPI32_OUTPUT_BUFFER (SPI_BASE+OFFSET0C);
#endif

#ifdef  CLOCK_BASE
#define R_MCU_CLOCK (CLOCK_BASE+OFFSET08);
#define R_SPI_CLOCK (CLOCK_BASE+OFFSET0C);
#endif

#ifdef  INTERRUPT_BASE
#define R_SPI_INTERRUPT_CTRL  (INTERRUPT_BASE+OFFSET00)
#endif

#ifdef  GPIO_BASE
#define R_SPI_PIN_CTRL  (GPIO_BASE+OFFSET44)
#else
#define R_SPI_PIN_CTRL   0x40844
#endif

//# 0x40f00
#define RXF  	      22
#define OVF  	      21
#define ABF  	      20
#define BUF  	      19
#define DCF  	      18
#define SPITXBF  	  17
#define SPIRXBF  	  16
#define CPHA  	      3
#define CPOL   	 	  2
#define SPIMS  	 	  1
#define SPIEN     	  0
#define RXF_MASK      (RXF+MASK)
#define OVF_MASK      (OVF+MASK)
#define ABF_MASK      (ABF+MASK)
#define BUF_MASK      (BUF+MASK)
#define DCF_MASK      (DCF+MASK)
#define SPITXBF_MASK      (SPITXBF+MASK)
#define SPIRXBF_MASK      (SPIRXBF+MASK)
#define CPHA_MASK      (CPHA+MASK)
#define CPOL_MASK      (CPOL+MASK)
#define SPIMS_MASK     (SPIMS+MASK)
#define SPIEN_MASK     (SPIEN+MASK)

//# 0x40f04
#define CSO           20
#define CSL           19
#define LBF           18
#define MD  	      16
#define BL    	 	  0
#define CSO_MASK      (CSO+MASK)
#define CSL_MASK      (CSL+MASK)
#define LBF_MASK      (LBF+MASK)
#define MD_MASK       (MD+MASK)
#define BL_MASK 	  (BL+MASK)
#define MD_MAX       3

//# 0x40f08
#define SPI_I_BUFFER  0

//# 0x40f0C
#define SPI_O_BUFFER  0

//# 0x40844
#define SPPTS  	      5
#define SPPTOE        4
#define SPPTS_MASK    (SPPTS+MASK)
#define SPPTOE_MASK   (SPPTOE+MASK)
#define SPPTS_MAX     3

//# 0x40308
#define ENMCD          1
#define ENMCD_MASK     (ENMCD+MASK)
#define ENMCD_MAX      1

//# 0x4030c
#define ENSD          3
#define SPCD          0
#define ENSD_MASK     (ENSD+MASK)
#define SPCD_MASK     (SPCD+MASK)
#define SPCD_MAX      7

//# 0x40000
#define SPITxIE       	    17
#define SPIRxIE       	    16
#define SPITxIF       	    1
#define SPIRxIF       	    0
#define SPITxIE_MASK   	    (SPITxIE+MASK)
#define SPIRxIE_MASK   	    (SPIRxIE+MASK)
#define SPITxIF_MASK   	    (SPITxIF+MASK)
#define SPIRxIF_MASK   	    (SPIRxIF+MASK)

typedef enum
{
	E_DRVSPI_MASTER1 = 0,
	E_DRVSPI_MASTER2,
	E_DRVSPI_MASTER3,
	E_DRVSPI_SLAVE1,
	E_DRVSPI_SLAVE2,
	E_DRVSPI_SLAVE3,
} E_DRVSPI_MODE;

typedef enum
{
	E_DRVSPI_TYPE0 = 0,
	E_DRVSPI_TYPE1,
	E_DRVSPI_TYPE2,
	E_DRVSPI_TYPE3,
} E_DRVSPI_TRANS_TYPE;
typedef enum
{
	E_DRVSPI_MSB_FIRST = 0,
	E_DRVSPI_LSB_FIRST,
} E_DRVSPI_ENDIAN;
typedef enum
{
	E_DRVSPI_CSLow = 0,
	E_DRVSPI_CSHigh,
} E_DRVSPI_CS;



uint32_t DrvSPI32_Open(uint32_t uMode,uint32_t uType,uint32_t uOuputPin,uint32_t uClkDiv);
void DrvSPI32_Close(void);
unsigned int DrvSPI32_IsBusy( void );
uint32_t DrvSPI32_SetClockFreq(unsigned int uCPUDV,unsigned int uTMRDV);
uint32_t DrvSPI32_IsRxBufferFull(void);
uint32_t DrvSPI32_IsTxBufferFull(void);
void DrvSPI32_EnableRxInt(void);
void DrvSPI32_EnableTxInt(void);
void DrvSPI32_DisableRxInt(void);
void DrvSPI32_DisableTxInt(void);
uint32_t DrvSPI32_GetRxIntFlag(void);
uint32_t DrvSPI32_GetTxIntFlag(void);
void DrvSPI32_ClrIntRxFlag(void);
void DrvSPI32_ClrIntTxFlag(void);
uint32_t DrvSPI32_Read(void);
void DrvSPI32_Write(uint32_t uData);
void DrvSPI32_Enable(void);
void DrvSPI32_BitLength(uint32_t uData);
uint32_t DrvSPI32_GetDCFlag(void);
uint32_t DrvSPI32_IsABFlag(void);
uint32_t DrvSPI32_IsOVFlag(void);
uint32_t DrvSPI32_IsRxFlag(void);
void DrvSPI32_SetEndian(E_DRVSPI_ENDIAN eEndian);
void DrvSPI32_SetCSO(E_DRVSPI_CS eCS);
void DrvSPI32_DisableIO(void);
unsigned char DrvSPI32_EnableIO(uint32_t uOuputPin);
//void Initial_SPI32_Register(void);
//void DrvSPI32_SetCS(E_DRVSPI_CS eCS);


#endif /* DRVSPI32_H_ */
