
/*
 *  Created on: 2016/7/28
 *  Author: Robert.Wang
 *  Memo : HY16F3981 DrvSPI32.c is base on HY16F198B to modify
*/

#include "DrvSPI32.h"
#include "SpecialMacro.h"


uint32_t DrvSPI32_Open(uint32_t uMode,uint32_t uType,uint32_t uOuputPin,uint32_t uClkDiv)
{
	uint32_t l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_data=0;
	l_reg=R_SPI_PIN_CTRL;

	//case uOuputPin : 0~7. 0x40844[4]=1b, 0x40844[7:5]=xxxb.
		//if(uOuputPin<4) //Robert 2016/7/19 verify ok, no should be uOuputPin<8
		if(uOuputPin<8) //Robert 2016/7/19 verify ok, no should be uOuputPin<8
		{
			l_data=(1<<SPPTOE)|(1<<SPPTOE_MASK);
			//Robert add 2016/7/1
			//l_data|=(uOuputPin<<SPPTS)|(SPPTS_MAX<<SPPTS_MASK);
			l_data|=(uOuputPin<<SPPTS)|(0x7<<SPPTS_MASK);
		}else ReturnVal=E_DRVSPI_ARGUMENT;
		if(!ReturnVal) {outw(l_reg,l_data);}

	//case uClkDiv : 0~7. 0x4030C[2:0]=xxxb, 0x4030C[3]=1b.
		l_reg=R_SPI_CLOCK;
		if(uClkDiv<(SPCD_MAX+1)) //Robert 2016/7/19 verify ok
		{
			l_data=(1<<ENSD)|(1<<ENSD_MASK);
			l_data|=(uClkDiv<<SPCD)|(SPCD_MAX<<SPCD_MASK);
		}else ReturnVal=E_DRVSPI_ARGUMENT;
		if(!ReturnVal) {outw(l_reg,l_data);}

	//case uMode & uType :
	//uMode : 0~5. 0x40f00[0]=1b, 0x40f00[1]=xb, 0x40f04[16:17]=0xb.
	//uType : 0~3. 0x40f00[3:2]=xxb

	l_reg=R_SPI32_CTRL1;
	l_data=0;
	if(uMode<3)  //Active Mode control, set 0x40f00[1]=1b
	{
		l_data|=(1<<SPIMS)|(1<<SPIMS_MASK);
	}else if(uMode<6) //Passive Mode control, set 0x40f00[1]=0b
	{
		l_data|=(0<<SPIMS)|(1<<SPIMS_MASK);
	}else ReturnVal=E_DRVSPI_ARGUMENT;

	if(uType<4)
	{
		l_data|=(uType<<CPOL)|(3<<CPOL_MASK);
	}else ReturnVal=E_DRVSPI_ARGUMENT;
	if(!ReturnVal) {outw(l_reg,l_data);}

	//case uMode : 0~5. 0x40f04[16:17]=0xb
	l_reg=R_SPI32_CTRL2;
	l_data=inw(l_reg)&0x01f;
	switch(uMode)
	{
	   case 0:
		   l_data|=(0<<MD)|(3<<MD_MASK);
		   break;
	   case 1:
	   	   l_data|=(1<<MD)|(3<<MD_MASK);
	   	   break;
	   case 2:
	   	   l_data|=(2<<MD)|(3<<MD_MASK);
	   	   break;
	   case 3:
	   	   l_data|=(0<<MD)|(3<<MD_MASK);
	   	   break;
	   case 4:
		   l_data|=0x10100000;
		   outw(l_reg,l_data);
	   	   l_data|=(1<<MD)|(3<<MD_MASK);
	   	   l_data&=0xffefffff;
	   	   break;
	   case 5:
	   	   l_data|=(2<<MD)|(3<<MD_MASK);
	   	   break;
	}
	outw(l_reg,l_data);
	return ReturnVal;
}


void DrvSPI32_Close(void)
{
	uint32_t l_reg,l_data;
	l_reg=R_SPI_PIN_CTRL;
	l_data=(0<<SPPTOE)|(1<<SPPTOE_MASK);
	outw(l_reg,l_data);

	l_reg=R_SPI_CLOCK;
	l_data=(0<<ENSD)|(1<<ENSD_MASK);
	outw(l_reg,l_data);

	l_reg=R_SPI32_CTRL1;
	l_data=(0<<SPIEN)|(1<<SPIEN_MASK);
	outw(l_reg,l_data);
}

uint32_t DrvSPI32_IsBusy(void)
{
	uint32_t l_reg;
	l_reg=R_SPI32_CTRL1;
	//Robert add 2016/8/3
	return ((inw(l_reg)&(1<<BUF))>>BUF);  //0x40F00[19]
}

/*******************************************************************
*name    : DrvSPI32_SetClockFreq
*function: ?离MCU?????SPI??笘煦??
*input   : uCPUDV:MCU??笘煦?˙uTMRDV?SPI??笘煦??
*output  : 0?success  1?fail
*Version : v1.1
*date    : 2014-1-15
*modify  : 氝?妏?SPI????髡??紱??
*********************************************************************/
uint32_t DrvSPI32_SetClockFreq(unsigned int uCPUDV,unsigned int uTMRDV)
{
	uint32_t l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=R_MCU_CLOCK;
	if(uCPUDV<(ENMCD_MAX+1))
	{
		l_data=(uCPUDV<<ENMCD)|(ENMCD_MAX<<ENMCD_MASK);
	}else ReturnVal=E_DRVSPI_ARGUMENT;
	if(!ReturnVal) {outw(l_reg,l_data);}

	l_reg=R_SPI_CLOCK;
	if(uTMRDV<(SPCD_MAX+1))
	{
		l_data=(1<<ENSD)|(1<<ENSD_MASK);
		l_data|=(uTMRDV<<SPCD)|(SPCD_MAX<<SPCD_MASK);
	}else ReturnVal=E_DRVSPI_ARGUMENT;
	if(!ReturnVal) {outw(l_reg,l_data);}

	return ReturnVal;
}


uint32_t DrvSPI32_IsRxBufferFull(void)
{
	uint32_t l_reg;
	l_reg=R_SPI32_CTRL1;
	//Robert add 2016/7/19
	//return ((inw(l_reg)&(1<<SPIRXBF))>>SPIRXBF);
	//Robert Modify 2018/3/14
	//return ((inw(l_reg)&0x0100)>>SPIRXBF);  //0x40F00[16]
	return ((inw(l_reg)&0x010000)>>SPIRXBF);  //0x40F00[16]
}

uint32_t DrvSPI32_IsTxBufferFull(void)
{
	uint32_t l_reg;
	l_reg=R_SPI32_CTRL1;
	//Robert add 2016/7/19
	//return ((inw(l_reg)&(1<<SPITXBF))>>SPITXBF);
	//Robert Modify 2018/3/14
	//return ((inw(l_reg)&0x0200)>>SPITXBF); //0x40F00[17]
	return ((inw(l_reg)&0x020000)>>SPITXBF); //0x40F00[17]
}

void DrvSPI32_EnableRxInt(void)
{
	uint32_t l_reg,l_data;
	l_reg=R_SPI_INTERRUPT_CTRL;
	l_data=(1<<SPIRxIE)|(1<<SPIRxIE_MASK);
	outw(l_reg,l_data);
}


void DrvSPI32_EnableTxInt(void)
{
	uint32_t l_reg,l_data;
	l_reg=R_SPI_INTERRUPT_CTRL;
	l_data=(1<<SPITxIE)|(1<<SPITxIE_MASK);
	outw(l_reg,l_data);
}


void DrvSPI32_DisableRxInt(void)
{
	uint32_t l_reg,l_data;
	l_reg=R_SPI_INTERRUPT_CTRL;
	l_data=(1<<SPIRxIE_MASK);
	outw(l_reg,l_data);
}


void DrvSPI32_DisableTxInt(void)
{
	uint32_t l_reg,l_data;
	l_reg=R_SPI_INTERRUPT_CTRL;
	l_data=(1<<SPITxIE_MASK);
	outw(l_reg,l_data);
}


uint32_t DrvSPI32_GetRxIntFlag(void)
{
	uint32_t l_reg,ReturnVal;
	ReturnVal=0;
	l_reg=R_SPI_INTERRUPT_CTRL;
	ReturnVal=((inw(l_reg)&0x1)>>(SPIRxIF));  //0x40000[0]
	return ReturnVal;
}

uint32_t DrvSPI32_GetTxIntFlag(void)
{
	uint32_t l_reg,ReturnVal;
	ReturnVal=0;
	l_reg=R_SPI_INTERRUPT_CTRL;
	ReturnVal=((inw(l_reg)&0x2)>>(SPITxIF));  //0x40000[1]
	return ReturnVal;
}

void DrvSPI32_ClrIntRxFlag(void)
{
	uint32_t l_reg,l_data;
	l_reg=R_SPI_INTERRUPT_CTRL;
	l_data=(1<<SPIRxIF_MASK);
	outw(l_reg,l_data);
}

void DrvSPI32_ClrIntTxFlag(void)
{
	uint32_t l_reg,l_data;
	l_reg=R_SPI_INTERRUPT_CTRL;
	l_data=(1<<SPITxIF_MASK);
	outw(l_reg,l_data);
}

uint32_t DrvSPI32_Read(void)
{
	uint32_t l_reg;
	l_reg=R_SPI32_INPUT_BUFFER;
	return inw(l_reg);
}

void DrvSPI32_Write(uint32_t uData)
{
	uint32_t l_reg;
	l_reg=R_SPI32_OUTPUT_BUFFER;
	outw(l_reg,uData);
}


void DrvSPI32_Enable(void)
{
	uint32_t l_reg,l_data;
	l_reg=R_SPI32_CTRL1;
	l_data=(1<<SPIEN)|(1<<SPIEN_MASK);
	outw(l_reg,l_data);
}


void DrvSPI32_BitLength(uint32_t uData)
{
	uint32_t l_reg,l_data;
	if((uData<33)&&(uData>3)){
		l_reg=R_SPI32_CTRL2;
		l_data=uData-1;
		outw(l_reg,l_data);
	}
}


uint32_t DrvSPI32_GetDCFlag(void)
{
	uint32_t l_reg;
	l_reg=R_SPI32_CTRL1;
	//Robert add 2016/8/3
	return ((inw(l_reg)&(1<<DCF))>>DCF);   //0x40F00[18]
}


uint32_t DrvSPI32_IsABFlag(void)
{
	uint32_t l_reg;
	l_reg=R_SPI32_CTRL1;
	//Robert add 2016/8/3
	return ((inw(l_reg)&(1<<ABF))>>ABF); //0x40F00[20]
}

uint32_t DrvSPI32_IsOVFlag(void)
{
	uint32_t l_reg;
	l_reg=R_SPI32_CTRL1;
	//Robert add 2016/8/3
	return ((inw(l_reg)&(1<<OVF))>>OVF); //0x40F00[21]
}

uint32_t DrvSPI32_IsRxFlag(void)
{
	uint32_t l_reg;
	l_reg=R_SPI32_CTRL1;
	//Robert add 2016/8/3
	return ((inw(l_reg)&(1<<RXF))>>RXF); //0x40F00[22]
}

void DrvSPI32_SetEndian(E_DRVSPI_ENDIAN eEndian)
{
	uint32_t l_reg,l_data;
		l_reg=R_SPI32_CTRL2;
		l_data=inw(l_reg)&0xff;
		l_data|=(eEndian<<LBF)+(1<<LBF_MASK);
		outw(l_reg,l_data);
}


/*******************************************************************
*name    : DrvSPI32_SetCSO
*function: ?离CSO??
*input   : eCS?CSO??
*output  :
*Version : v0.1
*date    : 2015-6-8
*modify  :
*********************************************************************/
void DrvSPI32_SetCSO(E_DRVSPI_CS eCS)
{
	uint32_t l_reg,l_data;
		l_reg=R_SPI32_CTRL2;
		l_data=inw(l_reg)&0xff;
		l_data|=(eCS<<CSO)+(1<<CSO_MASK);
		outw(l_reg,l_data);
}

/*******************************************************************
*name    : void DrvSPI32_DisableIO(void)
*function: 壽?IO??峈SPI籵?IO諳?髡?
*input   : none
*output  : none
*Version : v1.0
*date    : 2014-1-17
*modify  : none
*********************************************************************/
void DrvSPI32_DisableIO(void)
{
	uint32_t l_reg,l_data;
	l_data=0;
	l_reg=R_SPI_PIN_CTRL;
	l_data=1<<SPPTOE_MASK;
	outw(l_reg,l_data);
}


/*******************************************************************
*name    : DrvSPI32_EnableIO
*function: 羲??扢离IO????SPI籵??
*input   : uoutputpin IO option
*output  : 0:success 1:fail
*Version : v1.0
*date    : 2014-1-17
*modify  : none
*********************************************************************/
unsigned char DrvSPI32_EnableIO(uint32_t uOuputPin)
{
	uint32_t l_reg,l_data;
	l_data=0;
	l_reg=R_SPI_PIN_CTRL;
	//Robert add 2016/7/19
	//if(uOuputPin<4)
	if(uOuputPin<0x8)
	{
		l_data=(1<<SPPTOE)|(1<<SPPTOE_MASK);  //fixed bit4=1b
		//Robert add 2016/7/19
		//l_data|=(uOuputPin<<SPPTS)|(SPPTS_MAX<<SPPTS_MASK);
		l_data|=(uOuputPin<<SPPTS)|(0x7<<SPPTS_MASK); //uOuputPin control bit5~7
		outw(l_reg,l_data);
		return E_SUCCESS;
	}
	else
		return E_FAIL;
}
