/*
 * DrvRTC.h
 *
 *  Created on: 2016/08/15
 *  Author: Robert.Wang
 *  Version : V0.0, 2016/08/15
 *  
 */

#ifndef DRVRTC_H_
#define DRVRTC_H_

#ifdef SYSINFRA_H_
#define SYSINFRA
#endif

#include "HY16F3981.h"
#include "DrvREG32.h"

//#  AM / PM				                                                         						   */
#define DRVRTC_AM				0
#define DRVRTC_PM				1

#define DRVRTC_YEAR2000			2000

#ifndef E_SUCCESS
#define E_SUCCESS		0
#endif

#ifndef E_FAIL
#define E_FAIL		1
#endif

#define E_DRVRTC_ARGUMENT E_FAIL

typedef enum
{
	E_EXTERNAL_CLOCK = 0,
	E_INTERNAL_CLOCK = 1
} E_DRVRTC_CLOCK_SOURCE;

typedef enum
{
	E_DRVRTC_1_128_SEC = 0,
	E_DRVRTC_1_64_SEC,
	E_DRVRTC_1_32_SEC,
	E_DRVRTC_1_16_SEC,
	E_DRVRTC_1_8_SEC,
	E_DRVRTC_1_4_SEC,
	E_DRVRTC_1_2_SEC,
	E_DRVRTC_1_SEC
} E_DRVRTC_TICK;

typedef enum
{
	DRVRTC_CURRENT_TIME    =    0,
	DRVRTC_ALARM_TIME      =    1
}E_DRVRTC_TIME_SELECT;

typedef enum
{
  E_DRVRTC_HOUR_24 = 0,
  E_DRVRTC_HOUR_12 = 1
} E_DRVRTC_HOUR_FORMAT;

typedef enum
{
  E_DRVRTC_ALARM_FLAG=0,
  E_DRVRTC_PERIODIC_FLAG,
  E_DRVRTC_CLEAR_ALL
} E_DRVRTC_FLAG;

typedef enum
{
    DRVRTC_SUNDAY         =   0,
    DRVRTC_MONDAY         =   1,
    DRVRTC_TUESDAY        =   2,
    DRVRTC_WEDNESDAY      =   3,
    DRVRTC_THURSDAY       =   4,
    DRVRTC_FRIDAY         =   5,
    DRVRTC_SATURDAY       =   6
}E_DRVRTC_DWR_PARAMETER;


typedef struct
{
    uint8_t u8cClockDisplay;                                         /* 12-Hour, 24-Hour */
    uint8_t u8cAmPm;                                                 /* Only 12-hr used */
    uint32_t u32cSecond;
    uint32_t u32cMinute;
    uint32_t u32cHour;
    uint32_t u32cDayOfWeek;
    uint32_t u32cDay;
    uint32_t u32cMonth;
    uint32_t u32Year;
	uint8_t  u8IsEnableWakeUp;                                       /* Wakeup Enable */
}S_DRVRTC_TIME_DATA_T;


#ifdef SYSINFRA

#define E_DRVRTC_ERR_CM_VALUE			_SYSINFRA_ERRCODE(TRUE,  MODULE_ID_DRVRTC, 4)
#endif

unsigned int DrvRTC_SetFrequencyCompensation(unsigned int uFrequencyCom);
void DrvRTC_WriteEnable(void);
void DrvRTC_WriteDisable(void);
void DrvRTC_AlarmEnable(void);
void DrvRTC_AlarmDisable(void);
unsigned int DrvRTC_PeriodicTimeEnable(E_DRVRTC_TICK uPeriodicTimer);
void DrvRTC_PeriodicTimeDisable(void);
void DrvRTC_Enable(void);
void DrvRTC_Disable(void);
uint32_t DrvRTC_HourFormat(E_DRVRTC_HOUR_FORMAT uHourFormat);
uint32_t DrvRTC_ReadState(void);
uint32_t DrvRTC_ClearState(E_DRVRTC_FLAG uFlag);
void DrvRTC_EnableInt(void);
void DrvRTC_DisableInt(void);
unsigned int DrvRTC_ReadIntFlag(void);
void DrvRTC_ClearIntFlag(void);
uint32_t DrvRTC_Write(E_DRVRTC_TIME_SELECT eTime, S_DRVRTC_TIME_DATA_T *sPt);
uint32_t DrvRTC_Read(E_DRVRTC_TIME_SELECT eTime, S_DRVRTC_TIME_DATA_T *sPt);
unsigned char DrvRTC_ClkConfig(unsigned char uclken);
//unsigned int DrvRTC_ClockSource(E_DRVRTC_CLOCK_SOURCE uClockSource);
//2021/09/06 Robert add
void DrvRTC_EnableWUEn(void);
void DrvRTC_DisableWUEn(void);

#endif /* DRVRTC_H_ */
