/*
 *  Created on: 2016/7/28
 *  Author: Robert.Wang
 *  Memo : HY16F3981 DrvRTC.c is base on HY16F198B to modify
*/

#include "DrvRTC.h"
#include "SpecialMacro.h"

/*******************************************************************
*name    : DrvRTC_SetFrequencyCompensation(uint32_t uFrequencyCom)
*function: setting Frequency compensation
*input   : uFrequencycom
*output  : 0/others
*Version : v1.1
*date    : 2014-1-8
*modify  : ???离源?妏??迡?湮?x3f??
*********************************************************************/
uint32_t DrvRTC_SetFrequencyCompensation(uint32_t uFrequencyCom)
{
  if(uFrequencyCom > 0x7f)
  {
#ifdef SYSINFRA
     return E_DRVRTC_ERR_FCR_VALUE;
#else
	 return uFrequencyCom ;
#endif
  }
	 outpw(&RTC->Correction, (uint32_t)((uFrequencyCom<<16)|(uFrequencyCom<<24)));
	 return E_SUCCESS;
}


void DrvRTC_WriteEnable(void)
{
	outpw(&RTC->State, (uint32_t)(0x6<<20));
}

void DrvRTC_WriteDisable(void)
{
	outpw(&RTC->State, (uint32_t)(0x00<<20));
}



void DrvRTC_AlarmEnable(void)
{
	uint32_t RTC_temp;
	RTC_temp=inpw(&RTC->State)&0xf00000;
	outpw(&RTC->State, (uint32_t)(RTC_temp|0x18|(0x18<<8)));
}

void DrvRTC_AlarmDisable(void)
{
	uint32_t RTC_temp;
	RTC_temp=inpw(&RTC->State)&0xf00000;
	outpw(&RTC->State, (uint32_t)(RTC_temp|0x8<<8));
}

uint32_t DrvRTC_PeriodicTimeEnable(E_DRVRTC_TICK uPeriodicTimer)
{
	uint32_t RTC_temp;
	if(uPeriodicTimer > 0x7) return uPeriodicTimer;
    RTC_temp=inpw(&RTC->State)&0xf00000;
	outpw(&RTC->State, (uint32_t)(RTC_temp|0x30|(0x30<<8)));
	outpw(&RTC->Correction, (uint32_t)(uPeriodicTimer|(7<<8)));
	return E_SUCCESS;
}

void DrvRTC_PeriodicTimeDisable(void)
{
	uint32_t RTC_temp;
	RTC_temp=inpw(&RTC->State)&0xf00000;
	outpw(&RTC->State, (uint32_t)(RTC_temp|0x30<<8));
}

void DrvRTC_Enable(void)
{
	uint32_t RTC_temp;
	RTC_temp=inpw(&RTC->State)&0xf00000;
	outpw(&RTC->State, (uint32_t)(RTC_temp|0x1|(0x1<<8)));
}

void DrvRTC_Disable(void)
{
	uint32_t RTC_temp;
	RTC_temp=inpw(&RTC->State)&0xf00000;
	outpw(&RTC->State, (uint32_t)(RTC_temp|0x1<<8));
}

/*******************************************************************
*name    : DrvRTC_HourFormat(E_DRVRTC_HOUR_FORMAT uHourFormat)
*function: setting hour format
*input   : uHourFmat: 0 12hour 1 24hour
*output  : 0 success/1 fail
*Version : v1.1
*date    : 2014-1-8
*modify  : ????跡??扢?
*********************************************************************/
uint32_t DrvRTC_HourFormat(E_DRVRTC_HOUR_FORMAT uHourFormat)
{
	uint32_t RTC_temp;
	if(uHourFormat > 0x1) return uHourFormat;
	RTC_temp=inpw(&RTC->State)&0xf00000;
	outpw(&RTC->State, (uint32_t)(RTC_temp|(uHourFormat<<2)|(0x4<<8)));
	return E_SUCCESS;
}

uint32_t DrvRTC_ReadState(void)
{
	return (inpw(&RTC->State)&0xf0000)>>16;
}

uint32_t DrvRTC_ClearState(E_DRVRTC_FLAG uFlag)
{
	uint32_t RTC_temp;
	if(uFlag > 0x2) return uFlag;
	RTC_temp=inpw(&RTC->State)&0xf00000;
	switch(uFlag)
	{
		case E_DRVRTC_ALARM_FLAG:
			outpw(&RTC->State, (uint32_t)(RTC_temp|(0x10000<<8)));
			break;
		case E_DRVRTC_PERIODIC_FLAG:
			outpw(&RTC->State, (uint32_t)(RTC_temp|(0x40000<<8)));
			break;
		case E_DRVRTC_CLEAR_ALL:
			outpw(&RTC->State, (uint32_t)(RTC_temp|(0x50000<<8)));
			break;
	}
	return E_SUCCESS;
}

void DrvRTC_EnableInt(void)
{
	outpw(&INT_TIME->TIME, (uint32_t)(0x200000|(0x200000<<8)));
}

void DrvRTC_DisableInt(void)
{
	outpw(&INT_TIME->TIME, (uint32_t)(0x200000<<8));
}

unsigned int DrvRTC_ReadIntFlag(void)
{
	//Robert add 2016/8/5
	unsigned int l_reg,ReturnVal;
	l_reg=0x40004;
	ReturnVal=((inw(l_reg)&0x20)>>(5));  //Read 0x40004[5]
	return ReturnVal;
	//return (inpw(&INT_TIME->TIME)&0x20)>>5;
}

void DrvRTC_ClearIntFlag(void)
{
	outpw(&INT_TIME->TIME, (uint32_t)(0x20<<8));
}


/*******************************************************************
*name    : DrvRTC_Write(E_DRVRTC_TIME_SELECT eTime, S_DRVRTC_TIME_DATA_T *sPt)
*function: setting the time and date
*input   : eTime: 0 current time or 1 alarm time; *sPt time and date point
*output  : 0 success; 1 fail;
*Version : v1.2
*date    : 2015-5-26
*modify  : 12??秶?????祥????徹11?摯???迡??秶?AM弇褫?离1
*********************************************************************/
uint32_t DrvRTC_Write(E_DRVRTC_TIME_SELECT eTime, S_DRVRTC_TIME_DATA_T *sPt)
{
    uint32_t u32Reg ,RTC_temp;
    /*-----------------------------------------------------------------------------------------------------*/
    /* Check RTC time data value is reasonable or not.                                                     */
    /*-----------------------------------------------------------------------------------------------------*/
    if ( ((sPt->u32Year - DRVRTC_YEAR2000) > 99)|
         ((sPt->u32cMonth == 0) || (sPt->u32cMonth > 12))|
         ((sPt->u32cDay   == 0) || (sPt->u32cDay   > 31)))
    {
        return E_FAIL;
    }

    if (sPt->u8cClockDisplay == E_DRVRTC_HOUR_12)
    {
    	if (sPt->u32cHour > 11)
        {
            return E_FAIL;
        }
    }
    else if (sPt->u8cClockDisplay == E_DRVRTC_HOUR_24)
    {
        if (sPt->u32cHour > 23)
        {
            return E_FAIL;
        }
    }
    else
    {
        return E_FAIL;
    }

    if (sPt->u8cAmPm != 1)
    	sPt->u8cAmPm = 0;

    if (sPt->u32cMinute > 59)
        return E_FAIL;


    if (sPt->u32cSecond > 59)
        return E_FAIL;

    if (sPt->u32cDayOfWeek > 6)
        return E_FAIL;

    switch (eTime)
    {

        case DRVRTC_CURRENT_TIME:
            /*---------------------------------------------------------------------------------------------*/
            /* Second, set RTC time data.                                                                  */
            /*---------------------------------------------------------------------------------------------*/
        	RTC_temp=inpw(&RTC->State)&0xf00000;
            if (sPt->u8cClockDisplay == E_DRVRTC_HOUR_24)
					//outpw(&RTC->State, (uint32_t)(RTC_temp|0x4|(4<<8)));
					outpw(&RTC->State, (uint32_t)(RTC_temp|0x4<<8));
            else                                                                  /* RTC_CLOCK_24 */
    			//outpw(&RTC->State, (uint32_t)(RTC_temp|0x4<<8));
    			outpw(&RTC->State, (uint32_t)(RTC_temp|0x4|(4<<8)));

  			outpw(&RTC->DW, (uint32_t)(sPt->u32cDayOfWeek|(sPt->u32cDayOfWeek<<8)));
			/*---------------------------------------------------------------------------------------------*/
            /* Second, set RTC time data.                                                                  */
            /*---------------------------------------------------------------------------------------------*/
			outpw(&RTC->YM, (uint32_t)(0xff00ff00 |
				(((sPt->u32Year - DRVRTC_YEAR2000) / 10) <<20 )|
				(((sPt->u32Year - DRVRTC_YEAR2000) % 10) << 16)|
				((sPt->u32cMonth  / 10) << 4)|
				((sPt->u32cMonth  % 10) )
			    )
			);

			outpw(&RTC->DW, (uint32_t)(0xff000000 |
				((sPt->u32cDay    / 10) << 20)|
				((sPt->u32cDay    % 10) << 16)
		        )
			);

			outpw(&RTC->APH, (uint32_t)(0xff00 |
							((sPt->u8cAmPm) << 6)|
					        ((sPt->u32cHour / 10) << 4)|
					        (sPt->u32cHour % 10)
						    )
						);

			outpw(&RTC->MS, (uint32_t)(0xff00ff00 |
					        ((sPt->u32cMinute / 10) << 20)|
					        ((sPt->u32cMinute % 10) << 16)|
					        ((sPt->u32cSecond / 10) << 4)|
					        (sPt->u32cSecond % 10)
						    )
						);

            return E_SUCCESS;


         case DRVRTC_ALARM_TIME:
			/*---------------------------------------------------------------------------------------------*/
            /* Set Calender alarm time data.                                                               */
            /*---------------------------------------------------------------------------------------------*/
		    u32Reg     = ((sPt->u32Year - DRVRTC_YEAR2000) / 10) << 20;
		    u32Reg    |= (((sPt->u32Year - DRVRTC_YEAR2000) % 10) << 16);
		    u32Reg    |= ((sPt->u32cMonth  / 10) << 12);
		    u32Reg    |= ((sPt->u32cMonth  % 10) << 8);
		    u32Reg    |= ((sPt->u32cDay    / 10) << 4);
		    u32Reg    |= (sPt->u32cDay     % 10);
			outpw(&RTC->AYMD, (uint32_t)u32Reg);



			/*---------------------------------------------------------------------------------------------*/
            /* Set Time alarm time data.                                                                   */
            /*---------------------------------------------------------------------------------------------*/
		    u32Reg     = ((sPt->u32cHour / 10) << 20);
		    u32Reg    |= ((sPt->u32cHour % 10) << 16);
		    u32Reg    |= ((sPt->u32cMinute / 10) << 12);
		    u32Reg    |= ((sPt->u32cMinute % 10) << 8);
		    u32Reg    |= ((sPt->u32cSecond / 10) << 4);
		    u32Reg    |= (sPt->u32cSecond % 10);
		    outpw(&RTC->AHMS, (uint32_t)u32Reg);

			return E_SUCCESS;


	        default:
	        {
	            return E_FAIL;
	        }
    }

}


uint32_t DrvRTC_Read(E_DRVRTC_TIME_SELECT eTime, S_DRVRTC_TIME_DATA_T *sPt)
{
    sPt->u8cClockDisplay = RTC->State.HRF;
    sPt->u32cDayOfWeek   = RTC->DW.WDA;

    switch (eTime)
    {
        case DRVRTC_CURRENT_TIME:
        {
    		sPt->u32Year   =  RTC->YM.YEAR10*10 + RTC->YM.YEAR1+ DRVRTC_YEAR2000;
    		sPt->u32cMonth =  RTC->YM.MO10*10 + RTC->YM.MO1;
    		sPt->u32cDay   =  RTC->DW.DAT10*10  + RTC->DW.DAT1;
            sPt->u32cHour = RTC->APH.HR10*10 + RTC->APH.HR1;
    	    sPt->u8cAmPm  = RTC->APH.PM;
    	    sPt->u32cMinute = RTC->MS.MIN10*10 + RTC->MS.MIN1;
    	    sPt->u32cSecond = RTC->MS.SEC10*10 + RTC->MS.SEC1;
            break;
		}
        case DRVRTC_ALARM_TIME:
        {
        	sPt->u32Year   =  RTC->AYMD.CYE10*10 + RTC->AYMD.CYE1+ DRVRTC_YEAR2000;
        	sPt->u32cMonth =  RTC->AYMD.CMO10*10 + RTC->AYMD.CMO1;
        	sPt->u32cDay   =  RTC->AYMD.CDAT10*10  + RTC->AYMD.CDAT1;
        	sPt->u32cHour = RTC->AHMS.CHR10*10 + RTC->AHMS.CHR1;
        	sPt->u8cAmPm  = RTC->AHMS.CPM;
        	sPt->u32cMinute = RTC->AHMS.CMI10*10 + RTC->AHMS.CMI1;
        	sPt->u32cSecond = RTC->AHMS.CSE10*10 + RTC->AHMS.CSE1;
            break;
        }
        default:
        {
            return E_FAIL;
        }
    }

    return E_SUCCESS;

}

/*******************************************************************
*name    : unsigned char DrvRTC_ClkConfig(unsigned char uclken)
*function: enable or disable the RTC clock
*input   : uclken:0 disable RTC clock,
*                 1 enable RTC clock
*output  : 0/1
*Version : v1.0
*date    : 2014-1-7
*modify  : 氝?妏?RTC clock?諷秶?uclken
*********************************************************************/
unsigned char DrvRTC_ClkConfig(unsigned char uclken)
{
	unsigned int l_reg,l_data;
	l_reg=0x40308;
	if(uclken<(0x3+1))
		{
			//clk_08=0x80000000|(uclken<<22);
		  l_data=inw(l_reg)&0xC0000000;
			l_data|=(uclken<<22)|(15<<(22+8));  //set 0X40308[23:22]=xxb
			outw(l_reg,l_data);
			return E_SUCCESS;
		}
	else return E_FAIL ;
}
//2021/09/06 Robert add new C Library.
void DrvRTC_EnableWUEn(void)
{
  uint32_t RTC_temp;
  RTC_temp=inpw(&RTC->State)&0xf00000;
  outpw(&RTC->State, (uint32_t)(RTC_temp|0x18|(0x10<<8)));  //0x41A00[4]=1b
}

void DrvRTC_DisableWUEn(void)
{
  uint32_t RTC_temp;
  RTC_temp=inpw(&RTC->State)&0xf00000;
  outpw(&RTC->State, (uint32_t)(RTC_temp|0x10<<8));  //0x41A00[4]=0b
}