/*
 *  DrvPMU.h
 *
 *  Created on: 2016/08/15
 *  Author: Robert.Wang
 *  Version : V0.0
 *  Created on: 2018/03/02
 *  Version : V0.2 
 *  Created on: 2022/04/19
 *  Version : V0.3 
 *  
 */

#include "HY16F3981.h"

#ifndef E_FAIL
#define E_FAIL		1
#endif

#define E_DRVPMU_ARGUMENT E_FAIL

#ifndef E_SUCCESS
#define E_SUCCESS	0
#endif

#define PMU_CTRL  (PMU_BASE+OFFSET00)  //0x40400
#define LVD_CTRL  (PMU_BASE+OFFSET08)  //0x40408

//0x40400
//2022/4/19 robert modify
typedef enum
{
	E_VDDA2_4 = 0,
	E_VDDA2_6 = 1,
	E_VDDA2_9 = 2,
	E_VDDA3_2 = 3
} E_VDDA_OUTPUT_VOLTAGE;

typedef enum
{
	E_HighZ     = 0,
	E_VDD3V     = 1,
	E_PullDown  = 2,
	E_LDO       = 3
} E_VDDA_LDO_ENABLE_CONTROL;

//0x40408
typedef enum
{
	LVD_V12_BOR = 0,  //0
	LVD_V12_BGR,      //1
} E_LVD_LVD12;

typedef enum
{
	LVD_VDD3V = 0,  //0
	LVD_VLCD,       //1
} E_LVD_LVDVS;

typedef enum
{
	LVD_LVDIN = 0,
	LVD_20V   = 1,
	LVD_21V   = 2,
	LVD_22V   = 3,
	LVD_23V   = 4,
	LVD_24V   = 5,
	LVD_25V   = 6,	
	LVD_26V   = 7,
	LVD_27V   = 8,
	LVD_28V   = 9,
	LVD_29V   = 10,
	LVD_30V   = 11,
	LVD_31V   = 12,		
	LVD_32V   = 13,
	LVD_33V   = 14,
	LVD_34V   = 15,
} E_LVD_LVDS;

//0x40400
#define VDAS         18
#define ENVA         16
#define ENBGR        4
#define ACMS         3
#define ENCHP        2
#define ENRFO        1
#define VDDLP        0
#define VDAS_MASK    (VDAS+MASK)
#define ENVA_MASK    (ENVA+MASK)
#define ENBGR_MASK   (ENBGR+MASK)
#define ACMS_MASK    (ACMS+MASK)
#define ENCHP_MASK   (ENCHP+MASK)
#define ENRFO_MASK   (ENRFO+MASK)
#define VDDLP_MASK   (VDDLP+MASK)
#define VDAS_MAX     3
#define ENVA_MAX     3
#define ACMS_MAX     1
#define VDDLP_MAX    1

//0x40408
#define LVDEN        0
#define LVDEN_MASK   8
#define LVDVS        1
#define LVDVS_MASK   9
#define LVD12        2
#define LVD12_MASK   10
#define LVDS         4
#define LVDS_MASK    12
#define LVDVS_MAX    1
#define LVD12_MAX    1
#define LVDS_MAX     15

//0x40400
unsigned int DrvPMU_VDDA_Voltage(unsigned int uVoltage);
unsigned int DrvPMU_VDDA_LDO_Ctrl(unsigned int uCtrl);
void DrvPMU_BandgapEnable(void);
void DrvPMU_BandgapDisable(void);
void DrvPMU_REFO_Enable(void);
void DrvPMU_REFO_Disable(void);
unsigned int DrvPMU_AnalogGround(unsigned int uAG);
unsigned int DrvPMU_LDO_LowPower(unsigned int uLP);

//0x40408
void DrvPMU_DisableENLVD (void);
void DrvPMU_EnableENLVD (void);
void DrvPMU_SetLVDVS(unsigned char uLVDVS);
void DrvPMU_SetLVD12(unsigned char uLVD12);
void DrvPMU_SetLVDS(unsigned int uLVDS);
unsigned int DrvPMU_GetLVDO(void);
