/*
 *  Created on: 2016/7/28
 *  Author: Robert.Wang
 *  Memo : HY16F3981 DrvPMU.c is base on HY16F198B to modify
 *  Created on: 2018/03/02
 *  Version : V0.2 
*/

#include "DrvPMU.h"
#include "SpecialMacro.h"
#include "HY16F3981.h"

/*----------------------------------------------------------------------------*/
/* 0x40400                                                                    */
/*----------------------------------------------------------------------------*/
unsigned int DrvPMU_VDDA_Voltage(unsigned int uVoltage)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=PMU_CTRL;
	if(uVoltage<(VDAS_MAX+1))
	{
		l_data=(uVoltage<<VDAS)|(VDAS_MAX<<(VDAS_MASK));
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVPMU_ARGUMENT;
	return ReturnVal;
}

unsigned int DrvPMU_VDDA_LDO_Ctrl(unsigned int uCtrl)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=PMU_CTRL;
	if(uCtrl<(ENVA_MAX+1))
	{
		l_data=(uCtrl<<ENVA)|(ENVA_MAX<<(ENVA_MASK));
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVPMU_ARGUMENT;
	return ReturnVal;
}

void DrvPMU_BandgapEnable(void)
{
	unsigned int l_reg,l_data;
	l_reg=PMU_CTRL;
	l_data=(1<<ENBGR)|(1<<ENBGR_MASK);
	outw(l_reg,l_data);
}

void DrvPMU_BandgapDisable(void)
{
	unsigned int l_reg,l_data;
	l_reg=PMU_CTRL;
	l_data=(1<<ENBGR_MASK);
	outw(l_reg,l_data);
}


void DrvPMU_REFO_Enable(void)
{
	unsigned int l_reg,l_data;
	l_reg=PMU_CTRL;
	l_data=(1<<ENRFO)|(1<<ENRFO_MASK);
	outw(l_reg,l_data);
}

void DrvPMU_REFO_Disable(void)
{
	unsigned int l_reg,l_data;
	l_reg=PMU_CTRL;
	l_data=(1<<ENRFO_MASK);
	outw(l_reg,l_data);
}

unsigned int DrvPMU_AnalogGround(unsigned int uAG)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=PMU_CTRL;
	if(uAG<(ACMS_MAX+1))
	{
		l_data=(uAG<<ACMS)|(ACMS_MAX<<(ACMS_MASK));
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVPMU_ARGUMENT;
	return ReturnVal;
}

unsigned int DrvPMU_LDO_LowPower(unsigned int uLP)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=PMU_CTRL;
	if(uLP<(VDDLP_MAX+1))
	{
		l_data=(uLP<<VDDLP)|(VDDLP_MAX<<(VDDLP_MASK));
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVPMU_ARGUMENT;
	return ReturnVal;
}


/*----------------------------------------------------------------------------*/
/* 0x40408                                                                    */
/*----------------------------------------------------------------------------*/
unsigned int DrvPMU_GetLVDO(void)
{
	return ((inw(LVD_CTRL)&0x10000)>>16);  //Get 0x40404[16]
}


void DrvPMU_SetLVDS(unsigned int uLVDS)
{
	unsigned int l_reg,l_data,ReturnVal;
	l_reg=LVD_CTRL;
	if(uLVDS<(LVDS_MAX+1))
	{
		l_data=(uLVDS<<LVDS)|(LVDS_MAX<<(LVDS_MASK));
		outw(l_reg,l_data);
	}
}

void DrvPMU_SetLVD12(unsigned char uLVD12)
{
	unsigned int l_reg,l_data;
	l_reg=LVD_CTRL;
	if(uLVD12<(LVD12_MAX+1))
	{
		l_data=(uLVD12<<LVD12)|(LVD12_MAX<<(LVD12_MASK));
		outw(l_reg,l_data);
	}
}

void DrvPMU_SetLVDVS(unsigned char uLVDVS)
{
	unsigned int l_reg,l_data;
	l_reg=LVD_CTRL;
	if(uLVDVS<(LVDVS_MAX+1))
	{
		l_data=(uLVDVS<<LVDVS)|(LVDVS_MAX<<(LVDVS_MASK));
		outw(l_reg,l_data);
	}
}

void DrvPMU_EnableENLVD(void)
{
	unsigned int l_reg,l_data;
	l_reg=LVD_CTRL;
	l_data=(1<<LVDEN)|(1<<LVDEN_MASK);
	outw(l_reg,l_data);
}

void DrvPMU_DisableENLVD(void)
{
	unsigned int l_reg,l_data;
	l_reg=LVD_CTRL;
	l_data=(1<<LVDEN_MASK);
	outw(l_reg,l_data);	
}




