/*
 * DrvOP.h
 *
 *  Created on: 2016/08/15
 *  Author: Robert.Wang
 *  Version : V0.0, 2016/08/15
 *  
 */


#ifndef DRVOP_H_
#define DRVOP_H_
#include "HY16F3981.h"


#ifndef E_FAIL
#define E_FAIL		1
#endif
#define E_DRVOP_ARGUMENT E_FAIL
#define E_DRVOP_ARGUMENT1 0xf0

#ifndef E_SUCCESS
#define E_SUCCESS		0
#endif

#ifdef OP_BASE
#define OP_CTRL OP_BASE+OFFSET00;
#define OP_INPUT OP_BASE+OFFSET04;
#endif

#ifdef INTERRUPT_BASE
#define OP_INTERRUPT_CTRL  (INTERRUPT_BASE+OFFSET0C)
#endif

#ifdef GPIO_BASE
#define GPIO_OP_CTRL     (GPIO_BASE+OFFSET40)
#endif

typedef enum
{
	E_OPO1 = 0,
	E_OPO2 = 1
} E_OUTPUT_PIN;
typedef enum
{
	E_OPP_AIO7=0X40,
	E_OPP_AIO6=0X20,
	E_OPP_AIO5=0X10,
	E_OPP_REFO=0X8,
	E_OPP_REFO_I=0X8,
	E_OPP_DAO =0X4,
	E_OPP_AIO4=0X2,
	E_OPP_AIO2=0X1
}E_OPN_PPIN;

typedef enum
{
	E_OPN_AIO8=0X80,
	E_OPN_AIO2=0X40,	
	E_OPN_OPC =0X20,
	E_OPN_OPO=0X10,
	E_OPN_OPOI =0X8,
	E_OPN_DAO =0X4,
	E_OPN_AIO5=0X2,
	E_OPN_AIO3=0X1
}E_OPN_NPIN;

#define OPOD     			7
#define OPOS     			6
#define OP_Inv     			5
#define OPCS     			4
#define OPDFR     			3
#define OPDEN    			2
#define OPOE     			1
#define ENOP     			0
#define OPOD_MASK			(7+MASK)
#define OPOS_MASK 			(6+MASK)
#define OP_INV_MASK			(5+MASK)
#define OPCS_MASK 			(4+MASK)
#define OPDFR_MASK			(3+MASK)
#define OPDEN_MASK			(2+MASK)
#define OPOE_MASK  		    (1+MASK)
#define ENOP_MASK      	    (0+MASK)
#define OPOE_MAX		    (0x1)

#define OPPS     			16
#define OPNS     			0
#define OPPS_MASK 			(OPPS+MASK)
#define OPNS_MASK 			(OPNS+MASK)
#define OPPS_MASK_BIT		(0x7f)
#define OPNS_MASK_BIT		(0xff)
#define OPPS_MAX		(0x7f)
#define OPNS_MAX		(0xff)

#define OPIE     			16
#define OPIF     			1
#define OPIE_MASK           (OPIE+MASK)
#define OPIF_MASK            MASK



void DrvOP_Open(void);
void DrvOP_Close(void);
unsigned int DrvOP_PInput(unsigned int uOPPS);
unsigned int DrvOP_NInput(unsigned int uOPNS);
void DrvOP_OPOoutEnable(void);
void DrvOP_OPOoutDisable(void);
unsigned int DrvOP_OuputFilter(unsigned int uFilter);
unsigned int DrvOP_OutputPinEnable(E_OUTPUT_PIN uPin);
void DrvOP_OutputPinDisable(void);
unsigned int DrvOP_OutputInverse(unsigned int uInv);
unsigned int DrvOP_OutputWithCHPCK(unsigned int uCHPCK);
//unsigned int DrvOP_OutputWithCPCLK(unsigned int uCPCLK);
void DrvOP_EnableInt(void);
void DrvOP_DisableInt(void);
unsigned int DrvOP_ReadIntFlag(void);
void DrvOP_ClearIntFlag(void);
unsigned int DrvOP_Feedback(unsigned int uFeedback);
unsigned char DrvOP_OPDEN(unsigned char uOPDEN);

#endif /* DRVOP_H_ */
