/*
 *  Created on: 2016/7/28
 *  Author: Robert.Wang
 *  Memo : HY16F3981 DrvOP.c is base on HY16F198B to modify
*/

#include "DrvOP.h"
#include "DrvGPIO.h"
#include "SpecialMacro.h"

void DrvOP_Open(void)
{   unsigned int l_reg,l_data;
    l_reg=OP_CTRL;
    l_data=(0x1<<ENOP)|(0x1<<ENOP_MASK);
	outw(l_reg,l_data);
}

void DrvOP_Close(void)
{   unsigned int l_reg,l_data;
    l_reg=OP_CTRL;
    l_data=1<<ENOP_MASK;
	outw(l_reg,l_data);
}

unsigned int DrvOP_PInput(unsigned int uOPPS)
{
	unsigned int l_reg,l_data;
	if (uOPPS<OPPS_MAX+1)
	{
	   l_reg=OP_INPUT;
	   l_data=(uOPPS<<OPPS)|(OPPS_MASK_BIT<<OPPS_MASK);
	   outw(l_reg,l_data);
	}else return E_DRVOP_ARGUMENT;
	return E_SUCCESS;
}

unsigned int DrvOP_NInput(unsigned int uOPNS)
{
	unsigned int l_reg,l_data;
	if (uOPNS<OPNS_MAX+1)
	{
	   l_reg=OP_INPUT;
	   l_data=(uOPNS<<OPNS)|(OPNS_MASK_BIT<<OPNS_MASK);
	   outw(l_reg,l_data);
	}else return E_DRVOP_ARGUMENT;
	return E_SUCCESS;
}

//OPAMP analoge output mode
void DrvOP_OPOoutEnable(void)
{
	unsigned int l_reg,l_data;
    #ifdef  HY16F188_H_
	l_reg=GPIO_PT3_PULLHIGH;
	l_data=(1<<(OPO_BIT+MASK));
	l_data+=(l_data<<16);
	outw(l_reg,l_data);
	l_reg=GPIO_PT3_INPUT;
	l_data=(1<<(OPO_BIT+MASK));
	outw(l_reg,l_data);
    #endif
	l_reg=OP_CTRL;
	l_data=(1<<OPOE)|(1<<OPOE_MASK);
	outw(l_reg,l_data);
}
//OPAMP analoge output mode
void DrvOP_OPOoutDisable(void)
{
	unsigned int l_reg,l_data;
	l_reg=OP_CTRL;
	l_data=(1<<OPOE_MASK);
	outw(l_reg,l_data);
}

unsigned int DrvOP_OuputFilter(unsigned int uFilter)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=OP_CTRL;
	if(uFilter==0)
		l_data=(1<<OPDFR_MASK);
	else if(uFilter==1)
		l_data=(1<<OPDFR_MASK)|(1<<OPDFR);
	else
		ReturnVal=E_DRVOP_ARGUMENT;
	outw(l_reg,l_data);
	return ReturnVal;
}
//OPAMP digital output mode
unsigned int DrvOP_OutputPinEnable(E_OUTPUT_PIN uPin)
{
	unsigned int l_reg,l_data;
	if (uPin<OPPTS_MAX+1)
	{
		l_reg=GPIO_OP_CTRL;
		l_data=(1<<OPPTE)|(1<<OPPTE_MASK)|(uPin<<OPPTS)|(1<<OPPTS_MASK);
		outw(l_reg,l_data);
	}else return E_DRVOP_ARGUMENT;
	l_reg=OP_CTRL;
	l_data=(1<<OPDEN)|(1<<OPDEN_MASK);
	outw(l_reg,l_data);
	return E_SUCCESS;
}
//OPAMP digital output mode
void DrvOP_OutputPinDisable (void)
{
	unsigned int l_reg,l_data;
	l_reg=GPIO_OP_CTRL;
	l_data=(1<<OPPTE_MASK);
	outw(l_reg,l_data);
	l_reg=OP_CTRL;
	l_data=1<<OPDEN_MASK;
	outw(l_reg,l_data);
}

unsigned int DrvOP_OutputInverse(unsigned int uInv)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=OP_CTRL;
	if(uInv==0)
		l_data=(1<<OP_INV_MASK);
	else if(uInv==1)
		l_data=(1<<OP_INV_MASK)|(1<<OP_Inv);
	else
		ReturnVal=E_DRVOP_ARGUMENT;
	outw(l_reg,l_data);
	return ReturnVal;
}

/*
unsigned int DrvOP_OutputWithCPCLK(unsigned int uCPCLK)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=OP_CTRL;
	if(uCPCLK==0)
		l_data=(1<<OPOS_MASK);
	else if(uCPCLK==1)
		l_data=(1<<OPOS_MASK)|(1<<OPOS);
	else
		ReturnVal=E_DRVOP_ARGUMENT;
	outw(l_reg,l_data);
	return ReturnVal;
}
*/

/*******************************************************************
*name    : DrvOP_OutputWithCHPCK
*function: ?离OPOS??
*input   : uCHPCK?OPOS??
*output  :
*Version : v0.1
*date    : 2015-6-8
*modify  :
*********************************************************************/
unsigned int DrvOP_OutputWithCHPCK(unsigned int uCHPCK)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=OP_CTRL;
	if(uCHPCK==0)
		l_data=(1<<OPOS_MASK);
	else if(uCHPCK==1)
		l_data=(1<<OPOS_MASK)|(1<<OPOS);
	else
		ReturnVal=E_DRVOP_ARGUMENT;
	outw(l_reg,l_data);
	return ReturnVal;
}

void DrvOP_EnableInt(void)
{
	unsigned int l_reg,l_data;
	l_reg=OP_INTERRUPT_CTRL;
	l_data=(1<<OPIE)|(1<<OPIE_MASK);
	outw(l_reg,l_data);
}

void DrvOP_DisableInt(void)
{
	unsigned int l_reg,l_data;
	l_reg=OP_INTERRUPT_CTRL;
	l_data=(1<<OPIE_MASK);
	outw(l_reg,l_data);
}

unsigned int DrvOP_ReadIntFlag(void)
{
	unsigned int l_reg,ReturnVal;
	ReturnVal=0;
	l_reg=OP_INTERRUPT_CTRL;
	//Robert add 2016/8/5
	//ReturnVal=((inw(l_reg)&OPIF)>>(OPIF-1));
	ReturnVal=((inw(l_reg)&0x01)>>(0));  //Read 0x4000C[0]
	return ReturnVal;
}

void DrvOP_ClearIntFlag(void)
{
	unsigned int l_reg,l_data;
	l_reg=OP_INTERRUPT_CTRL;
	l_data=(1<<OPIF_MASK);
	outw(l_reg,l_data);
}

unsigned int DrvOP_Feedback(unsigned int uFeedback)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=OP_CTRL;
	if(uFeedback==0)
	    l_data=(1<<OPCS_MASK);
	else if(uFeedback==1)
		l_data=(1<<OPCS)|(1<<OPCS_MASK);
	else
	    ReturnVal=E_DRVOP_ARGUMENT;
	outw(l_reg,l_data);
	return ReturnVal;
}

unsigned char DrvOP_OPDEN(unsigned char uOPDEN)
{
	unsigned int l_reg,l_data;
	l_reg=0x41900;
	if (uOPDEN<(0x01+1))
	{
	    l_data=inw(l_reg)&0x00000400;
		l_data|=(uOPDEN<<2)|(1<<(2+8));  //set 0x41900[2]=xb
		outw(l_reg,l_data);
		return E_SUCCESS;
	}
	else return E_FAIL ;
}

