/*
 *  FILE NAME : DrvLCD.h
 *
 *  Created on: 2016/08/15
 *  Author: Robert.Wang
 *  Version : V0.0, 2016/08/15
 *  
 */


#ifndef DRVLCD_H_
#define DRVLCD_H_
#include "HY16F3981.h"


#ifndef E_FAIL
#define E_FAIL		1
#endif
#define E_DRVLCD_ARGUMENT  E_FAIL
#define E_DRVLCD_ARGUMENT1 0xf0

#ifndef E_SUCCESS
#define E_SUCCESS		0
#endif

#ifdef LCD_BASE
#define LCD_CTRL0  (LCD_BASE+OFFSET00)
#define LCD_CTRL1  (LCD_BASE+OFFSET04)
#define LCD_CTRL2  (LCD_BASE+OFFSET08)
#endif

#ifdef CLOCK_BASE
#define LCD_CLOCK_CTRL  (CLOCK_BASE+OFFSET10)
#endif

#ifdef GPIO_BASE
#define GPIO_LCD0     0X40894
#define GPIO_LCD1     0X40850
#define GPIO_LCD2     (GPIO_LCD1+OFFSET04)
#define GPIO_LCD3     (GPIO_LCD2+OFFSET04)
#define GPIO_LCD4     (GPIO_LCD3+OFFSET04)
#define GPIO_LCD5     (GPIO_LCD4+OFFSET04)
#define GPIO_LCD6     (GPIO_LCD5+OFFSET04)
#define GPIO_LCD7     (GPIO_LCD6+OFFSET04)
#define GPIO_LCD8     (GPIO_LCD7+OFFSET04)
#define GPIO_LCD9     (GPIO_LCD8+OFFSET04)
#define GPIO_LCD10     (GPIO_LCD9+OFFSET04)
#define GPIO_LCD11     (GPIO_LCD10+OFFSET04)
#define GPIO_LCD12     (GPIO_LCD11+OFFSET04)
#define GPIO_LCD13     (GPIO_LCD12+OFFSET04)
#define GPIO_LCD14     (GPIO_LCD13+OFFSET04)
#define GPIO_LCD15     (GPIO_LCD14+OFFSET04)
#define GPIO_LCD16     (GPIO_LCD15+OFFSET04)
#define GPIO_LCD17     (GPIO_LCD16+OFFSET04)

#define VLCD_TRIM      0X042724  //VLCD TRIM CODE DATA      
#endif

typedef enum
{
	E_VLCD_DISABLE = 0,
	E_VLCD_RTYPE  = 1,
	E_VLCD33  = 2,
	E_VLCD30  = 3,
	E_VLCD27  = 4,
	E_VLCD24  = 5
} E_VLCD_MODE;
typedef enum
{
	E_LCD_DUTY3 = 0,
	E_LCD_DUTY4 = 1,
	E_LCD_DUTY5 = 2,
	E_LCD_DUTY6 = 3
} E_LCD_DUTY;
typedef enum
{
	E_LCD_NORMAL  = 0,
	E_LCD_PIXELON = 1,
	E_LCD_PIXELOFF =2
} E_LCD_DISPLAY_MODE;
typedef enum
{
	E_LCD0=0,
	E_LCD1=1,
	E_LCD2=2,
	E_LCD3=3,
	E_LCD4=4,
	E_LCD5=5,
	E_LCD6=6,
	E_LCD7=7,
	E_LCD8=8,
	E_LCD9=9,
	E_LCD10=10,
	E_LCD11=11,
	E_LCD12=12,
	E_LCD13=13,
	E_LCD14=14,
	E_LCD15=15,
	E_LCD16=16,
	E_LCD17=17,
	E_LCD18=18
}E_LCD_BUFFER;
//0X41B00
#define IDF     			20
#define DSP     			16
#define FLIP     			6
#define DUTY     			4
#define BEN     			3
#define VLCD    			0

#define IDF_MASK			(IDF+MASK)
#define DSP_MASK 			(DSP+MASK)
#define FLIP_MASK			(FLIP+MASK)
#define DUTY_MASK 		(DUTY+MASK)
#define BEN_MASK			(BEN+MASK)
#define VLCD_MASK			(VLCD+MASK)
#define DUTY_MAX		     (0x3)
#define VLCD_MAX             (0X7)
#define DSP_MAX               0X3

//0x41B04
#define PT9LEN   			24
#define PT8LEN     		    16
#define PT7LEN 			    8
#define PT6LEN              0

//0x41B08 
#define COMLEN 			    2
#define PT10LEN             0

//0x40310
#define LCDE      1
#define LCDO      4
#define LCKS      0
#define LCDO_MASK  (LCDO+MASK)
#define LCDE_MASK  (LCDE+MASK)
#define LCKS_MASK  (LCKS+MASK)
#define LCDO_MAX    0X7
#define LCDE_MAX    0X7
#define LCD_BUFFER  17

unsigned char DrvLCD_EnableCLK(unsigned int uLCD1,unsigned int uLCD2,unsigned int usource);
unsigned char DrvLCD_DisplayMode(unsigned int uDISMODE);
unsigned char DrvLCD_VLCDMode(unsigned int uVLCDMODE);
unsigned char DrvLCD_LcdDuty(unsigned int uDUTY);
unsigned char DrvLCD_LCDBuffer(unsigned int uBEN);
unsigned char DrvLCD_SwpCOMSEG(unsigned int uflip);
unsigned char DrvLCD_IOMode(unsigned int uport,unsigned int uIOMODE);
unsigned char DrvLCD_WriteData(unsigned int uSEG,unsigned int data);
unsigned char DrvLCD_VLCDTrim(short Umode);
#endif /* DRVLCD_H_ */
