/*
 *  Created on: 2016/7/28
 *  Author: Robert.Wang
 *  Memo : HY16F3981 DrvLCD.c is base on HY16F198B to modify
 *  Created on: 2018/03/02
 *  Version : V0.2 
*/

#include "DrvLCD.h"
#include "SpecialMacro.h"
/**********************************************************************************
*NAME  : DrvLCD_EnableCLK()
*FUNCT : SETTING LCD1 AND LCD2 CLOCK
*INPUT :
*OUTPUT: 0 SUCCESS; 1 FAIL
*VER   : V1.0
*DATE  : 2014-6-4
*MODIFY:
*********************************************************************************/
unsigned char DrvLCD_EnableCLK(unsigned int uLCD1,unsigned int uLCD2,unsigned int usource)
{
	unsigned int l_reg,l_data;
	if((uLCD1>LCDO_MAX)||(uLCD2>LCDE_MAX)||(usource>1))
		return E_FAIL;
	l_data=(uLCD1<<LCDO)|(0X7<<LCDO_MASK)|(uLCD2<<LCDE)|(0X7<<LCDE_MASK)|(usource<<LCKS)|(0X1<<LCKS_MASK);
	l_reg=LCD_CLOCK_CTRL;
	outw(l_reg,l_data);
	return E_SUCCESS;
}

/**********************************************************************************
*NAME  : DrvLCD_DisplayMode()
*FUNCT : SETTING LCD DISPLAY MODE
*INPUT : UDISMODE
*        0 NORMAL ; 1 ALL PIXELS ON; 2 ALL PIXELS OFF; 3 NORMAL MODE
*
*OUTPUT: 0 SUCCESS; 1 FAIL
*VER   : V1.0
*DATE  : 2014-6-4
*MODIFY:
*********************************************************************************/
unsigned char DrvLCD_DisplayMode(unsigned int uDISMODE)
{
	unsigned int l_reg,l_data;
	if(uDISMODE>DSP_MAX)
		return E_FAIL;
	l_data=(uDISMODE<<DSP)|(DSP_MAX<<DSP_MASK);
	l_reg=LCD_CTRL0;
	outw(l_reg,l_data);
	return E_SUCCESS;
}

/**********************************************************************************
*NAME  : DrvLCD_LcdDuty()
*FUNCT : SETTING LCD DUTY MODE
*INPUT : UDUTY
*        0 1/3 DUTY ; 1 1/4 DUTY; 2  1/5 DUTY; 3  1/6 DUTY;
*
*OUTPUT: 0 SUCCESS; 1 FAIL
*VER   : V1.0
*DATE  : 2014-6-4
*MODIFY:
*********************************************************************************/
unsigned char DrvLCD_LcdDuty(unsigned int uDUTY)
{
	unsigned int l_reg,l_data;
	if (uDUTY>DUTY_MAX)
		return E_FAIL;
	l_data=(uDUTY<<DUTY)|(DUTY_MAX<<DUTY_MASK);
	l_reg=LCD_CTRL0;
	outw(l_reg,l_data);
	return E_SUCCESS;
}

/**********************************************************************************
*NAME  : DrvLCD_LCDBuffer()
*FUNCT : SETTING LCD OUTPUT BUFFER BEING ON OR OFF
*INPUT : UBEN
*        0 DISABLE ; 1 ENABLE;
*
*OUTPUT: 0 SUCCESS; 1 FAIL;
*VER   : V1.0
*DATE  : 2014-6-4
*MODIFY:
*********************************************************************************/
unsigned char DrvLCD_LCDBuffer(unsigned int uBEN)
{
	unsigned int l_reg,l_data;
	if(uBEN>1)
		return E_FAIL;
	l_data=(uBEN<<BEN)|(1<<BEN_MASK);
	l_reg=LCD_CTRL0;
	outw(l_reg,l_data);
	return E_SUCCESS;
}

/**********************************************************************************
*NAME  : DrvLCD_SwpCOMSEG()
*FUNCT : FLIP COM AND SEG ORDER
*INPUT : UFLIP
*        0 NORMAL ; 1 FLIP;
*OUTPUT: 0 SUCCESS; 1 FAIL;
*VER   : V1.0
*DATE  : 2016-7-22
*MODIFY:
*********************************************************************************/
unsigned char DrvLCD_SwpCOMSEG(unsigned int uflip)
{
	unsigned int l_reg,l_data;
	if(uflip>0x4)
		return E_FAIL;
	l_data=(uflip<<FLIP)|(0x7<<FLIP_MASK); //set 0X41B00[7:6]
	l_reg=LCD_CTRL0;
	outw(l_reg,l_data);
	return E_SUCCESS;
}


/**********************************************************************************
* NAME  : DrvLCD_IOMode()
* FUNCT : SETTING THE IO port as the LCD MODE OR GPIO MODE;
* INPUT : uport
*        0 PT6LEN ; 1 PT7LEN; 2  PT8LEN; 3 PT9LEN; 4 PT10LEN; 5 COM5/COM4;
*        uIOMODE :0~0XFF,bit operation
* OUTPUT: 0 SUCCESS; 1 FAIL;
* VER   : V1.0
* DATE  : 2015-6-9
* MODIFY:PT6~PT9?迡?呾楊??
* Created on: 2018/03/02
* Version : V0.2 
* MODIFY : 0 PT6LEN ; 1 PT7LEN; 2  PT8LEN; 3 PT9LEN; 4 PT13LEN; 
* uIOMODE :0~0XFF,bit operation
*********************************************************************************/
unsigned char DrvLCD_IOMode(unsigned int uport,unsigned int uIOMODE)
{
	unsigned int l_reg,l_data;
	if(uport>=5)
		return E_FAIL;
	else if(uport<4)
		{
			l_data=inw(LCD_CTRL1)&(0XFFFFFFFF^(0xff<<(uport*8)));
			l_data=((uIOMODE<<(uport*8))|l_data);
			l_reg=LCD_CTRL1;
		}
	else if(uport==4)
		{
			l_data=(uIOMODE<<(24)); //I_data=[31:24]
			l_reg=LCD_CTRL2;
		}
	outw(l_reg,l_data);
	return E_SUCCESS;
}

/**********************************************************************************
*NAME  : DrvLCD_WriteData()
*FUNCT : write data to SEG
*INPUT : uSEG  LCD seg LCD0~LCD17
*        PT6:
*             PT6.0~1 LCD1
*             PT6.2~3 LCD2
*             PT6.4~5 LCD3
*             PT6.6~7 LCD4
*        PT7:
*             PT7.0~1 LCD5
*             PT7.2~3 LCD6
*             PT7.4~5 LCD7
*             PT7.6~7 LCD8
*        PT8:
*             PT8.0~1 LCD9
*             PT8.2~3 LCD10
*             PT8.4~5 LCD11
*             PT8.6~7 LCD12
*        PT9:

*             PT9.0~1 LCD13
*             PT9.2~3 LCD14
*             PT9.4~5 LCD15
*             PT9.6~7 LCD16
*        PT10:
*             PT10.0~1 LCD17
*        data : the data write to seg
*OUTPUT: 0 SUCCESS; 1 FAIL;
*VER   : V1.0
*DATE  : 2016-7-22
*MODIFY: No?
*********************************************************************************/
unsigned char DrvLCD_WriteData(unsigned int uSEG,unsigned int data)
{
	unsigned int l_reg,l_data,l_temp,l_duty;

	//if(uSEG>LCD_BUFFER)
	if(uSEG>15)
		return E_FAIL;
	l_temp=(((inw(LCD_CTRL0)>>DUTY)&0X03)+3);
	l_duty=0x3f>>(6-l_temp);
	//Robert add 2016/7/22
	//if(uSEG==17) //PT10
	//{
		//l_data=inw(LCD_CTRL2)&0X03;
		//return E_FAIL;
	//}

	if(uSEG>0)  //about PT6~PT9
	{
		l_data=(inw(LCD_CTRL1)>>((uSEG-1)*2))&0X3;
	}
	else if(uSEG==0)
	{
		l_data=0x3;
	}
    if(l_data==0x3)
    {
    	l_data=0xff00ff00;
    }
    else if(l_data==0x2)
    {
    	l_data=0xff000000;
    }
    else if(l_data==0x01)
    {
    	l_data=0x0000ff00;
    }
    else if(l_data==0)
    	l_data=0x0;
	l_data=((data&l_duty)<<16)|((data>>l_temp)&l_duty)|l_data;
	if(uSEG==0)
		//Robert add 2016/7/22
		l_reg=0x408C8;
	else
		l_reg=GPIO_LCD1+(uSEG-1)*0x04;
	outw(l_reg,l_data);
	return E_SUCCESS;
}

/**************************************************************
name    : unsigned char DrvLCD_VLCDTrim(short Umode)
function: 籵徹?离??誧褫??寁祥??VLCD?揤???
input:   umode:    1: VLCD~3.43V
                   2: VLCD~3.16V
                   3: VLCD~2.93V
                   4: VLCD~2.73V
                   5: VLCD~2.55V
output :  0 SUCCESS/1 FAIL
note   ??  ???紱釬源???

date   :   2016/7/22
modify :
//HY16F3981 No trim state
Mode5 VLCD Trim code
0x41b10[3:0]=0xD0184[3:0]
0x41b00[2:0]=0xD0184[2:0]
Mode4 VLCD Trim code
0x41b10[3:0]=0xD0185[3:0]
0x41b00[2:0]=0xD0185[2:0]
Mode3 VLCD Trim code
0x41b10[3:0]=0xD0186[3:0]
0x41b00[2:0]=0xD0186[2:0]
Mode2 VLCD Trim code
0x41b10[3:0]=0xD0187[3:0]
0x41b00[2:0]=0xD0187[2:0]
Mode1 VLCD Trim code
0x41b10[3:0]=0xD0188[3:0]
0x41b00[2:0]=0xD0188[2:0]
**************************************************************/
unsigned char DrvLCD_VLCDTrim(short Umode)
{
	unsigned int l_reg,l_enable,l_data;

	if((Umode==0)||(Umode>5))
		return E_FAIL;
  switch(Umode)
  {
	case 5 :
			l_data=inw(0xd0184)&0x000000ff; //read 0xd0184
      break;

	case 4 :
			l_data=(inw(0xd0184)&0x0000ff00)>>8; //read 0xd0185
		break;

	case 3 :
			l_data=(inw(0xd0184)&0x00ff0000)>>16; //read 0xd0186
		break;

	case 2 :
			l_data=(inw(0xd0184)&0xff000000)>>24;  //read 0xd0187
		break;

	case 1 :
			l_data=inw(0xd0188)&0x000000ff;  //read 0xd0188
	  break;
	default :
		break;
	}
	l_enable=0x0f00+((l_data>>3)&0xf);
	outw(0x41b10,l_enable); //write data to 0x41b10[3:0]

	l_data=l_data&0x07;
	l_data=(l_data<<VLCD)|(VLCD_MAX<<VLCD_MASK);
	l_reg=LCD_CTRL0;
	outw(l_reg,l_data); //write data to 0x41b00[2:0]


	return E_SUCCESS;
}


/**********************************************************************************
*NAME  : DrvLCD_VLCDMode()
*FUNCT : SETTING VLCD MODE
*INPUT : UVLCDMODE
*        0 : DISABLE ; 1 : R_TYPE ; 2 : 3.3V; 3 : 3.0V; 4 : 2.7V; 5 : 2.4V; 6/7 : DISABLE;
*
*OUTPUT: 0 SUCCESS; 1 FAIL
*VER   : V1.0
*DATE  : 2014-6-4
*MODIFY:
*DATE  : 2017-12-11
*MODIFY: V0.2
2: VLCD~3.43V
3: VLCD~3.16V
4: VLCD~2.73V
5: VLCD~2.55V
*********************************************************************************/
unsigned char DrvLCD_VLCDMode(unsigned int uVLCDMODE)
{
	unsigned int l_reg,l_data,l_enable;
	if(uVLCDMODE>VLCD_MAX)
		return E_FAIL;

  l_reg=LCD_CTRL0;

  switch(uVLCDMODE)
  {
  	case 7 :
			outw(l_reg,0x0F07);  //LCD buffer control=off
    break;

	  case 6 :
			outw(l_reg,0x0F06);  //LCD buffer control=off
    break;

	  case 5 :   //VLCD=2.4V
		  l_data=inw(0xd0184)&0x000000ff; //read 0xd0184
		  l_enable=0x0f00+((l_data>>3)&0xf);
	    outw(0x41b10,l_enable); //write data to 0x41b10[3:0]
		  l_data=l_data|0x08;  //LCD buffer control=on
		  l_data=(l_data<<VLCD)|(0x0F<<VLCD_MASK);  //V0.0
			outw(l_reg,l_data);
    break;

	  case 4 :   //VLCD=2.7V
		  l_data=(inw(0xd0184)&0x0000ff00)>>8; //read 0xd0185
		  l_enable=0x0f00+((l_data>>3)&0xf);
	    outw(0x41b10,l_enable); //write data to 0x41b10[3:0] 
		  l_data=l_data|0x08;  //LCD buffer control=on
		  l_data=(l_data<<VLCD)|(0x0F<<VLCD_MASK);  //V0.0		 
			outw(l_reg,l_data);
    break;

	  case 3 :   //VLCD=3.0V
		  l_data=(inw(0xd0184)&0xff000000)>>24;  //read 0xd0187
		  l_enable=0x0f00+((l_data>>3)&0xf);
	    outw(0x41b10,l_enable); //write data to 0x41b10[3:0] 
		  l_data=l_data|0x08;  //LCD buffer control=on
		  l_data=(l_data<<VLCD)|(0x0F<<VLCD_MASK);  //V0.0
			outw(l_reg,l_data);
	  break;

	  case 2 :   //VLCD=3.3V
		  l_data=inw(0xd0188)&0x000000ff;  //read 0xd0188
	    l_enable=0x0f00+((l_data>>3)&0xf);
	    outw(0x41b10,l_enable); //write data to 0x41b10[3:0] 
		  l_data=l_data|0x08;  //LCD buffer control=on
		  l_data=(l_data<<VLCD)|(0x0F<<VLCD_MASK);  //V0.0
			outw(l_reg,l_data);
	  break;

	  case 1 :
			outw(l_reg,0x0F09);  //LCD buffer control=on
    break;

    case 0 :
			outw(l_reg,0x0F00);  //LCD buffer control=off
    break;

	  default :
		
	  break;
	}

	return E_SUCCESS;
}