/*
 * DrvIA.h
 *
 *  Created on: 2016/08/15
 *  Author: Robert.Wang
 *  Version : V0.0, 2016/08/15
 *  
 */

#include "HY16F3981.h"

#ifndef E_FAIL
#define E_FAIL		1
#endif
#define E_DRVADC_ARGUMENT E_FAIL

#ifndef E_SUCCESS
#define E_SUCCESS		0
#endif


typedef enum
{
	IA_Input_AIO0 = 0,  //0
	IA_Input_AIO1,  //1
	IA_Input_REFO,  //2
	IA_Input_HighZ, //3
} E_IA_INPUT_CHANNEL;

typedef enum
{
	IA_DISABLE = 0,
	IA_ENABLE,
} E_IA_ENIA;

typedef enum
{
	IA_IAGain_4 = 0,
	IA_IAGain_8 = 1,
	IA_IAGain_16 = 2,
	IA_IAGain_32 = 3
} E_IA_IAGain;

typedef enum
{
	IA_OPEN = 0,
	IA_SHORT,
} E_IA_IAIS;


typedef enum
{
	IA_IACHM_NoChopper = 0,
	IA_IACHM_IndividualInputstage = 1,
	IA_IACHM_Inputstage = 2,
	IA_IACHM_Both = 3
} E_IA_IACHM;


unsigned int DrvIA_SetIAInputChannel(unsigned int uINP,unsigned int uINN);
unsigned int DrvIA_PInputChannel(unsigned int uINP);
unsigned int DrvIA_NInputChannel(unsigned int uINN);
unsigned int DrvIA_IAGain(unsigned int uIAGain);
unsigned int DrvIA_IACHM(unsigned int uIACHM);
unsigned int DrvIA_IAIS(unsigned int uIAIS);
unsigned int DrvIA_ENIA(unsigned int uENIA);


