/*
 *  Created on: 2016/7/28
 *  Author: Robert.Wang
 *  Memo : no
 *  Modify on: 2018/03/09
 *  Version : V0.2 
*/

#include "DrvIA.h"
#include "SpecialMacro.h"

unsigned int DrvIA_SetIAInputChannel(unsigned int uINP,unsigned int uINN)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=0x41600;
	if((uINP<(0x3+1))&&(uINN<(0x3+1)))
	{
		l_data=inw(l_reg)&0xf0f0ffff;
		//l_data|=((uINP<<16)|(uINN<<24));  //HY16F3981(1B)
    l_data|=((uINP<<24)|(uINN<<16));  //HY16F3981(1C)
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVADC_ARGUMENT;
	return ReturnVal;
}

unsigned int DrvIA_PInputChannel(unsigned int uINP)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=0x41600;
	if(uINP<(0x3+1))
	{
		l_data=inw(l_reg)&0xfff0ffff;
		//l_data|=(uINP<<16);  //HY16F3981(1B)
    l_data|=(uINP<<24);  //HY16F3981(1C)
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVADC_ARGUMENT;
	return ReturnVal;
}

unsigned int DrvIA_NInputChannel(unsigned int uINN)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=0x41600;
	if(uINN<(0x3+1))
	{
		l_data=inw(l_reg)&0xf0ffffff;
		//l_data|=(uINN<<24);  //HY16F3981(1B)
		l_data|=(uINN<<16);  //HY16F3981(1C)
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVADC_ARGUMENT;
	return ReturnVal;
}

unsigned int DrvIA_IAGain(unsigned int uIAGain)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=0x41600;
	if(uIAGain<(0x3+1))
	{
		l_data=inw(l_reg)&0xfffff0ff;
		l_data|=(uIAGain<<8);
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVADC_ARGUMENT;
	return ReturnVal;
}

unsigned int DrvIA_IACHM(unsigned int uIACHM)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=0x41600;
	if(uIACHM<(0x3+1))
	{
		l_data=inw(l_reg)&0xffffff0f;
		l_data|=(uIACHM<<4);
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVADC_ARGUMENT;
	return ReturnVal;
}


unsigned int DrvIA_IAIS(unsigned int uIAIS)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=0x41600;
	if(uIAIS<(0x1+1))
	{
		l_data=inw(l_reg)&0xfffffff0;
		l_data|=(uIAIS<<0x1);
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVADC_ARGUMENT;
	return ReturnVal;
}

unsigned int DrvIA_ENIA(unsigned int uENIA)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=0x41600;
	if(uENIA<(0x1+1))
	{
		l_data=inw(l_reg)&0xfffffff0;
		l_data|=(uENIA<<0x0);
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVADC_ARGUMENT;
	return ReturnVal;
}


