/*
 * DrvI2C.h
 *
 *  Created on: 2016/08/15
 *  Author: Robert.Wang
 *  Version : V0.0, 2016/08/15
 *  
 */

#ifndef DRVI2C_H_
#define DRVI2C_H_

#include "HY16F3981.h"
#include "DrvREG32.h"
#ifndef E_SUCCESS
#define E_SUCCESS		0
#endif

#ifndef E_FAIL
#define E_FAIL		1
#endif

#define E_DRVI2C_ARGUMENT E_FAIL
#define R_I2C_IO (GPIO_BASE+OFFSET44)
#define R_I2C_ACT (I2C_BASE+OFFSET04)

#define I2C_STA              0x8
#define I2C_STO              0x4
#define I2C_SI               0x2
#define I2C_AA               0x1
#define I2C_WRITE            0x00           // I2C WRITE command
#define I2C_READ             0x01           // I2C READ command

typedef enum
{
	E_DRVI2C_SLAVE_7BIT = 0,
	E_DRVI2C_SLAVE_10BIT = 1
} E_DRVI2C_SLAVE_BIT;

typedef enum
{
	E_DRVI2C_INT = 1,
	E_DRVI2C_ERROR_INT,
	E_DRVI2C_INT_ALL
}E_DRVI2C_INTERRUPT;

typedef enum
{
	E_DRVI2C_ARBITRATION_FLAG=0,
	E_DRVI2C_GENERAL_CALL_FLAG,
	E_DRVI2C_ACKNOWLEDGE_FLAG,
	E_DRVI2C_DATA_FIELD_FLAG,
	E_DRVI2C_RW_STATE_FLAG,
	E_DRVI2C_RS_FLAG,
	E_DRVI2C_SLAVE_ACTIVE_FLAG,
	E_DRVI2C_MASTER_ACTIVE_FLAG
}E_DRVI2C_Status;

typedef enum
{
	E_DRVI2C_I2CLK_DIV_1=0,
	E_DRVI2C_I2CLK_DIV_2,
	E_DRVI2C_I2CLK_DIV_4,
	E_DRVI2C_I2CLK_DIV_8,
	E_DRVI2C_I2CLK_DIV_16,
	E_DRVI2C_I2CLK_DIV_32,
	E_DRVI2C_I2CLK_DIV_64,
	E_DRVI2C_I2CLK_DIV_128
}E_DRVI2C_TIMEOUT_PRESCALE;

typedef enum
{
	E_DRVI2C_CLKPSX1=0,
	E_DRVI2C_CLKPSX2,
	E_DRVI2C_CLKPSX3,
	E_DRVI2C_CLKPSX4,
	E_DRVI2C_CLKPSX5,
	E_DRVI2C_CLKPSX6,
	E_DRVI2C_CLKPSX7,
	E_DRVI2C_CLKPSX8,
	E_DRVI2C_CLKPSX9,
	E_DRVI2C_CLKPSX10,
	E_DRVI2C_CLKPSX11,
	E_DRVI2C_CLKPSX12,
	E_DRVI2C_CLKPSX13,
	E_DRVI2C_CLKPSX14,
	E_DRVI2C_CLKPSX15,
	E_DRVI2C_CLKPSX16
}E_DRVI2C_TIMEOUT_LIMIT;


uint32_t DrvI2C_Open(uint32_t u32CRG);
void DrvI2C_Close(void);
uint32_t DrvI2C_SlaveSet(
   uint32_t uSlaveAddr,
   E_DRVI2C_SLAVE_BIT uAddrBit,
   uint8_t uSlave3Byte,
   uint8_t GC_Flag);
unsigned char DrvI2C_SetIOPin(unsigned int upin);
void DrvI2C_WriteData(uint8_t uData);
//void DrvI2C_WriteOneData(uint8_t uData);
void DrvI2C_Write3ByteData(uint8_t uData1,uint8_t uData2,uint8_t uData3);
//uint8_t DrvI2C_ReadOneData(uint8_t uack);
uint8_t DrvI2C_ReadData(void);
void DrvI2C_Ctrl(uint8_t start, uint8_t stop, uint8_t intFlag, uint8_t ack);
void DrvI2C_EnableInt(E_DRVI2C_INTERRUPT uINT);
void DrvI2C_DisableInt(E_DRVI2C_INTERRUPT uINT);
E_DRVI2C_INTERRUPT DrvI2C_ReadIntFlag(void);
void DrvI2C_ClearIntFlag(E_DRVI2C_INTERRUPT uINT);
void DrvI2C_ClearEIRQ(void);
void DrvI2C_ClearIRQ(void);
uint8_t DrvI2C_GetStatusFlag(void);
uint8_t DrvI2C_TimeOutEnable(
E_DRVI2C_TIMEOUT_PRESCALE uPreScale,
E_DRVI2C_TIMEOUT_LIMIT uTimeOutLimit
);
void DrvI2C_TimeOutDisable(void);
void DrvI2C_STSP(unsigned char usignal);
unsigned char DrvI2C_MGetACK(unsigned int utime);
void DrvI2C_DisableIOPin(void);
//2021/09/10 Robert add
void DrvI2C_DisableSEn(void);
void DrvI2C_EnableSEn(void);
void DrvI2C_DisableI2CEn(void);
void DrvI2C_EnableI2CEn(void);

#endif /* DRVI2C_H_ */
