/*
 *  Created on: 2016/7/28
 *  Author: Robert.Wang
 *  Memo : HY16F3981 DrvI2C.c is base on HY16F198B to modify
*/

#include "DrvI2C.h"
#include "SpecialMacro.h"
/**********************************************************************
 * Name     : DrvI2C_Open(uint32_t u32CRG)
 * function : enable the I2C and configure the I2C Bus clock CRG.
 * input    : u32CRG
 * output   : 0/1
 * version  : v1.1
 * date     : 13-12-4
 * modify   : change the operation of setting .
 *********************************************************************/
uint32_t DrvI2C_Open(uint32_t u32CRG)
{
	//i2c_00=0x0101;
	outpw(&I2C->CFG, (uint32_t)(0x1|0x1<<8));  //0x41000[0]=1b
	
	if(u32CRG > 0xff) return u32CRG;
	i2c_08=0xff000000+(u32CRG<<16);
	return E_SUCCESS;
}

void DrvI2C_Close(void)
{
	outpw(&I2C->CFG, (uint32_t)(0x1<<8));  //0x41000[0]=0b
}

/**********************************************************************
 * Name     : uint32_t DrvI2C_SlaveSet(??
 * function : enable slave mode and setting GC MODE and configure the data mode
 * 			  and set device address
 * input    : uslaveaddr uaddrbit uslave3byte gc_flag
 * output   : NO
 * version  : v1.1
 * date     : 13-12-12
 * modify   : change the operation of setting device address .
 *********************************************************************/
uint32_t DrvI2C_SlaveSet(
   uint32_t uSlaveAddr,
   E_DRVI2C_SLAVE_BIT uAddrBit,
   uint8_t uSlave3Byte,
   uint8_t GC_Flag)
{
	uint32_t RTC_temp;
	outpw(&I2C->CFG, (uint32_t)(0x1|0x1<<8));  //0x41000[0]=1b
	outpw(&I2C->ACT, (uint32_t)(0x80|(0x80<<8)));

	if(uAddrBit==E_DRVI2C_SLAVE_7BIT){
		if(uSlaveAddr>0x7f)return uSlaveAddr;
		RTC_temp=inpw(&I2C->SID)&0xffffff00;
		outpw(&I2C->SID, (uint32_t)(RTC_temp|0x1|uSlaveAddr));
		outpw(&I2C->ACT, (uint32_t)((0x40<<8)));
	}else if(uAddrBit==E_DRVI2C_SLAVE_10BIT){
		if(uSlaveAddr>0x3ff)return uSlaveAddr;
		RTC_temp=inpw(&I2C->SID)&0xffff0000;
		outpw(&I2C->SID, (uint32_t)(RTC_temp|0x100|((uSlaveAddr&0x300)<<1)|((uSlaveAddr&0xff)|0x1)));
		outpw(&I2C->ACT, (uint32_t)(0x40|(0x40<<8)));
	}else
		return uAddrBit;

	if((uSlave3Byte>1)||(GC_Flag>1)) return 0xff;
	if(uSlave3Byte)
		outpw(&I2C->ACT, (uint32_t)(0x20|(0x20<<8)));
	else
		outpw(&I2C->ACT, (uint32_t)((0x20<<8)));

	if(GC_Flag)
			outpw(&I2C->CFG, (uint32_t)(0x4|(0x4<<8)));
		else
			outpw(&I2C->CFG, (uint32_t)((0x4<<8)));
   return E_SUCCESS;
}

/**********************************************************************
 * Name     : DrvI2C_SetIOPin()
 * function : enable and setting the IO port for I2C
 * input    : upin choose the io port
 *            0  Rsv
 *            1  Rsv
 *            2  Rsv
 *            3  Rsv
 *            4  SCL=PT2.0;SDA=PT2.1
 *            5  SCL=PT2.2;SDA=PT2.3
 *            6  SCL=PT2.4;SDA=PT2.5
 *            7  SCL=PT2.6;SDA=PT2.7
 * output   : 0/1
 *            0 setting fail
 *            1 setting success
 * version  : v1.0
 * date     : 13-12-4
 * modify   : no
 *********************************************************************/
unsigned char DrvI2C_SetIOPin(unsigned int upin)
{
	signed int l_reg,l_data;
	l_reg=R_I2C_IO;
	if(upin<8)
	{
		l_data=0x10000+(upin<<17)+0x0f000000;
		outw(l_reg,l_data);
		return E_SUCCESS;
	}
	else
		return E_FAIL;
}



void DrvI2C_WriteData(uint8_t uData)
{
	outpw(&I2C->TAD, (uint32_t)(uData));
}

/**********************************************************************
 * Name     : DrvI2C_WriteOneData(uint8_t uData)
 * function : writ data to slaver
 * input    :  udata :0~0xff;
 * output   : no
 * version  : v1.1
 * date     : 13-12-4
 * modify   : add one operation "i2c_04=0xff01;"
 *********************************************************************/
/*
void DrvI2C_WriteOneData(uint8_t uData)
{
	volatile unsigned int n;
	outpw(&I2C->TAD, (uint32_t)(uData));
	i2c_04=0xff01;   //0x41004
	for(n=0;n<=0x10;n++);asm("NOP");
}
*/

void DrvI2C_Write3ByteData(uint8_t uData1,uint8_t uData2,uint8_t uData3)
{
	outpw(&I2C->TAD, (uint32_t)(uData1|(uData2<<8)|(uData3<<16)));
}


/**********************************************************************
 * Name     : DrvI2C_ReadOneData()
 * function : read data from slaver and sent ACK to slaver
 * input    : uack choose to answer ACK or not
 *            0 NO ACK
 *            1 ACK
 * output   : data from slaver
 * version  : v1.1
 * date     : 13-12-4
 * modify   : change operation on read data from slaver
 *            2014-8-18 ??滲???樓?i2c_04=0xff00;?
 *********************************************************************/
/*
uint8_t DrvI2C_ReadOneData(uint8_t uack)
{
	unsigned char RecData;
	unsigned int i;
	RecData = inpw(&I2C->RAD)&0xff;
	i2c_04=0xff00+uack;
    for(i=0;i<0xffff;i++)
    {
        if(i2c_04&0x00000002)
        {
        	i2c_04=0xff00;   //0x41004
        	return i2c_10&0xff;
        }
    }
    return E_FAIL;
}
*/

uint8_t DrvI2C_ReadData(void)
{
	return (inpw(&I2C->RAD)&0xff);
}


void DrvI2C_Ctrl(uint8_t start, uint8_t stop, uint8_t intFlag, uint8_t ack)
{
	uint32_t Reg = 0;

	if (start)
		Reg |= I2C_STA;
	if (stop)
	    Reg |= I2C_STO;
	if (intFlag)
		Reg |= I2C_SI;
	if (ack)
		Reg |= I2C_AA;
	outpw(&I2C->ACT, (uint32_t)(Reg|(0xf<<8)));
}

/**********************************************************************
 * Name     : void DrvI2C_EnableInt(E_DRVI2C_INTERRUPT uINT)
 * function : enable the I2C all interrupt
 * input    : uINT
 * 			 	0 enable the i2c interrupt
 * 			 	1 enable the i2c error interrupt
 * 			 	2 enable the i2c interrupt and error interrupt
 * output   : NO
 * version  : v1.1
 * date     : 13-12-10
 * modify   : change the operation of setting .
 *********************************************************************/
void DrvI2C_EnableInt(E_DRVI2C_INTERRUPT uINT)
{
	outpw(&INT_COM->COM, (uint32_t)((uINT+1)<<20)|((1+uINT)<<28));
}

/**********************************************************************
 * Name     : void DrvI2C_DisableInt(E_DRVI2C_INTERRUPT uINT)
 * function : disable the I2C all interrupt
 * input    : uINT
 * 			  0 disable the i2c interrupt
 * 			  1 disable the i2c error interrupt
 * 			  2 disable the i2c interrupt and error interrupt
 * output   : no
 * version  : v1.1
 * date     : 13-12-10
 * modify   : change the operation of setting .
 *********************************************************************/
void DrvI2C_DisableInt(E_DRVI2C_INTERRUPT uINT)
{
	outpw(&INT_COM->COM, (uint32_t)((uINT+1)<<28));
}

E_DRVI2C_INTERRUPT DrvI2C_ReadIntFlag(void)
{
	return (inpw(&INT_COM->COM)&0x30)>>4;
}

/**********************************************************************
 * Name     : void DrvI2C_ClearIntFlag(E_DRVI2C_INTERRUPT uINT)
 * function : clear the I2C interrupt flag
 * input    : uINT:
 *            0   clear interrupt flag;
 *            1   clear error interrupt flag
 *            2   clear interrupt and error interrupt flag
 * output   : NO
 * version  : v1.1
 * date     : 2013-12-10
 * modify   : change the operation of setting .
 *********************************************************************/
void DrvI2C_ClearIntFlag(E_DRVI2C_INTERRUPT uINT)
{
	i2c_04=0x0f01&i2c_04;
	outpw(&INT_COM->COM, (uint32_t)((1+uINT)<<12));
}

void DrvI2C_ClearEIRQ(void)
{
	outpw(&I2C->ACT, (uint32_t)(0x10<<8));
}

void DrvI2C_ClearIRQ(void)
{
	outpw(&I2C->ACT, (uint32_t)(0x2<<8));
}
/*******************************************************************
*name    : uint8_t DrvI2C_GetStatusFlag(void)
*function: 黍IIC袨?梓祩?
*input   : NO
*output  : 殿?婃??bit[23:16]??:0xff~0
*Version : v1.1
*date    : 2014-3-24
*modify  : ????殿??
*********************************************************************/
uint8_t DrvI2C_GetStatusFlag(void)
{
	return ((inpw(&I2C->ACT)&0xff0000)>>16);
}


uint8_t DrvI2C_TimeOutEnable(
E_DRVI2C_TIMEOUT_PRESCALE uPreScale,
E_DRVI2C_TIMEOUT_LIMIT uTimeOutLimit
)
{
	if((uPreScale>7)||(uTimeOutLimit>15)) return 0xff;
	outpw(&I2C->CTCR, (uint32_t)((uPreScale<<4)|(uPreScale<<12)|(uTimeOutLimit)|(uTimeOutLimit<<8)));
	outpw(&I2C->CFG, (uint32_t)(0x2|(0x2<<8)));
	return E_SUCCESS;
}


void DrvI2C_TimeOutDisable(void)
{
	outpw(&I2C->CFG, (uint32_t)(0x2<<8));
}


/**********************************************************************
 * Name     : void DrvI2C_STSP(unsigned char usignal)
 * function : I2C start/stop signal
 * input    : usignal : 0 IIC START signal
 *                      1 IIC STOP signal
 * output   : no
 * version  : v1.0
 * date     : 13-12-4
 * modify   : 2014-8-18  ??滲???樓?i2c_04=0xf300;＊???for??棒?
 *********************************************************************/
void DrvI2C_STSP(unsigned char usignal)
{
	uint32_t Reg = 0;

	if (usignal==0)
		Reg |= I2C_STA;
	if (usignal==1)
	    Reg |= I2C_STO;
	outpw(&I2C->ACT, (uint32_t)(Reg|(0xf<<8)));

	i2c_04=0xf300;   //0x41004
	volatile unsigned int n;
	for(n=0;n<=0x50;n++);//asm("NOP");

}

/*******************************************************************
*name    : DrvI2C_MGetACK()
*function: Slaver answer the ACK to Master,used for master transmit data to slaver
*input   : utime  for check time is 0~0xffff
*output  : 0 success
*          1 fail
*Version : v1.0
*date    : 2013-12-4
*modify  : 2014-8-18 氝?＆i2c_04=0xff00;?
*********************************************************************/
unsigned char DrvI2C_MGetACK(unsigned int utime)
{
    unsigned int i;
    unsigned char Returnvalue;
    Returnvalue=E_FAIL;
    for(i=0;i<utime;i++)
    {
        if(i2c_04&0x00000002)
        {
           Returnvalue=E_SUCCESS;
           i2c_04=0xff00;   //0x41004
           break;
        }
    }
    return Returnvalue;
}

/*******************************************************************
*name    : DrvI2C_DisableIOPin()
*function: 壽?IO??峈I2C籵?IO髡?
*input   : NONE
*output  : NONE
*Version : v1.0
*date    : 2014-1-17
*modify  : NONE
*********************************************************************/
void DrvI2C_DisableIOPin(void)
{
	pioc_2=0x01000000;
}


//2021/09/10 Robert add
void DrvI2C_DisableSEn(void)
{
  i2c_04=0x8000;   //0x41004[7]=0b	
}

void DrvI2C_EnableSEn(void)
{
  i2c_04=0x8080;   //0x41004[7]=1b	
}

void DrvI2C_DisableI2CEn(void)
{
  i2c_00=0x0100;  //0x41000[0]=0b	
}

void DrvI2C_EnableI2CEn(void)
{
	i2c_00=0x0101;  //0x41000[0]=1b	
}