/*
 * DrvGPIO.h
 *
 *  Created on: 2016/08/15
 *  Author: Robert.Wang
 *  Version : V0.0, 2016/08/15
 *  Version : V0.2, 2018/03/02
 */

#include "HY16F3981.h"

#ifndef GPIO_LIB_H_
#define GPIO_LIB_H_

#define PT1_BASE (GPIO_BASE+OFFSET00)
#define PT2_BASE (GPIO_BASE+OFFSET10)
#define PT3_BASE (GPIO_BASE+OFFSET20)
#define PT4_BASE (GPIO_BASE+OFFSET30)
#define OUTPUT_MODE_OFFICE OFFSET00
#define GOIP_CLOCK_BASE (CLOCK_BASE+OFFSET0C)

#ifdef  INTERRUPT_BASE
#define GPIO_INTERRUPT_CTRL  (INTERRUPT_BASE+OFFSET10)
#endif

#ifndef E_SUCCESS
#define E_SUCCESS		0
#endif

#ifndef E_FAIL
#define E_FAIL		1
#endif
#define E_DRVGPIO_ARGUMENT  E_FAIL
#define E_DRVGPIO_ARGUMENT2 0xf0
#define E_DRVGPIO_ARGUMENT3 0xff000000

#ifdef GPIO_BASE
#define GPIO_INPUT_SET      (GPIO_BASE+OFFSET04)
#define GPIO_OP_CTRL        (GPIO_BASE+OFFSET40)
#define GPIO_PT3_PULLHIGH   (GPIO_BASE+OFFSET20)
#define GPIO_PT3_OUTPUT     (GPIO_BASE+OFFSET20)
#define GPIO_PT3_INPUT      (GPIO_BASE+OFFSET24)

#define GPIO_PT6        0X40850
#define GPIO_PT7        0X40860
#define GPIO_PT8        0X40870
#define GPIO_PT9        0x40880
#define GPIO_PT13       0x408C0
#define LCDIO_OUT       3
#define LCDIO_OUT_MASK  (LCDIO_OUT+MASK)
#define LCDIO_IN        2
#define LCDIO_IN_MASK   (LCDIO_IN+MASK)
#define LCDIO_DO        1
#define LCDIO_DI        0
#define LCDIO_DO_MASK   (LCDIO_DO+MASK)
#define LCDIO_DI_MASK   (LCDIO_DI+MASK)
#endif

//# OPAMP Bit mapping
#define  OPPTE         18
#define  OPPTS         19
#define  OPPTE_MASK    (OPPTE+MASK)
#define  OPPTS_MASK    (OPPTS+MASK)
#define  OPPTS_MAX     1
#define  OPO_BIT       7
#define  OPO1_BIT      0

#define  PORT_OFFSET       0x10
#define  INT_PORT_OFFSET   0x4

typedef enum
{
	E_PT0 = 0,
	E_PT1 = 1,
	E_PT2 = 2,
	E_PT3 = 3,
	E_PT4 = 4
} E_DRVGPIO_PORT;

typedef enum
{
	E_PT6 =  0,
	E_PT7 =  1,
	E_PT8 =  2,
	E_PT9 =  3,
	E_PT13 = 4,
	E_COM54= 5
} E_DRVGPIO_LCDIO;
typedef enum
{
    E_IO_INPUT = 0,
    E_IO_OUTPUT,
    E_IO_PullHigh,
    E_IO_IntEnable
} E_DRVGPIO_IO;

typedef enum
{
	E_DisableGPIOInt = 0,
	E_P_Edge,
	E_N_Edge,
	E_Chang_Level,
	E_LLTri,
	E_LHTri,
	E_LLTri1,
	E_LHTri1
} E_DRVGPIO_IntTriMethod;

typedef enum
{
    E_HS_CK= 0,
    E_LS_CK= 1
} E_DRVGPIO_CLK_SOURCE;

//C Library Function definition
uint8_t DrvGPIO_Open(uint8_t port,uint8_t i32Bit,uint8_t mode );
unsigned int DrvGPIO_SetBit(unsigned int uport, unsigned int i32Bit);
unsigned int DrvGPIO_ClrBit(unsigned int uport, unsigned int i32Bit);
unsigned int DrvGPIO_GetBit(unsigned int port, unsigned int ui8Bit);
unsigned int DrvGPIO_SetPortBits(unsigned int uport, unsigned int ui32Data);
unsigned int DrvGPIO_ClrPortBits(unsigned int uport, unsigned int ui32Data);
unsigned int DrvGPIO_GetPortBits(unsigned int port);
unsigned int DrvGPIO_IntTrigger(uint32_t port, uint32_t i32Bit, uint32_t mode);
unsigned int DrvGPIO_ClkGenerator(uint32_t uClk, uint32_t uDivider);
unsigned int DrvGPIO_ClearIntFlag(E_DRVGPIO_PORT port,unsigned int uint32);
uint32_t DrvGPIO_GetIntFlag(E_DRVGPIO_PORT port);
unsigned int DrvGPIO_Close(uint32_t port,uint32_t i32Bit,uint32_t mode );


unsigned char DrvGPIO_LCDIOOpen(uint32_t port,uint32_t i32Bit,uint32_t mode );
unsigned char DrvGPIO_LCDIOClose(uint32_t port,uint32_t i32Bit,uint32_t mode );
unsigned char DrvGPIO_LCDIOSetPorts(uint32_t port,uint32_t i32Bit);
unsigned char DrvGPIO_LCDIOClrPorts(uint32_t port,uint32_t i32Bit);
unsigned char DrvGPIO_LCDIOSetBit(uint32_t port,uint32_t i32Bit);
unsigned char DrvGPIO_LCDIOClrBit(uint32_t port,uint32_t i32Bit);
//unsigned int DrvGPIO_LCDIOGetPorts(uint32_t port);
unsigned int DrvGPIO_LCDIOGetBit(uint32_t port,uint32_t i32Bit);
unsigned char DrvGPIO_EnableAnalogPin(short port,unsigned int i32Bit);

/*
//PT1
void DrvGPIO_PT1_EnableINPUT(short int ubit);
void DrvGPIO_PT1_DisableINPUT(short int ubit);
void DrvGPIO_PT1_EnablePullHigh(short int ubit);
void DrvGPIO_PT1_DisablePullHigh(short int ubit);
void DrvGPIO_PT1_EnableOUTPUT(short int ubit);
void DrvGPIO_PT1_DisableOUTPUT(short int ubit);
void DrvGPIO_PT1_EnableINT(short int ubit);
void DrvGPIO_PT1_DisableINT(short int ubit);
void DrvGPIO_PT1_IntTriggerPorts(uint32_t i32Bit, uint32_t mode);
void DrvGPIO_PT1_IntTriggerBit(uint32_t i32Bit, uint32_t mode);
void DrvGPIO_PT1_ClearIntFlag(short int uint32);
unsigned char DrvGPIO_PT1_GetIntFlag(void);
unsigned char DrvGPIO_PT1_GetPortBits (void);
void DrvGPIO_PT1_SetPortBits (unsigned char ui32Data);
void DrvGPIO_PT1_ClrPortBits (unsigned int ui32Data);
*/

//PT2 ADD SIMPLE FUNCTION FOR reduce the code size
void DrvGPIO_PT2_EnableINPUT(short int ubit);
void DrvGPIO_PT2_DisableINPUT(short int ubit);
void DrvGPIO_PT2_EnablePullHigh(short int ubit);
void DrvGPIO_PT2_DisablePullHigh(short int ubit);
void DrvGPIO_PT2_EnableOUTPUT(short int ubit);
void DrvGPIO_PT2_DisableOUTPUT(short int ubit);
void DrvGPIO_PT2_EnableINT(short int ubit);
void DrvGPIO_PT2_DisableINT(short int ubit);
void DrvGPIO_PT2_IntTriggerPorts(uint32_t i32Bit, uint32_t mode);
void DrvGPIO_PT2_IntTriggerBit(uint32_t i32Bit, uint32_t mode);
unsigned char DrvGPIO_PT2_GetIntFlag(void);
void DrvGPIO_PT2_ClearIntFlag(short int uint32);
unsigned char DrvGPIO_PT2_GetPortBits(void);
void DrvGPIO_PT2_SetPortBits(unsigned char ui32Data);
void DrvGPIO_PT2_ClrPortBits(unsigned int ui32Data);


//PT3 ADD SIMPLE FUNCTION FOR reduce the code size
void DrvGPIO_PT3_EnableINPUT(short int ubit);
void DrvGPIO_PT3_DisableINPUT(short int ubit);
void DrvGPIO_PT3_EnablePullHigh(short int ubit);
void DrvGPIO_PT3_DisablePullHigh(short int ubit);
void DrvGPIO_PT3_EnableOUTPUT(short int ubit);
void DrvGPIO_PT3_DisableOUTPUT(short int ubit);
unsigned char DrvGPIO_PT3_GetPortBits(void);
void DrvGPIO_PT3_SetPortBits(unsigned char ui32Data);
void DrvGPIO_PT3_ClrPortBits(unsigned int ui32Data);


//PT6 ADD SIMPLE FUNCTION FOR reduce the code size
void DrvGPIO_PT6_EnableINPUT(short int ubit);
void DrvGPIO_PT6_DisableINPUT(short int ubit);
void DrvGPIO_PT6_EnableOUTPUT(short int ubit);
void DrvGPIO_PT6_DisableOUTPUT(short int ubit);
unsigned char DrvGPIO_PT6_GetPortBits(void);
void DrvGPIO_PT6_SetPortBits(unsigned char ui32Data);
void DrvGPIO_PT6_ClrPortBits(unsigned int ui32Data);


//PT7 ADD SIMPLE FUNCTION FOR reduce the code size
void DrvGPIO_PT7_EnableINPUT(short int ubit);
void DrvGPIO_PT7_DisableINPUT(short int ubit);
void DrvGPIO_PT7_EnableOUTPUT(short int ubit);
void DrvGPIO_PT7_DisableOUTPUT(short int ubit);
unsigned char DrvGPIO_PT7_GetPortBits(void);
void DrvGPIO_PT7_SetPortBits(unsigned char ui32Data);
void DrvGPIO_PT7_ClrPortBits(unsigned int ui32Data);


//PT8 ADD SIMPLE FUNCTION FOR reduce the code size
void DrvGPIO_PT8_EnableINPUT(short int ubit);
void DrvGPIO_PT8_DisableINPUT(short int ubit);
void DrvGPIO_PT8_EnableOUTPUT(short int ubit);
void DrvGPIO_PT8_DisableOUTPUT(short int ubit);
unsigned char DrvGPIO_PT8_GetPortBits(void);
void DrvGPIO_PT8_SetPortBits(unsigned char ui32Data);
void DrvGPIO_PT8_ClrPortBits(unsigned int ui32Data);


//PT9 ADD SIMPLE FUNCTION FOR reduce the code size
void DrvGPIO_PT9_EnableINPUT(short int ubit);
void DrvGPIO_PT9_DisableINPUT(short int ubit);
void DrvGPIO_PT9_EnableOUTPUT(short int ubit);
void DrvGPIO_PT9_DisableOUTPUT(short int ubit);
unsigned char DrvGPIO_PT9_GetPortBits(void);
void DrvGPIO_PT9_SetPortBits(unsigned char ui32Data);
void DrvGPIO_PT9_ClrPortBits(unsigned int ui32Data);

/*
//PT10 ADD SIMPLE FUNCTION FOR reduce the code size
void DrvGPIO_PT10_EnableINPUT(short int ubit);
void DrvGPIO_PT10_DisableINPUT(short int ubit);
void DrvGPIO_PT10_EnableOUTPUT(short int ubit);
void DrvGPIO_PT10_DisableOUTPUT(short int ubit);
unsigned char DrvGPIO_PT10_GetPortBits (void);
void DrvGPIO_PT10_SetPortBits (unsigned char ui32Data);
void DrvGPIO_PT10_ClrPortBits (unsigned int ui32Data);
*/

//PT13 ADD SIMPLE FUNCTION FOR reduce the code size
void DrvGPIO_PT13_EnableINPUT(short int ubit);
void DrvGPIO_PT13_DisableINPUT(short int ubit);
void DrvGPIO_PT13_EnableOUTPUT(short int ubit);
void DrvGPIO_PT13_DisableOUTPUT(short int ubit);
unsigned char DrvGPIO_PT13_GetPortBits (void);
void DrvGPIO_PT13_SetPortBits (unsigned char ui32Data);
void DrvGPIO_PT13_ClrPortBits (unsigned int ui32Data);

unsigned int DrvGPIO_PortIDIF(uint32_t port);

#endif /* GPIO_LIB_H_ */
