/*
 *  Created on: 2016/7/28
 *  Author: Robert.Wang
 *  Memo : HY16F3981 DrvGPIO.c is base on HY16F198B to modify
*/

#include "DrvGPIO.h"
#include "SpecialMacro.h"
/*******************************************************************
*name    : unsigned int DrvGPIO_Open()
*function: IO諳馱??宒羲??
*input   : port: IO 諳?i32Bit:渾扢离?IO竘??mode: IO諳馱??宒??
*output  : 0??髡˙?ㄩ???
*Version : v1.1
*date    : 2014-3-24
*modify  : ???????﹜奻嶺???宒?紱釬?离???肮?笱????离?綴?离??????
*          ??DrvGPIO_OPEN()滲???壺??离??/??????壽??茼竘???????＊髡?2015-2-4
*********************************************************************/
uint8_t DrvGPIO_Open(uint8_t port,uint8_t i32Bit,uint8_t mode )
{
  uint32_t l_reg,l_data,ReturnVal;
  ReturnVal=0;
  if (port==1) {l_reg=PT1_BASE;}
  else if (port==2) {l_reg=PT2_BASE;}
  else if (port==3) {l_reg=PT3_BASE;}
  else if (port==4) {l_reg=PT4_BASE;}
  else {ReturnVal=E_DRVGPIO_ARGUMENT;}
  switch (mode)
  {
    case 0:
    	if (i32Bit > 0xff){ReturnVal=E_DRVGPIO_ARGUMENT; break;}

    	l_data=(i32Bit<<16)+(i32Bit<<24);
    	l_reg=l_reg+OFFSET04;
    	outw(l_reg, l_data);
        break;
    case 1:
    	if (i32Bit > 0xff){ReturnVal=E_DRVGPIO_ARGUMENT; break;}

    	l_data=(i32Bit<<8)|i32Bit;
    	outw(l_reg, l_data);
        break;
    case 2:
    	if (i32Bit > 0xff){ReturnVal=E_DRVGPIO_ARGUMENT; break;}
    	l_data=(i32Bit<<16)|(i32Bit<<24);
    	outw(l_reg, l_data);
        break;
    case 3:
    	//Robert modify 2017/3/31, (port>2) --> (port>3)
    	//if (port>2){ReturnVal=E_DRVGPIO_ARGUMENT; break;}
    	if (port>3){ReturnVal=E_DRVGPIO_ARGUMENT; break;}
    	if (i32Bit > 0xff){ReturnVal=E_DRVGPIO_ARGUMENT; break;}
    	l_data=(i32Bit<<16)+(i32Bit<<24);
    	//l_reg=(INTERRUPT_BASE+OFFSET10)+(port*4-4);
    	if (port==2) {l_reg=INTERRUPT_BASE+OFFSET14;}  //l_reg=0x40014=PT2
    	if (port==3) {l_reg=INTERRUPT_BASE+OFFSET10;}  //l_reg=0x40010=PT3
    	outw(l_reg, l_data);

    	break;
  }
  return ReturnVal;
}

unsigned int DrvGPIO_SetBit(unsigned int uport, unsigned int i32Bit)
{
	uint32_t l_data,l_reg,ReturnVal;
	ReturnVal=0;
	if (uport==1) {l_reg=PT1_BASE;}
	else if (uport==2) {l_reg=PT2_BASE;}
	else if (uport==3) {l_reg=PT3_BASE;}
	else if (uport==4) {l_reg=PT4_BASE;}
	else {ReturnVal=E_DRVGPIO_ARGUMENT2;}
	l_reg=l_reg+OFFSET04;
	if (i32Bit > 7){ReturnVal=E_DRVGPIO_ARGUMENT2;}
	else if (i32Bit==0) {l_data=0x00000101;}
	else if (i32Bit==1) {l_data=0x00000202;}
	else if (i32Bit==2) {l_data=0x00000404;}
	else if (i32Bit==3) {l_data=0x00000808;}
	else if (i32Bit==4) {l_data=0x00001010;}
	else if (i32Bit==5) {l_data=0x00002020;}
	else if (i32Bit==6) {l_data=0x00004040;}
	else if (i32Bit==7) {l_data=0x00008080;}
	else {ReturnVal=E_DRVGPIO_ARGUMENT2;}
	outw(l_reg, l_data);
	return ReturnVal;
}


unsigned int DrvGPIO_ClrBit(unsigned int uport, unsigned int i32Bit)
{
	uint32_t l_data,l_reg,ReturnVal;
	ReturnVal=0;
	if (uport==1) {l_reg=PT1_BASE;}
	else if (uport==2) {l_reg=PT2_BASE;}
	else if (uport==3) {l_reg=PT3_BASE;}
	else if (uport==4) {l_reg=PT4_BASE;}
	else {ReturnVal=E_DRVGPIO_ARGUMENT2;}
	l_reg=l_reg+OFFSET04;
	if (i32Bit > 7){ReturnVal=E_DRVGPIO_ARGUMENT3;}
	else if (i32Bit==0) {l_data=0x00000100;}
	else if (i32Bit==1) {l_data=0x00000200;}
	else if (i32Bit==2) {l_data=0x00000400;}
	else if (i32Bit==3) {l_data=0x00000800;}
	else if (i32Bit==4) {l_data=0x00001000;}
	else if (i32Bit==5) {l_data=0x00002000;}
	else if (i32Bit==6) {l_data=0x00004000;}
	else if (i32Bit==7) {l_data=0x00008000;}
	else {ReturnVal=E_DRVGPIO_ARGUMENT3;}
	outw(l_reg, l_data);
	return ReturnVal;
}


unsigned int DrvGPIO_GetBit(unsigned int port, unsigned int ui8Bit)
{
	uint32_t A,l_data,l_reg,ReturnVal;
	ReturnVal=0;
	if (port==1) {l_reg=PT1_BASE;}
	else if (port==2) {l_reg=PT2_BASE;}
	else if (port==3) {l_reg=PT3_BASE;}
	else if (port==4) {l_reg=PT4_BASE;}
	else {ReturnVal=E_DRVGPIO_ARGUMENT3;}
	l_reg=l_reg+OFFSET08;
	l_data=inw(l_reg)&0x000000ff;
	if (ReturnVal!=E_DRVGPIO_ARGUMENT3){
	  if (ui8Bit<8)
	  {
		A=0;
		//A=0x1<<ui8Bit; //A*2;
		//Robert add 2016/07/11
		A=0x00000001<<ui8Bit;
		A=l_data&A;
	    if (A!=0) ReturnVal=1;
	    else ReturnVal=0;
	  }
	  else {ReturnVal=E_DRVGPIO_ARGUMENT3;}
	}
	return ReturnVal;
}

unsigned int DrvGPIO_SetPortBits(unsigned int uport, unsigned int ui32Data)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	if (uport==1) {l_reg=PT1_BASE;}
	else if (uport==2) {l_reg=PT2_BASE;}
	else if (uport==3) {l_reg=PT3_BASE;}
	else if (uport==4) {l_reg=PT4_BASE;}
	else {ReturnVal=E_DRVGPIO_ARGUMENT;}
	l_reg=l_reg+OFFSET04;
	if (ui32Data>0xff) {ReturnVal=E_DRVGPIO_ARGUMENT;}
	//Robert modify 2016/7/28
	//else {l_data=(ui32Data|0x0000ff00);}
	else
	{l_data=(ui32Data|(ui32Data<<8));}
	outw(l_reg, l_data);
	return ReturnVal;
}

unsigned int DrvGPIO_ClrPortBits(unsigned int uport, unsigned int ui32Data)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	if (uport==1) {l_reg=PT1_BASE;}
	else if (uport==2) {l_reg=PT2_BASE;}
	else if (uport==3) {l_reg=PT3_BASE;}
	else if (uport==4) {l_reg=PT4_BASE;}
	else {ReturnVal=E_DRVGPIO_ARGUMENT;}
	l_reg=l_reg+OFFSET04;
	if (ui32Data>0xff) {ReturnVal=E_DRVGPIO_ARGUMENT;}
	else {
		l_data=ui32Data<<8;
	}
	outw(l_reg, l_data);
	return ReturnVal;
}

unsigned int DrvGPIO_GetPortBits(unsigned int port)
{
	unsigned int l_reg;
	if (port==1) {l_reg=PT1_BASE;}
	else if (port==2) {l_reg=PT2_BASE;}
	else if (port==3) {l_reg=PT3_BASE;}
	else if (port==4) {l_reg=PT4_BASE;}
	else {return E_DRVGPIO_ARGUMENT3;}
	l_reg=l_reg+OFFSET08;
	return inw(l_reg)&0x000000ff;
}

unsigned int DrvGPIO_IntTrigger(uint32_t port, uint32_t i32Bit, uint32_t mode)
{
  uint32_t l_reg,l_data,ReturnVal;
  ReturnVal=0;
  //Robert add 2016/7/12
  //if (port==1) {l_reg=PT1_BASE;}
  if (port==3) {l_reg=PT3_BASE;}
  else if (port==2) {l_reg=PT2_BASE;}

  else {return E_DRVGPIO_ARGUMENT;}

  if (mode<8)
  	{
   	if (i32Bit > 0xff){return E_DRVGPIO_ARGUMENT;}
     	l_reg=l_reg+OFFSET0C;
     	l_data=inw(l_reg)|(i32Bit<<24);
     	if (i32Bit&(1<<0)) {l_data=(l_data&0xfffffff8)+mode;}
     	if (i32Bit&(1<<1)) {l_data=(l_data&0xffffffc7)+(mode<<3);}
     	if (i32Bit&(1<<2)) {l_data=(l_data&0xfffffe3f)+(mode<<6);}
     	if (i32Bit&(1<<3)) {l_data=(l_data&0xfffff1ff)+(mode<<9);}
     	if (i32Bit&(1<<4)) {l_data=(l_data&0xffff8fff)+(mode<<12);}
     	if (i32Bit&(1<<5)) {l_data=(l_data&0xfffc7fff)+(mode<<15);}
     	if (i32Bit&(1<<6)) {l_data=(l_data&0xffe3ffff)+(mode<<18);}
     	if (i32Bit&(1<<7)) {l_data=(l_data&0xff1fffff)+(mode<<21);}
   	outw(l_reg, l_data);
  	}
  else
  	{
  		return E_DRVGPIO_ARGUMENT;
  	}
  return ReturnVal;
}

unsigned int DrvGPIO_ClkGenerator(uint32_t uClk, uint32_t uDivider)
{
	uint32_t l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=GOIP_CLOCK_BASE;
	if (uDivider>15) ReturnVal=E_DRVGPIO_ARGUMENT;
	if (uClk==0){l_data=0+uDivider;}
	else if (uClk==1){l_data=0x10+uDivider;}
	else {ReturnVal=E_DRVGPIO_ARGUMENT;}
	l_data=(l_data<<16)|0x1f000000;
	outw(l_reg, l_data);
	return ReturnVal;
}

unsigned int DrvGPIO_ClearIntFlag(E_DRVGPIO_PORT port,unsigned int uint32)
{
	unsigned int l_reg,l_data;
	l_data=(uint32<<8);
	//Robert add 2016/7/12
	//if(port==1)
	if(port==3)
		{
			l_reg=GPIO_INTERRUPT_CTRL;
			outw(l_reg,l_data);
    		}
    else if(port==2)
    	{
	  l_reg=GPIO_INTERRUPT_CTRL+OFFSET04;
	  outw(l_reg,l_data);
    	}
	return (inw(GPIO_INTERRUPT_CTRL)&0x000000ff);
}


uint32_t DrvGPIO_GetIntFlag(E_DRVGPIO_PORT port)
{
	unsigned int l_reg,l_data;
	//Robert modify 2016/7/12
	//if (port>2) return E_FAIL;
	//if(port==1)
	if(port==3)
	{
	  l_reg=GPIO_INTERRUPT_CTRL;
	  l_data=inw(l_reg)&0xff;
    }
	else if(port==2)
	{
	  l_reg=GPIO_INTERRUPT_CTRL+OFFSET04;
	  l_data=inw(l_reg)&0xff;
    }
	return l_data;
}

/*******************************************************************
*name    : unsigned int DrvGPIO_Close()
*function: 壽??茼IO諳?馱釬???
*input   : port:IO諳?i32Bit:渾扢离?IO竘?? mode:渾壽??馱釬???
*output  : 0??髡˙?? ???
*Version : v1.0
*date    : 2014-3-24
*modify  : NO
*********************************************************************/
unsigned int DrvGPIO_Close(uint32_t port,uint32_t i32Bit,uint32_t mode )
{
  uint32_t l_reg,l_data,ReturnVal;
  ReturnVal=0;
  if (port==1) {l_reg=PT1_BASE;}
  else if (port==2) {l_reg=PT2_BASE;}
  else if (port==3) {l_reg=PT3_BASE;}
  else if (port==4) {l_reg=PT4_BASE;}
  else {ReturnVal=E_DRVGPIO_ARGUMENT;}
  switch (mode)
  {
    case 0:
    	if (i32Bit > 0xff){ReturnVal=E_DRVGPIO_ARGUMENT; break;}
    	l_data=(i32Bit<<24)&0xff000000;
    	l_reg=l_reg+OFFSET04;
    	outw(l_reg, l_data);
        break;

    case 1:
    	if (i32Bit > 0xff){ReturnVal=E_DRVGPIO_ARGUMENT; break;}
    	l_data=(i32Bit<<8)&0xff00;
    	outw(l_reg, l_data);
    	break;

    case 2:
    	if (i32Bit > 0xff){ReturnVal=E_DRVGPIO_ARGUMENT; break;}
    	l_data=(i32Bit<<24)&0xff000000;
    	outw(l_reg, l_data);
        break;
    case 3:
    	//Robert modify 2017/3/31, (port>2) --> (port>3)
    	//if (port>2){ReturnVal=E_DRVGPIO_ARGUMENT; break;}
    	if (port>3){ReturnVal=E_DRVGPIO_ARGUMENT; break;}
    	if (i32Bit > 0xff){ReturnVal=E_DRVGPIO_ARGUMENT; break;}
    	l_data=(i32Bit<<24)&0xff000000;
    	//l_reg=(INTERRUPT_BASE+OFFSET10)+(port*4-4);  	   	
    	if (port==2) {l_reg=INTERRUPT_BASE+OFFSET14;}  //l_reg=0x40014=PT2
    	if (port==3) {l_reg=INTERRUPT_BASE+OFFSET10;}  //l_reg=0x40010=PT3
    	outw(l_reg, l_data);
    	break;
  }
  return ReturnVal;
}


/*******************************************************************
*name    : DrvGPIO_LCDIOOpen()
*function: PT6~PT10?IO諳馱??宒羲??
*input   : port: IO 諳?i32Bit:渾扢离?IO竘?,?茼弇?1?符夔掩?离?
*          mode: IO諳馱??宒??0  input mode 1 output mode
*output  : 0??髡˙?ㄩ???
*Version : v1.0
*date    : 2014-7-4
*modify  : NO
*Version : RDS2.1.1 V0.2
*date    : 2018-3-2
*modify  : Add PT13
*********************************************************************/
unsigned char DrvGPIO_LCDIOOpen(uint32_t port,uint32_t i32Bit,uint32_t mode )
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;
	unsigned char lenth;
	l_temp=i32Bit;
	if(port>4)
		return E_FAIL;
	if(port==4) lenth=3;  //PT13, robert add 2018/3/2
	else lenth=4;
	if(mode>1)
		return E_FAIL;
	else if(mode==0) //input mode
		{
			for(i=0;i<lenth;i++)
			{
			l_data=(l_data&0x0)+((l_temp&0x1)<<LCDIO_IN)+((l_temp&0x01)<<LCDIO_IN_MASK);
			l_temp=l_temp>>1;
			l_data=((l_temp&0x1)<<(LCDIO_IN+16))+((l_temp&0x01)<<(LCDIO_IN_MASK+16))+l_data;
			l_temp=l_temp>>1;
			if(port != 4) l_reg=port*0x10+GPIO_PT6+i*0x04;  //PT13, robert add 2018/3/2
			if(port ==4) l_reg=GPIO_PT13+i*0x04;  //PT13, robert add 2018/3/2	  
			outw(l_reg,l_data);
			}
		}

	else if(mode==1) //output mode
		{
			for(i=0;i<lenth;i++)
			{
			l_data=(l_data&0x0)+((l_temp&0x1)<<LCDIO_OUT)+((l_temp&0x01)<<LCDIO_OUT_MASK);
			l_temp=l_temp>>1;
			l_data=((l_temp&0x1)<<(LCDIO_OUT+16))+((l_temp&0x01)<<(LCDIO_OUT_MASK+16))+l_data;
			l_temp=l_temp>>1;
			if(port != 4) l_reg=port*0x10+GPIO_PT6+i*0x04;  //PT13, robert add 2018/3/2
			if(port ==4) l_reg=GPIO_PT13+i*0x04;  //PT13, robert add 2018/3/2	
			outw(l_reg,l_data);
			}
		}
	return E_SUCCESS;
}

/*******************************************************************
*name    : DrvGPIO_LCDIOClose()
*function: PT6~PT10?IO諳馱??宒羲??
*input   : port: IO 諳?i32Bit:渾扢离?IO竘??勤????符夔掩?离?
*          mode: IO諳馱??宒??0  input mode 1 output mode
*output  : 0??髡˙?ㄩ???
*Version : v1.0
*date    : 2014-7-4
*modify  : NO
*Version : RDS2.1.1 V0.2
*date    : 2018-3-2
*modify  : Add PT13
*********************************************************************/
unsigned char DrvGPIO_LCDIOClose(uint32_t port,uint32_t i32Bit,uint32_t mode )
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;
	unsigned char lenth;
	l_temp=i32Bit;
	if(port>4)
		return E_FAIL;
	if(port==4) lenth=3;  //PT13, robert add 2018/3/2
	else lenth=4;
	if(mode>1)
		return E_FAIL;
	else if(mode==0) //input mode
		{
			for(i=0;i<lenth;i++)
			{
			l_data=(l_data&0x0)+(0x0<<LCDIO_IN)+((l_temp&0x01)<<LCDIO_IN_MASK);
			l_temp=l_temp>>1;
			l_data=(0x0<<(LCDIO_IN+16))+((l_temp&0x01)<<(LCDIO_IN_MASK+16))+l_data;
			l_temp=l_temp>>1;
			if(port != 4) l_reg=port*0x10+GPIO_PT6+i*0x04;  //PT13, robert add 2018/3/2
			if(port ==4) l_reg=GPIO_PT13+i*0x04;  //PT13, robert add 2018/3/2		
			outw(l_reg,l_data);
			}

		}

	else if(mode==1) //output mode
		{
			for(i=0;i<lenth;i++)
			{
			l_data=(l_data&0x0)+(0x0<<LCDIO_OUT)+((l_temp&0x01)<<LCDIO_OUT_MASK);
			l_temp=l_temp>>1;
			l_data=(0x0<<(LCDIO_OUT+16))+((l_temp&0x01)<<(LCDIO_OUT_MASK+16))+l_data;
			l_temp=l_temp>>1;
			if(port != 4) l_reg=port*0x10+GPIO_PT6+i*0x04;  //PT13, robert add 2018/3/2
			if(port ==4) l_reg=GPIO_PT13+i*0x04;  //PT13, robert add 2018/3/2	
			outw(l_reg,l_data);
			}
		}

	return E_SUCCESS;
}

/*******************************************************************
*name    : DrvGPIO_LCDIOSetPorts()
*function: PT6~PT10?IO諳???
*input   : port: IO ?0~4 ?
*          i32Bit:?茼IO竘?????跺IO port???离硉紱??毓?0~0XFF?
*output  : 0??髡˙?ㄩ???
*Version : v1.0
*date    : 2014-7-4
*modify  : NO
*Version : RDS2.1.1 V0.2
*date    : 2018-3-2
*modify  : Add PT13
*********************************************************************/
unsigned char DrvGPIO_LCDIOSetPorts(uint32_t port,uint32_t i32Bit)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;
	unsigned char lenth;
	l_temp=i32Bit;
	if(port>4)
		return E_FAIL;
	if(port==4) lenth=3;   //PT13, robert add 2018/3/2
	else lenth=4;

	for(i=0;i<lenth;i++)
	{
	l_data=(l_data&0x0)+(0x01<<LCDIO_DO)+((l_temp&0x1)<<LCDIO_DO_MASK);
	l_temp=l_temp>>1;
	l_data=(0x01<<(LCDIO_DO+16))+((l_temp&0x1)<<(LCDIO_DO_MASK+16))+l_data;
	l_temp=l_temp>>1;
	if(port != 4) l_reg=port*0x10+GPIO_PT6+i*0x04;  //PT13, robert add 2018/3/2
	if(port ==4) l_reg=GPIO_PT13+i*0x04;  //PT13, robert add 2018/3/2	
	outw(l_reg,l_data);
	}

	return E_SUCCESS;
}

/*******************************************************************
*name    : DrvGPIO_LCDIOClrPorts()
*function: PT6~PT10?IO諳???????
*input   : port: IO ?0~4 ?
*          i32Bit:?茼IO竘?????跺IO port???离硉紱??毓?0~0XFF?
*output  : 0??髡˙?ㄩ???
*Version : v1.0
*date    : 2014-7-4
*modify  : NO
*Version : RDS2.1.1 V0.2
*date    : 2018-3-2
*modify  : Add PT13
*********************************************************************/
unsigned char DrvGPIO_LCDIOClrPorts(uint32_t port,uint32_t i32Bit)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;
	unsigned char lenth;
	l_temp=i32Bit;
	if(port>4)
		return E_FAIL;
	if(port==4) lenth=3;   //PT13, robert add 2018/3/2
	else lenth=4;

	for(i=0;i<lenth;i++)
	{
	l_data=(l_data&0x0)+(0x0<<LCDIO_DO)+((l_temp&0x1)<<LCDIO_DO_MASK);
	l_temp=l_temp>>1;
	l_data=(0x0<<(LCDIO_DO+16))+((l_temp&0x1)<<(LCDIO_DO_MASK+16))+l_data;
	l_temp=l_temp>>1;
	if(port != 4) l_reg=port*0x10+GPIO_PT6+i*0x04;  //PT13, robert add 2018/3/2
	if(port ==4) l_reg=GPIO_PT13+i*0x04;  //PT13, robert add 2018/3/2	
	outw(l_reg,l_data);
	}

	return E_SUCCESS;
}

/*******************************************************************
*name    : DrvGPIO_LCDIOSetBit()
*function: PT6~PT10?IO諳????离
*input   : port: IO ?0~4 ?
*          i32Bit:渾扢离?IO竘??掩?笢??褐????掩????~7?
*output  : 0??髡˙?ㄩ???
*Version : v1.0
*date    : 2014-7-4
*modify  : NO
*Version : RDS2.1.1 V0.2
*date    : 2018-3-2
*modify  : Add PT13
*********************************************************************/
unsigned char DrvGPIO_LCDIOSetBit(uint32_t port,uint32_t i32Bit)
{
	unsigned int l_reg,l_data;
	unsigned char i,l_temp;
	if((port>4)||(i32Bit>7))
		return E_FAIL;
	i=i32Bit/2;
	l_temp=(1+i32Bit)%2;
	if(l_temp==1)
		l_data=(l_data&0x0)+(0x1<<LCDIO_DO)+(0x01<<LCDIO_DO_MASK);
	else
		l_data=(l_data&0x0)+(0x1<<(LCDIO_DO+16))+(0x01<<(LCDIO_DO_MASK+16));

	if(port != 4) l_reg=port*0x10+GPIO_PT6+i*0x04;  //PT13, robert add 2018/3/2
	if(port ==4) l_reg=GPIO_PT13+i*0x04;  //PT13, robert add 2018/3/2	
	outw(l_reg,l_data);

	return E_SUCCESS;
}

/*******************************************************************
*name    : DrvGPIO_LCDIOClrBit()
*function: PT6~PT10?IO諳????錨
*input   : port: IO ?0~4 ?
*          i32Bit:渾扢离?IO竘??掩?笢??褐????掩????~7?
*output  : 0??髡˙?ㄩ???
*Version : v1.0
*date    : 2014-7-4
*modify  : NO
*Version : RDS2.1.1 V0.2
*date    : 2018-3-2
*modify  : Add PT13
*********************************************************************/
unsigned char DrvGPIO_LCDIOClrBit(uint32_t port,uint32_t i32Bit)
{
	unsigned int l_reg,l_data;
	unsigned char i,l_temp;
	l_temp=i32Bit;
	if((port>4)||(i32Bit>7))
		return E_FAIL;
	i=i32Bit/2;
	l_temp=(1+i32Bit)%2;
	if(l_temp==1)
		l_data=(l_data&0x0)+(0x0<<LCDIO_DO)+(0x01<<LCDIO_DO_MASK);
	else
		l_data=(0x0<<(LCDIO_DO+16))+(0x01<<(LCDIO_DO_MASK+16));

	if(port != 4) l_reg=port*0x10+GPIO_PT6+i*0x04;  //PT13, robert add 2018/3/2
	if(port ==4) l_reg=GPIO_PT13+i*0x04;  //PT13, robert add 2018/3/2	
	outw(l_reg,l_data);

	return E_SUCCESS;
}

/*******************************************************************
*name    : DrvGPIO_LCDIOGetBit()
*function: 黍PT6~PT10?IO諳??袨??
*input   : port: IO ?0~4 ? 黍議跺IO 諳掩?笢竘????袨??
*          i32Bit: IO竘??????~7
*output  : IO諳掩?笢竘????袨??
*Version : v1.0
*date    : 2014-7-4
*modify  : NO
*Version : RDS2.1.1 V0.2
*date    : 2018-3-2
*modify  : Add PT13
*********************************************************************/
unsigned int DrvGPIO_LCDIOGetBit(uint32_t port,uint32_t i32Bit)
{
	unsigned int l_reg,l_data;
	unsigned char i,l_temp;
	l_temp=i32Bit;
	if((port>4)||(i32Bit>7))
		return 0xff;
	i=(i32Bit)/2;
	l_temp=(i32Bit)%2;
	if(port != 4) l_reg=port*0x10+GPIO_PT6+i*0x04;  //PT13, robert add 2018/3/2
	if(port ==4) l_reg=GPIO_PT13+i*0x04;  //PT13, robert add 2018/3/2	
	if(l_temp==0)
		l_data=(inw(l_reg)>>LCDIO_DI)&0X01;
	else
		l_data=(inw(l_reg)>>(LCDIO_DI+16))&0X01;
	return l_data&0x1;
}

/*************************************************************************
name:      DrvGPIO_EnableAnalogPin
function:  籵徹???壽?勤?IO諳pin??趼?宒??﹜???俋?笢剿﹜笢??楷??IO?茼弇?1?符夔掩衄虴?离?
input:     port?PT1,PT2?PT3; upin:0~0xff;
output:    0/1 success/fail
note:	     硐??????峈???????宒?IO pin?离??羶衄?????祥??离?
date:      2014-10-17
modify :   2016/7/12, change clear ITT code setting. by Robert
*************************************************************************/
unsigned char DrvGPIO_EnableAnalogPin(short port,unsigned int i32Bit)
{
	unsigned int l_reg,l_data;
	if((port>3)||(i32Bit>0xff))
		return E_FAIL;
	if (port==1) {l_reg=PT1_BASE;}
	else if (port==2) {l_reg=PT2_BASE;}
	else if (port==3) {l_reg=PT3_BASE;}
	else return E_FAIL;

    l_data=(i32Bit<<8)&0xff00;       //disable output mode
	outw(l_reg, l_data);

	l_data=(i32Bit<<24)&0xff000000;  //disable pull high mode
	outw(l_reg, l_data);

	l_data=(i32Bit<<24)&0xff000000;   //disable  input mode
	l_reg=l_reg+OFFSET04;
	outw(l_reg, l_data);


    l_data=(i32Bit<<8)&0xff00;       //clear output data
	outw(l_reg, l_data);

    l_data=(i32Bit<<24);
    if (i32Bit&(1<<0)) {l_data=l_data+0x7;}
    if (i32Bit&(1<<1)) {l_data=l_data+(0x7<<3);}
    if (i32Bit&(1<<2)) {l_data=l_data+(0x7<<6);}
    if (i32Bit&(1<<3)) {l_data=l_data+(0x7<<9);}
    if (i32Bit&(1<<4)) {l_data=l_data+(0x7<<12);}
    if (i32Bit&(1<<5)) {l_data=l_data+(0x7<<15);}
    if (i32Bit&(1<<6)) {l_data=l_data+(0x7<<18);}
    if (i32Bit&(1<<7)) {l_data=l_data+(0x7<<21);}
    l_data=l_data^0xffffffff;
    l_reg=l_reg+OFFSET08;
    l_data=inw(l_reg)&l_data;
    outw(l_reg, l_data);

    return E_SUCCESS;

}


//******************  PT2 simple FUNCTION FOR REDUCE CODE SIZE *****************
//******************************************************************************
//******************************************************************************
/****************************************************************************
 * name    : DrvGPIO_PT2_EnableINPUT(short int ubit)
 * function: enable the PT2 pin input mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT2_EnableINPUT(short int ubit)
{
	  uint32_t l_data;
	  l_data=(ubit <<16)|(ubit <<24);
	  outw(PT2_BASE+OFFSET04, l_data);
}

/****************************************************************************
 * name    : DrvGPIO_PT2_DisableINPUT(short int ubit)
 * function: disable the PT2 pin input mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT2_DisableINPUT(short int ubit)
{
	uint32_t l_data;
  	l_data=(ubit<<24)&0xff000000;
  	outw(PT2_BASE+OFFSET04, l_data);
}

/****************************************************************************
 * name    : DrvGPIO_PT2_EnablePullHigh(short int ubit)
 * function: enable the PT2 pin pull high mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT2_EnablePullHigh(short int ubit)
{
	  uint32_t l_data;

	  l_data=(ubit <<16)|(ubit <<24);
	  outw(PT2_BASE, l_data);
}

/****************************************************************************
 * name    : DrvGPIO_PT2_DisablePullHigh(short int ubit)
 * function: disable the PT2 pin PullHigh mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT2_DisablePullHigh(short int ubit)
{
    uint32_t l_data;
  	l_data=(ubit<<24)&0xff000000;
  	outw(PT2_BASE, l_data);
}

/****************************************************************************
 * name    : DrvGPIO_PT2_EnableOUTPUT(short int ubit)
 * function: enable the PT2 pin output mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT2_EnableOUTPUT(short int ubit)
{
	uint32_t l_data;

  	l_data=(ubit<<8)|ubit;
  	outw(PT2_BASE, l_data);
}

/****************************************************************************
 * name    : DrvGPIO_PT2_DisableOUTPUT(short int ubit)
 * function: disable the PT2 pin output mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT2_DisableOUTPUT(short int ubit)
{
	uint32_t l_data;
	l_data=(ubit<<8)&0xff00;
  	outw(PT2_BASE, l_data);
}

/****************************************************************************
 * name    : DrvGPIO_PT2_EnableINT(short int ubit)
 * function: enable the PT2 pin EXTERNAL INTERRUPT mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT2_EnableINT(short int ubit)
{
    uint32_t l_data;
	l_data=(ubit<<16)+(ubit<<24);
	outw(INTERRUPT_BASE+OFFSET14, l_data);

}

/****************************************************************************
 * name    : DrvGPIO_PT2_DisableINT(short int ubit)
 * function: disable the PT2 pin output mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT2_DisableINT(short int ubit)
{
    uint32_t l_data;
	l_data=(ubit<<24)&0xff000000;
	outw(INTERRUPT_BASE+OFFSET14, l_data);

}

/****************************************************************************
 * name    : DrvGPIO_PT2_IntTriggerPorts(uint32_t i32Bit, uint32_t mode)
 * function: setting PT2 interrupt trig edge
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT2_IntTriggerPorts(uint32_t i32Bit, uint32_t mode)
{
	uint32_t l_reg,l_data;

    l_reg=PT2_BASE+OFFSET0C;
    l_data=inw(l_reg)|(i32Bit<<24);
    if (i32Bit&(1<<0)) {l_data=(l_data&0xfffffff8)+mode;}
    if (i32Bit&(1<<1)) {l_data=(l_data&0xffffffc7)+(mode<<3);}
    if (i32Bit&(1<<2)) {l_data=(l_data&0xfffffe3f)+(mode<<6);}
    if (i32Bit&(1<<3)) {l_data=(l_data&0xfffff1ff)+(mode<<9);}
    if (i32Bit&(1<<4)) {l_data=(l_data&0xffff8fff)+(mode<<12);}
    if (i32Bit&(1<<5)) {l_data=(l_data&0xfffc7fff)+(mode<<15);}
    if (i32Bit&(1<<6)) {l_data=(l_data&0xffe3ffff)+(mode<<18);}
    if (i32Bit&(1<<7)) {l_data=(l_data&0xff1fffff)+(mode<<21);}
   	outw(l_reg, l_data);

}

/****************************************************************************
 * name    : DrvGPIO_PT2_IntTriggerBit(uint32_t i32Bit, uint32_t mode)
 * function: setting PT2 interrupt trig edge
 * input   : ubit:0~7,???bit符????扢?
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT2_IntTriggerBit(uint32_t i32Bit, uint32_t mode)
{
	uint32_t l_data;
    l_data=inw(PT2_BASE+OFFSET0C)|(1<<(24+i32Bit));
    l_data=(~(0x7<<(i32Bit*3))&l_data)|(mode<<(i32Bit*3));
   	outw(PT2_BASE+OFFSET0C, l_data);

}

/****************************************************************************
 * name    : DrvGPIO_PT2_ClearIntFlag(short int ubit)
 * function: Clear PT2 Interrupt Flag
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT2_ClearIntFlag(short int uint32)
{
	unsigned int l_data;
	l_data=(uint32<<8);
	outw(GPIO_INTERRUPT_CTRL+OFFSET04,l_data);
}

/****************************************************************************
 * name    : DrvGPIO_PT2_GetIntFlag(void)
 * function: read PT2 Interrupt Flag
 * input   : NO
 * output  : 殿?笢剿梓祩弇?
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
unsigned char DrvGPIO_PT2_GetIntFlag(void)
{
	return (inw(GPIO_INTERRUPT_CTRL+OFFSET04)&0xff);
}

/****************************************************************************
 * name    : DrvGPIO_PT2_GetPortBits (void)
 * function: read PT2 ??袨??
 * input   : NO
 * output  : 殿?PT2 PORT ??袨??
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
unsigned char DrvGPIO_PT2_GetPortBits(void)
{
	return inw(PT2_BASE+OFFSET08)&0x000000ff;
}

/****************************************************************************
 * name    : DrvGPIO_PT2_SetPortBits (unsigned char ui32Data)
 * function: setting PT2 ?茼褐???1?
 * input   : ui32Data:0~0xff,?茼弇?1?符夔掩衄虴?离??1?
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT2_SetPortBits(unsigned char ui32Data)
{
	unsigned int l_data;
	l_data=ui32Data|(ui32Data<<8);
	outw(PT2_BASE+OFFSET04, l_data);
}

/****************************************************************************
 * name    : DrvGPIO_PT2_ClrPortBits (unsigned int ui32Data)
 * function: setting PT2 ?茼褐???0?
 * input   : ui32Data:0~0xff,?茼弇?1?符夔掩衄虴?离??0?
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT2_ClrPortBits(unsigned int ui32Data)
{

	outw(PT2_BASE+OFFSET04, ui32Data<<8);
}


//******************************************************************************
//******************************************************************************
//******************  PT3 simple FUNCTION FOR REDUCE CODE SIZE *****************
//******************************************************************************
//******************************************************************************
/****************************************************************************
 * name    : DrvGPIO_PT3_EnableINPUT(short int ubit)
 * function: enable the PT3 pin input mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT3_EnableINPUT(short int ubit)
{
	  uint32_t l_data;

	  l_data=(ubit <<16)|(ubit <<24);
	  outw(PT3_BASE+OFFSET04, l_data);
}

/****************************************************************************
 * name    : DrvGPIO_PT3_DisableINPUT(short int ubit)
 * function: disable the PT3 pin input mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT3_DisableINPUT(short int ubit)
{
	 uint32_t l_data;
  	l_data=(ubit<<24)&0xff000000;
  	outw(PT3_BASE+OFFSET04, l_data);
}

/****************************************************************************
 * name    : DrvGPIO_PT3_EnablePullHigh(short int ubit)
 * function: enable the PT3 pin pull high mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT3_EnablePullHigh(short int ubit)
{
	  uint32_t l_data;
	  l_data=(ubit <<16)|(ubit <<24);
	  outw(PT3_BASE, l_data);
}

/****************************************************************************
 * name    : DrvGPIO_PT3_DisablePullHigh(short int ubit)
 * function: disable the PT3 pin PullHigh mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT3_DisablePullHigh(short int ubit)
{
	  uint32_t l_data;

  	l_data=(ubit<<24)&0xff000000;
  	outw(PT3_BASE, l_data);

}

/****************************************************************************
 * name    : DrvGPIO_PT3_EnableOUTPUT(short int ubit)
 * function: enable the PT3 pin output mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT3_EnableOUTPUT(short int ubit)
{
	uint32_t l_data;
  	l_data=(ubit<<8)|ubit;
  	outw(PT3_BASE, l_data);
}

/****************************************************************************
 * name    : DrvGPIO_PT3_DisableOUTPUT(short int ubit)
 * function: disable the PT3 pin output mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT3_DisableOUTPUT(short int ubit)
{
	uint32_t l_data;

	l_data=(ubit<<8)&0xff00;
  	outw(PT3_BASE, l_data);

}

/****************************************************************************
 * name    : DrvGPIO_PT3_GetPortBits (void)
 * function: read PT3 ??袨??
 * input   : NO
 * output  : 殿?PT3 PORT ??袨??
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
unsigned char DrvGPIO_PT3_GetPortBits(void)
{
	return inw(PT3_BASE+OFFSET08)&0x000000ff;
}

/****************************************************************************
 * name    : DrvGPIO_PT3_SetPortBits (unsigned char ui32Data)
 * function: setting PT3 ?茼褐???1?
 * input   : ui32Data:0~0xff,?茼弇?1?符夔掩衄虴?离??1?
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT3_SetPortBits(unsigned char ui32Data)
{
	unsigned int l_data;
	l_data=ui32Data|(ui32Data<<8);
	outw(PT3_BASE+OFFSET04, l_data);
}

/****************************************************************************
 * name    : DrvGPIO_PT3_ClrPortBits (unsigned int ui32Data)
 * function: setting PT3 ?茼褐???0?
 * input   : ui32Data:0~0xff,?茼弇?1?符夔掩衄虴?离??0?
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT3_ClrPortBits(unsigned int ui32Data)
{
	outw(PT3_BASE+OFFSET04, ui32Data<<8);
}


//**************************************************************************
//****************  HY16F19X PT6 IO  ***************************************
//**************************************************************************
/****************************************************************************
 * name    : DrvGPIO_PT6_EnableINPUT(short int ubit)
 * function: enable the PT6 pin input mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT6_EnableINPUT(short int ubit)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;
	l_temp=ubit;
	for(i=0;i<4;i++)
	{
		l_data=(l_data&0x0)+((l_temp&0x1)<<LCDIO_IN)+((l_temp&0x01)<<LCDIO_IN_MASK);
		l_temp=l_temp>>1;
		l_data=((l_temp&0x1)<<(LCDIO_IN+16))+((l_temp&0x01)<<(LCDIO_IN_MASK+16))+l_data;
		l_temp=l_temp>>1;
		l_reg=GPIO_PT6+i*0x04;
		outw(l_reg,l_data);
	}
}

/****************************************************************************
 * name    : DrvGPIO_PT6_DisableINPUT(short int ubit)
 * function: disable the PT6 pin input mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT6_DisableINPUT(short int ubit)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;
	l_temp=ubit;
	for(i=0;i<4;i++)
	{
		l_data=(l_data&0x0)+(0x0<<LCDIO_IN)+((l_temp&0x01)<<LCDIO_IN_MASK);
		l_temp=l_temp>>1;
		l_data=(0x0<<(LCDIO_IN+16))+((l_temp&0x01)<<(LCDIO_IN_MASK+16))+l_data;
		l_temp=l_temp>>1;
		l_reg=GPIO_PT6+i*0x04;
		outw(l_reg,l_data);
	}
}

/****************************************************************************
 * name    : DrvGPIO_PT6_EnableOUTPUT(short int ubit)
 * function: enable the PT6 pin output mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT6_EnableOUTPUT(short int ubit)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;
	l_temp=ubit;
	for(i=0;i<4;i++)
	{
		l_data=(l_data&0x0)+((l_temp&0x1)<<LCDIO_OUT)+((l_temp&0x01)<<LCDIO_OUT_MASK);
		l_temp=l_temp>>1;
		l_data=((l_temp&0x1)<<(LCDIO_OUT+16))+((l_temp&0x01)<<(LCDIO_OUT_MASK+16))+l_data;
		l_temp=l_temp>>1;
		l_reg=GPIO_PT6+i*0x04;
		outw(l_reg,l_data);
	}
}

/****************************************************************************
 * name    : DrvGPIO_PT6_DisableOUTPUT(short int ubit)
 * function: disable the PT6 pin output mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT6_DisableOUTPUT(short int ubit)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;

	l_temp=ubit;

	for(i=0;i<4;i++)
	{
		l_data=(l_data&0x0)+(0x0<<LCDIO_OUT)+((l_temp&0x01)<<LCDIO_OUT_MASK);
		l_temp=l_temp>>1;
		l_data=(0x0<<(LCDIO_OUT+16))+((l_temp&0x01)<<(LCDIO_OUT_MASK+16))+l_data;
		l_temp=l_temp>>1;
		l_reg=GPIO_PT6+i*0x04;
		outw(l_reg,l_data);
	}
}

/****************************************************************************
 * name    : DrvGPIO_PT6_GetPortBits (void)
 * function: read PT6 ??袨??
 * input   : NO
 * output  : 殿?PT3 PORT ??袨??
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
unsigned char DrvGPIO_PT6_GetPortBits(void)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;

	l_data=0x00000000;
	for(i=4;i>0;i--)
	{
	l_reg=GPIO_PT6+(i-1)*0x04;
	l_temp=inw(l_reg);
	l_data=l_data<<1;
	l_data=((l_temp>>(LCDIO_DI+16))&0X01)+l_data;
	l_data=l_data<<1;
	l_data=((l_temp>>(LCDIO_DI))&0X01)+l_data;
	}
	return l_data&0xff;
}

/****************************************************************************
 * name    : DrvGPIO_PT6_SetPortBits (unsigned char ui32Data)
 * function: setting PT6 ?茼褐???1?
 * input   : ui32Data:0~0xff,?茼弇?1?符夔掩衄虴?离??1?
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT6_SetPortBits(unsigned char ui32Data)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;

	l_temp=ui32Data;

	for(i=0;i<4;i++)
	{
	l_data=(l_data&0x0)+(0x01<<LCDIO_DO)+((l_temp&0x1)<<LCDIO_DO_MASK);
	l_temp=l_temp>>1;
	l_data=(0x01<<(LCDIO_DO+16))+((l_temp&0x1)<<(LCDIO_DO_MASK+16))+l_data;
	l_temp=l_temp>>1;
	l_reg=GPIO_PT6+i*0x04;
	outw(l_reg,l_data);
	}
}

/****************************************************************************
 * name    : DrvGPIO_PT6_ClrPortBits (unsigned int ui32Data)
 * function: setting PT6 ?茼褐???0?
 * input   : ui32Data:0~0xff,?茼弇?1?符夔掩衄虴?离??0?
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT6_ClrPortBits(unsigned int ui32Data)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;

	l_temp=ui32Data;

	for(i=0;i<4;i++)
	{
	  l_data=(l_data&0x0)+(0x0<<LCDIO_DO)+((l_temp&0x1)<<LCDIO_DO_MASK);
	  l_temp=l_temp>>1;
	  l_data=(0x0<<(LCDIO_DO+16))+((l_temp&0x1)<<(LCDIO_DO_MASK+16))+l_data;
	  l_temp=l_temp>>1;
	  l_reg=GPIO_PT6+i*0x04;
	  outw(l_reg,l_data);
	}

}


//*******************************************************************************
/********************************************************************************
 ******************** PT7 IO function *******************************************
 ********************************************************************************/
/****************************************************************************
 * name    : DrvGPIO_PT7_EnableINPUT(short int ubit)
 * function: enable the PT7 pin input mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT7_EnableINPUT(short int ubit)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;
	l_temp=ubit;
	for(i=0;i<4;i++)
	{
		l_data=(l_data&0x0)+((l_temp&0x1)<<LCDIO_IN)+((l_temp&0x01)<<LCDIO_IN_MASK);
		l_temp=l_temp>>1;
		l_data=((l_temp&0x1)<<(LCDIO_IN+16))+((l_temp&0x01)<<(LCDIO_IN_MASK+16))+l_data;
		l_temp=l_temp>>1;
		l_reg=GPIO_PT7+i*0x04;
		outw(l_reg,l_data);
	}
}

/****************************************************************************
 * name    : DrvGPIO_PT7_DisableINPUT(short int ubit)
 * function: disable the PT7 pin input mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT7_DisableINPUT(short int ubit)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;
	l_temp=ubit;
	for(i=0;i<4;i++)
	{
		l_data=(l_data&0x0)+(0x0<<LCDIO_IN)+((l_temp&0x01)<<LCDIO_IN_MASK);
		l_temp=l_temp>>1;
		l_data=(0x0<<(LCDIO_IN+16))+((l_temp&0x01)<<(LCDIO_IN_MASK+16))+l_data;
		l_temp=l_temp>>1;
		l_reg=GPIO_PT7+i*0x04;
		outw(l_reg,l_data);
	}
}

/****************************************************************************
 * name    : DrvGPIO_PT7_EnableOUTPUT(short int ubit)
 * function: enable the PT7 pin output mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT7_EnableOUTPUT(short int ubit)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;
	l_temp=ubit;
	for(i=0;i<4;i++)
	{
		l_data=(l_data&0x0)+((l_temp&0x1)<<LCDIO_OUT)+((l_temp&0x01)<<LCDIO_OUT_MASK);
		l_temp=l_temp>>1;
		l_data=((l_temp&0x1)<<(LCDIO_OUT+16))+((l_temp&0x01)<<(LCDIO_OUT_MASK+16))+l_data;
		l_temp=l_temp>>1;
		l_reg=GPIO_PT7+i*0x04;
		outw(l_reg,l_data);
	}
}

/****************************************************************************
 * name    : DrvGPIO_PT7_DisableOUTPUT(short int ubit)
 * function: disable the PT7 pin output mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT7_DisableOUTPUT(short int ubit)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;

	l_temp=ubit;

	for(i=0;i<4;i++)
	{
		l_data=(l_data&0x0)+(0x0<<LCDIO_OUT)+((l_temp&0x01)<<LCDIO_OUT_MASK);
		l_temp=l_temp>>1;
		l_data=(0x0<<(LCDIO_OUT+16))+((l_temp&0x01)<<(LCDIO_OUT_MASK+16))+l_data;
		l_temp=l_temp>>1;
		l_reg=GPIO_PT7+i*0x04;
		outw(l_reg,l_data);
	}

}

/****************************************************************************
 * name    : DrvGPIO_PT7_GetPortBits (void)
 * function: read PT7 ??袨??
 * input   : NO
 * output  : 殿?PT3 PORT ??袨??
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
unsigned char DrvGPIO_PT7_GetPortBits(void)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;

	l_data=0x00000000;
	for(i=4;i>0;i--)
	{
	l_reg=GPIO_PT7+(i-1)*0x04;
	l_temp=inw(l_reg);
	l_data=l_data<<1;
	l_data=((l_temp>>(LCDIO_DI+16))&0X01)+l_data;
	l_data=l_data<<1;
	l_data=((l_temp>>(LCDIO_DI))&0X01)+l_data;
	}
	return l_data&0xff;
}

/****************************************************************************
 * name    : DrvGPIO_PT7_SetPortBits (unsigned char ui32Data)
 * function: setting PT7 ?茼褐???1?
 * input   : ui32Data:0~0xff,?茼弇?1?符夔掩衄虴?离??1?
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT7_SetPortBits(unsigned char ui32Data)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;

	l_temp=ui32Data;

	for(i=0;i<4;i++)
	{
	l_data=(l_data&0x0)+(0x01<<LCDIO_DO)+((l_temp&0x1)<<LCDIO_DO_MASK);
	l_temp=l_temp>>1;
	l_data=(0x01<<(LCDIO_DO+16))+((l_temp&0x1)<<(LCDIO_DO_MASK+16))+l_data;
	l_temp=l_temp>>1;
	l_reg=GPIO_PT7+i*0x04;
	outw(l_reg,l_data);
	}
}

/****************************************************************************
 * name    : DrvGPIO_PT7_ClrPortBits (unsigned int ui32Data)
 * function: setting PT7 ?茼褐???0?
 * input   : ui32Data:0~0xff,?茼弇?1?符夔掩衄虴?离??0?
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT7_ClrPortBits(unsigned int ui32Data)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;

	l_temp=ui32Data;

	for(i=0;i<4;i++)
	{
	  l_data=(l_data&0x0)+(0x0<<LCDIO_DO)+((l_temp&0x1)<<LCDIO_DO_MASK);
	  l_temp=l_temp>>1;
	  l_data=(0x0<<(LCDIO_DO+16))+((l_temp&0x1)<<(LCDIO_DO_MASK+16))+l_data;
	  l_temp=l_temp>>1;
	  l_reg=GPIO_PT7+i*0x04;
	  outw(l_reg,l_data);
	}

}


//***************************************************************************
/****************************************************************************
 ************************    PT8 IO function    *****************************
 ****************************************************************************/
/****************************************************************************
 * name    : DrvGPIO_PT8_EnableINPUT(short int ubit)
 * function: enable the PT8 pin input mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT8_EnableINPUT(short int ubit)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;
	l_temp=ubit;
	for(i=0;i<4;i++)
	{
		l_data=(l_data&0x0)+((l_temp&0x1)<<LCDIO_IN)+((l_temp&0x01)<<LCDIO_IN_MASK);
		l_temp=l_temp>>1;
		l_data=((l_temp&0x1)<<(LCDIO_IN+16))+((l_temp&0x01)<<(LCDIO_IN_MASK+16))+l_data;
		l_temp=l_temp>>1;
		l_reg=GPIO_PT8+i*0x04;
		outw(l_reg,l_data);
	}
}
/****************************************************************************
 * name    : DrvGPIO_PT8_DisableINPUT(short int ubit)
 * function: disable the PT8 pin input mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT8_DisableINPUT(short int ubit)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;
	l_temp=ubit;
	for(i=0;i<4;i++)
	{
		l_data=(l_data&0x0)+(0x0<<LCDIO_IN)+((l_temp&0x01)<<LCDIO_IN_MASK);
		l_temp=l_temp>>1;
		l_data=(0x0<<(LCDIO_IN+16))+((l_temp&0x01)<<(LCDIO_IN_MASK+16))+l_data;
		l_temp=l_temp>>1;
		l_reg=GPIO_PT8+i*0x04;
		outw(l_reg,l_data);
	}
}

/****************************************************************************
 * name    : DrvGPIO_PT8_EnableOUTPUT(short int ubit)
 * function: enable the PT8 pin output mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT8_EnableOUTPUT(short int ubit)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;
	l_temp=ubit;
	for(i=0;i<4;i++)
	{
		l_data=(l_data&0x0)+((l_temp&0x1)<<LCDIO_OUT)+((l_temp&0x01)<<LCDIO_OUT_MASK);
		l_temp=l_temp>>1;
		l_data=((l_temp&0x1)<<(LCDIO_OUT+16))+((l_temp&0x01)<<(LCDIO_OUT_MASK+16))+l_data;
		l_temp=l_temp>>1;
		l_reg=GPIO_PT8+i*0x04;
		outw(l_reg,l_data);
	}

}
/****************************************************************************
 * name    : DrvGPIO_PT8_DisableOUTPUT(short int ubit)
 * function: disable the PT8 pin output mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT8_DisableOUTPUT(short int ubit)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;

	l_temp=ubit;

	for(i=0;i<4;i++)
	{
		l_data=(l_data&0x0)+(0x0<<LCDIO_OUT)+((l_temp&0x01)<<LCDIO_OUT_MASK);
		l_temp=l_temp>>1;
		l_data=(0x0<<(LCDIO_OUT+16))+((l_temp&0x01)<<(LCDIO_OUT_MASK+16))+l_data;
		l_temp=l_temp>>1;
		l_reg=GPIO_PT8+i*0x04;
		outw(l_reg,l_data);
	}

}

/****************************************************************************
 * name    : DrvGPIO_PT8_GetPortBits (void)
 * function: read PT8 ??袨??
 * input   : NO
 * output  : 殿?PT3 PORT ??袨??
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
unsigned char DrvGPIO_PT8_GetPortBits(void)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;

	l_data=0x00000000;
	for(i=4;i>0;i--)
	{
	l_reg=GPIO_PT8+(i-1)*0x04;
	l_temp=inw(l_reg);
	l_data=l_data<<1;
	l_data=((l_temp>>(LCDIO_DI+16))&0X01)+l_data;
	l_data=l_data<<1;
	l_data=((l_temp>>(LCDIO_DI))&0X01)+l_data;
	}
	return l_data&0xff;
}

/****************************************************************************
 * name    : DrvGPIO_PT8_SetPortBits (unsigned char ui32Data)
 * function: setting PT8 ?茼褐???1?
 * input   : ui32Data:0~0xff,?茼弇?1?符夔掩衄虴?离??1?
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT8_SetPortBits(unsigned char ui32Data)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;

	l_temp=ui32Data;

	for(i=0;i<4;i++)
	{
	l_data=(l_data&0x0)+(0x01<<LCDIO_DO)+((l_temp&0x1)<<LCDIO_DO_MASK);
	l_temp=l_temp>>1;
	l_data=(0x01<<(LCDIO_DO+16))+((l_temp&0x1)<<(LCDIO_DO_MASK+16))+l_data;
	l_temp=l_temp>>1;
	l_reg=GPIO_PT8+i*0x04;
	outw(l_reg,l_data);
	}
}

/****************************************************************************
 * name    : DrvGPIO_PT8_ClrPortBits (unsigned int ui32Data)
 * function: setting PT8 ?茼褐???0?
 * input   : ui32Data:0~0xff,?茼弇?1?符夔掩衄虴?离??0?
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT8_ClrPortBits(unsigned int ui32Data)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;

	l_temp=ui32Data;

	for(i=0;i<4;i++)
	{
	  l_data=(l_data&0x0)+(0x0<<LCDIO_DO)+((l_temp&0x1)<<LCDIO_DO_MASK);
	  l_temp=l_temp>>1;
	  l_data=(0x0<<(LCDIO_DO+16))+((l_temp&0x1)<<(LCDIO_DO_MASK+16))+l_data;
	  l_temp=l_temp>>1;
	  l_reg=GPIO_PT8+i*0x04;
	  outw(l_reg,l_data);
	}

}


//****************************************************************************
/*****************************************************************************
 ****************************  PT9 IO function     ****************************
 *****************************************************************************/
/****************************************************************************
 * name    : DrvGPIO_PT9_EnableINPUT(short int ubit)
 * function: enable the PT9 pin input mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT9_EnableINPUT(short int ubit)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;
	l_temp=ubit;
	for(i=0;i<4;i++)
	{
		l_data=(l_data&0x0)+((l_temp&0x1)<<LCDIO_IN)+((l_temp&0x01)<<LCDIO_IN_MASK);
		l_temp=l_temp>>1;
		l_data=((l_temp&0x1)<<(LCDIO_IN+16))+((l_temp&0x01)<<(LCDIO_IN_MASK+16))+l_data;
		l_temp=l_temp>>1;
		l_reg=GPIO_PT9+i*0x04;
		outw(l_reg,l_data);
	}
}

/****************************************************************************
 * name    : DrvGPIO_PT9_DisableINPUT(short int ubit)
 * function: disable the PT9 pin input mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT9_DisableINPUT(short int ubit)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;
	l_temp=ubit;
	for(i=0;i<4;i++)
	{
		l_data=(l_data&0x0)+(0x0<<LCDIO_IN)+((l_temp&0x01)<<LCDIO_IN_MASK);
		l_temp=l_temp>>1;
		l_data=(0x0<<(LCDIO_IN+16))+((l_temp&0x01)<<(LCDIO_IN_MASK+16))+l_data;
		l_temp=l_temp>>1;
		l_reg=GPIO_PT9+i*0x04;
		outw(l_reg,l_data);
	}
}

/****************************************************************************
 * name    : DrvGPIO_PT9_EnableOUTPUT(short int ubit)
 * function: enable the PT9 pin output mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT9_EnableOUTPUT(short int ubit)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;
	l_temp=ubit;
	for(i=0;i<4;i++)
	{
		l_data=(l_data&0x0)+((l_temp&0x1)<<LCDIO_OUT)+((l_temp&0x01)<<LCDIO_OUT_MASK);
		l_temp=l_temp>>1;
		l_data=((l_temp&0x1)<<(LCDIO_OUT+16))+((l_temp&0x01)<<(LCDIO_OUT_MASK+16))+l_data;
		l_temp=l_temp>>1;
		l_reg=GPIO_PT9+i*0x04;
		outw(l_reg,l_data);
	}

}

/****************************************************************************
 * name    : DrvGPIO_PT9_DisableOUTPUT(short int ubit)
 * function: disable the PT9 pin output mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT9_DisableOUTPUT(short int ubit)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;

	l_temp=ubit;

	for(i=0;i<4;i++)
	{
		l_data=(l_data&0x0)+(0x0<<LCDIO_OUT)+((l_temp&0x01)<<LCDIO_OUT_MASK);
		l_temp=l_temp>>1;
		l_data=(0x0<<(LCDIO_OUT+16))+((l_temp&0x01)<<(LCDIO_OUT_MASK+16))+l_data;
		l_temp=l_temp>>1;
		l_reg=GPIO_PT9+i*0x04;
		outw(l_reg,l_data);
	}

}

/****************************************************************************
 * name    : DrvGPIO_PT9_GetPortBits (void)
 * function: read PT9 ??袨??
 * input   : NO
 * output  : 殿?PT3 PORT ??袨??
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
unsigned char DrvGPIO_PT9_GetPortBits(void)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;

	l_data=0x00000000;
	for(i=4;i>0;i--)
	{
	l_reg=GPIO_PT9+(i-1)*0x04;
	l_temp=inw(l_reg);
	l_data=l_data<<1;
	l_data=((l_temp>>(LCDIO_DI+16))&0X01)+l_data;
	l_data=l_data<<1;
	l_data=((l_temp>>(LCDIO_DI))&0X01)+l_data;
	}
	return l_data&0xff;
}

/****************************************************************************
 * name    : DrvGPIO_PT9_SetPortBits (unsigned char ui32Data)
 * function: setting PT9 ?茼褐???1?
 * input   : ui32Data:0~0xff,?茼弇?1?符夔掩衄虴?离??1?
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT9_SetPortBits(unsigned char ui32Data)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;

	l_temp=ui32Data;

	for(i=0;i<4;i++)
	{
	l_data=(l_data&0x0)+(0x01<<LCDIO_DO)+((l_temp&0x1)<<LCDIO_DO_MASK);
	l_temp=l_temp>>1;
	l_data=(0x01<<(LCDIO_DO+16))+((l_temp&0x1)<<(LCDIO_DO_MASK+16))+l_data;
	l_temp=l_temp>>1;
	l_reg=GPIO_PT9+i*0x04;
	outw(l_reg,l_data);
	}
}

/****************************************************************************
 * name    : DrvGPIO_PT9_ClrPortBits (unsigned int ui32Data)
 * function: setting PT9 ?茼褐???0?
 * input   : ui32Data:0~0xff,?茼弇?1?符夔掩衄虴?离??0?
 * output  : NO
 * date    : 2015-2-6
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT9_ClrPortBits(unsigned int ui32Data)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;

	l_temp=ui32Data;

	for(i=0;i<4;i++)
	{
	  l_data=(l_data&0x0)+(0x0<<LCDIO_DO)+((l_temp&0x1)<<LCDIO_DO_MASK);
	  l_temp=l_temp>>1;
	  l_data=(0x0<<(LCDIO_DO+16))+((l_temp&0x1)<<(LCDIO_DO_MASK+16))+l_data;
	  l_temp=l_temp>>1;
	  l_reg=GPIO_PT9+i*0x04;
	  outw(l_reg,l_data);
	}

}

/****************************************************************************
****************************  PT13 IO function     **************************
/****************************************************************************
 * name    : DrvGPIO_PT13_EnableINPUT(short int ubit)
 * function: enable the PT13 pin input mode
 * input   : ubit:0~0xff
 * output  : NO
 * date    : 2018-3-2
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT13_EnableINPUT(short int ubit)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;
	l_temp=ubit;
	for(i=0;i<4;i++)
	{
		l_data=(l_data&0x0)+((l_temp&0x1)<<LCDIO_IN)+((l_temp&0x01)<<LCDIO_IN_MASK);
		l_temp=l_temp>>1;
		l_data=((l_temp&0x1)<<(LCDIO_IN+16))+((l_temp&0x01)<<(LCDIO_IN_MASK+16))+l_data;
		l_temp=l_temp>>1;
		l_reg=GPIO_PT13+i*0x04;
		outw(l_reg,l_data);
	}
}

/****************************************************************************
 * name    : DrvGPIO_PT13_DisableINPUT(short int ubit)
 * function: disable the PT13 pin input mode
 * input   : ubit:0~0xff,
 * output  : NO
 * date    : 2018-3-2
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT13_DisableINPUT(short int ubit)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;
	l_temp=ubit;
	for(i=0;i<4;i++)
	{
		l_data=(l_data&0x0)+(0x0<<LCDIO_IN)+((l_temp&0x01)<<LCDIO_IN_MASK);
		l_temp=l_temp>>1;
		l_data=(0x0<<(LCDIO_IN+16))+((l_temp&0x01)<<(LCDIO_IN_MASK+16))+l_data;
		l_temp=l_temp>>1;
		l_reg=GPIO_PT13+i*0x04;
		outw(l_reg,l_data);
	}
}

/****************************************************************************
 * name    : DrvGPIO_PT13_EnableOUTPUT(short int ubit)
 * function: enable the PT13 pin output mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2018-3-2
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT13_EnableOUTPUT(short int ubit)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;
	l_temp=ubit;
	for(i=0;i<4;i++)
	{
		l_data=(l_data&0x0)+((l_temp&0x1)<<LCDIO_OUT)+((l_temp&0x01)<<LCDIO_OUT_MASK);
		l_temp=l_temp>>1;
		l_data=((l_temp&0x1)<<(LCDIO_OUT+16))+((l_temp&0x01)<<(LCDIO_OUT_MASK+16))+l_data;
		l_temp=l_temp>>1;
		l_reg=GPIO_PT13+i*0x04;
		outw(l_reg,l_data);
	}
}

/****************************************************************************
 * name    : DrvGPIO_PT13_DisableOUTPUT(short int ubit)
 * function: disable the PT13 pin output mode
 * input   : ubit:0~0xff,?茼?bit??符夔掩衄虴?离
 * output  : NO
 * date    : 2018-3-2
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT13_DisableOUTPUT(short int ubit)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;

	l_temp=ubit;

	for(i=0;i<4;i++)
	{
		l_data=(l_data&0x0)+(0x0<<LCDIO_OUT)+((l_temp&0x01)<<LCDIO_OUT_MASK);
		l_temp=l_temp>>1;
		l_data=(0x0<<(LCDIO_OUT+16))+((l_temp&0x01)<<(LCDIO_OUT_MASK+16))+l_data;
		l_temp=l_temp>>1;
		l_reg=GPIO_PT13+i*0x04;
		outw(l_reg,l_data);
	}
}

/****************************************************************************
 * name    : DrvGPIO_PT13_GetPortBits (void)
 * function: read PT13 ??袨??
 * input   : NO
 * output  : 
 * date    : 2018-3-2
 * modify  : no
 ****************************************************************************/
unsigned char DrvGPIO_PT13_GetPortBits(void)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;

	l_data=0x00000000;
	for(i=4;i>0;i--)
	{
	l_reg=GPIO_PT13+(i-1)*0x04;
	l_temp=inw(l_reg);
	l_data=l_data<<1;
	l_data=((l_temp>>(LCDIO_DI+16))&0X01)+l_data;
	l_data=l_data<<1;
	l_data=((l_temp>>(LCDIO_DI))&0X01)+l_data;
	}
	return l_data&0xff;
}

/****************************************************************************
 * name    : DrvGPIO_PT13_SetPortBits (unsigned char ui32Data)
 * function: setting PT13 ?茼褐???1?
 * input   : ui32Data:0~0xff,?茼弇?1?符夔掩衄虴?离??1?
 * output  : NO
 * date    : 2018-3-2
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT13_SetPortBits(unsigned char ui32Data)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;

	l_temp=ui32Data;

	for(i=0;i<4;i++)
	{
	l_data=(l_data&0x0)+(0x01<<LCDIO_DO)+((l_temp&0x1)<<LCDIO_DO_MASK);
	l_temp=l_temp>>1;
	l_data=(0x01<<(LCDIO_DO+16))+((l_temp&0x1)<<(LCDIO_DO_MASK+16))+l_data;
	l_temp=l_temp>>1;
	l_reg=GPIO_PT13+i*0x04;
	outw(l_reg,l_data);
	}
}

/****************************************************************************
 * name    : DrvGPIO_PT13_ClrPortBits (unsigned int ui32Data)
 * function: setting PT13 ?茼褐???0?
 * input   : ui32Data:0~0xff,?茼弇?1?符夔掩衄虴?离??0?
 * output  : NO
 * date    : 2018-3-2
 * modify  : no
 ****************************************************************************/
void DrvGPIO_PT13_ClrPortBits(unsigned int ui32Data)
{
	unsigned int l_reg,l_data,l_temp;
	unsigned char i;

	l_temp=ui32Data;

	for(i=0;i<4;i++)
	{
	  l_data=(l_data&0x0)+(0x0<<LCDIO_DO)+((l_temp&0x1)<<LCDIO_DO_MASK);
	  l_temp=l_temp>>1;
	  l_data=(0x0<<(LCDIO_DO+16))+((l_temp&0x1)<<(LCDIO_DO_MASK+16))+l_data;
	  l_temp=l_temp>>1;
	  l_reg=GPIO_PT13+i*0x04;
	  outw(l_reg,l_data);
	}
}

/**********************************************************************************************
 *name    : DrvGPIO_PortIDIF
 *function: read the PORT interrupt trigger mode, the flag of IO PIN input status
 *input   : port: IO PORT : PT1/PT2
 *output  : the PORT OF IO PIN INPUT STATUS
 *version : V0.1
 *date    : 2016-03-04
 *note    : ONLY FOR THE CORRESPONSD PORT WITH INTERRUPT MODE  PT1/PT2
 *modify  2016/7/12.
 *modify  DrvGPIO_PortIDIF : Remove "l_reg,l_data,ReturnVal;" and "if (port==1) {l_reg=PT1_BASE+0X0C;}" by Robert
 ***********************************************************************************************/
unsigned int DrvGPIO_PortIDIF(uint32_t port)
{
  uint32_t l_reg;
  if (port==3) {l_reg=PT3_BASE+0X0C;}
  else if (port==2) {l_reg=PT2_BASE+0X0C;}
  return (inw(l_reg)>>24);
}