/*
 * DrvFlash.c
 *
 *  Created on: 2014-7-29
 *      Author: Administrator
 */
#include "DrvFlash.h"
/*******************************************************************
*name    : DrvFlash_Burn_Word
*function: write one word data to flash
*input   : u32addr: flash address;
*          u32data: 32bit data
*          u32DelayTime: delay time
*output  : 
*Version : v1.0
*date    : 2014-8-25
*modify  : 
*********************************************************************/
int DrvFlash_Burn_Word (unsigned int u32addr,

                       unsigned int u32DelayTime,

                       unsigned int u32data)

{
  int Buffer[32];
  if((u32addr&0xFFFF0000)!=0)         //ДǷ^
    return 1;
  if((u32addr&0x03)!=0)
    return 2;
  ReadPage(u32addr&0xFF80,Buffer);           //xȡָλַą^΃ȵYBuffer

  Buffer[(u32addr&0x7C)>>2]=u32data;         //޸BufferY

  ROM_BurnPage(FLASH_KEY_A,u32addr&0xFF80,u32DelayTime,Buffer);
  return 0;
}
/*******************************************************************
*name    : ReadWord(unsigned int addr
*function: get one word data from flash
*input   : addr:  flash address;
*output  : the data 
*Version : v1.0
*date    : 
*modify  : 
*********************************************************************/
int ReadWord(unsigned int addr)
{
	if((addr%4)!=0)
		return E_FAIL;
	return (*(unsigned int *)(0x90000+addr));
}
/*******************************************************************
*name    : ReadPage(unsigned int addr,int* data)
*function: get 32word(128byte)data from flash
*input   : addr: start address at flash;
*          *data: the array to save the data total 32word
*output  : 0/1;
*Version : v
*date    : 
*modify  : 
*********************************************************************/
int ReadPage(unsigned int addr,unsigned int *data)
{
	volatile unsigned char i;
	if((addr%128)!=0)
		return E_FAIL;
	for(i=0;i<32;i++)
	{
		*(data+i)=*((unsigned int *)(0x90000+addr+i*4));
	}
	return E_SUCCESS;
}
