/*
 * DrvDAC.h
 *
 *  Created on: 2016/08/15
 *  Author: Robert.Wang
 *  Version : V0.0, 2016/08/15
 *  
 */

#ifndef DRVDAC_H_
#define DRVDAC_H_
#include "HY16F3981.h"

#ifndef E_FAIL
#define E_FAIL		1
#endif
#define E_DRVDAC_ARGUMENT E_FAIL

#ifndef E_SUCCESS
#define E_SUCCESS		0
#endif

/*
typedef enum
{
	E_DAC_VDD3V = 0,
	E_DAC_VSSA  =0,
	E_DAC_VDDA  =1,
	E_DAC_OPO   =1,
	E_DAC_REFO_I  =2,
	E_DAC_AIO6  =3,
	E_DAC_AIO7  =3
} E_DAC_INPUT;// */

/*//HY16F198
typedef enum
{
	E_DAC_PVDD3V =0,
	E_DAC_PVDDA  =1,
	E_DAC_PREFO_I  =2,
	E_DAC_POPO   =3,
	E_DAC_PAIO4  =4,
	E_DAC_PAIO5  =5,
	E_DAC_PAIO6  =6,
	E_DAC_PAIO7  =7
} E_DAC_PINPUT; */

//HY16F3981
typedef enum
{
	E_DAC_PVDDA =0,
	E_DAC_PVDD18  =1,
	E_DAC_PREFO_I  =2,
	E_DAC_POPO   =3,
	E_DAC_PAIO4  =4,
	E_DAC_PAIO5  =5,
	E_DAC_PAIO6  =6,
	E_DAC_PAIO7  =7
} E_DAC_PINPUT;

typedef enum
{
	E_DAC_NVSSA  =0,
	E_DAC_NREFO  =1,
	E_DAC_NOPO   =2,
	E_DAC_NAIO7  =3
}E_DAC_NINPUT;

#ifdef  DAC_BASE
#define R_DAC_CTRL1  (DAC_BASE+OFFSET00)
#define R_DAC_CTRL2  (DAC_BASE+OFFSET04)
#define PT3_28       0X40828

#endif


//#define DAPS    			4  //HY16F198, //Robert add 2016/7/20
//#define DANS    			2  //HY16F198, //Robert add 2016/7/20
#define DAPS    			16  //HY16F3981, //Robert add 2017/4/7
#define DANS    			24  //HY16F3981, //Robert add 2017/4/7
#define DAOE    			1
#define ENDA    			0
#define DAPS_MASK  			(DAPS+MASK)
#define DANS_MASK  			(DANS+MASK)
#define DAOE_MASK 			(DAOE+MASK)
#define ENDA_MASK  			(ENDA+MASK)
//#define DAPS_MAX   			7 //HY16F198, //Robert add 2016/7/20
//#define DANS_MAX   			3 //HY16F198, //Robert add 2016/7/20
#define DAPS_MAX   			19 //HY16F3981, //Robert add 2017/4/7
#define DANS_MAX   			26 //HY16F3981, //Robert add 2017/4/7

#define DABIT    			0
//#define DABIT_MAX   		255  //HY16F198, Robert add 2016/7/20
#define DABIT_MAX   		4095  //HY16F3981, Robert add 2016/7/20

unsigned int DrvDAC_Open(unsigned int uPinput ,unsigned int uNinput,unsigned int uDAO);
void DrvDAC_Close(void);
void DrvDAC_Enable(void);
void DrvDAC_Disable(void);
void DrvDAC_EnableOutput(void);
void DrvDAC_DisableOutput(void);
unsigned int DrvDAC_Pinput(unsigned int uPinput);
unsigned int DrvDAC_Ninput(unsigned int uNinput);
unsigned int DrvDAC_DABIT(unsigned int uDABIT);
//unsigned int DrvDAC_SetoutputIO(unsigned int uio);
unsigned char DrvDAC_DALH(unsigned char uDALH);

#endif /* DRVDAC_H_ */
