/*
 *  Created on: 2016/7/28
 *  Author: Robert.Wang
 *  Memo : HY16F3981 DrvDAC.c is base on HY16F198B to modify
*/

#include "DrvDAC.h"
#include "SpecialMacro.h"
/*******************************************************************
*name    : DrvDAC_Open()
*function: enable DAC and setting input IO and set DAO value
*input   : upinput/uninput/uDAO
*output  : 0/others
*Version : v1.0
*date    : 2017-4-7
*modify  : Integrate DAC compensator function
*********************************************************************/
unsigned int DrvDAC_Open(unsigned int uPinput ,unsigned int uNinput,unsigned int uDAO)
{
	unsigned int l_reg,l_data,ReturnVal;
	unsigned int DADCS_Enable_set=0x0808,  DADCS_Disable_set=0x0800;
	ReturnVal=0;
	if(uPinput>7){return E_DRVDAC_ARGUMENT;}
	else
	{
		l_data=(uPinput<<DAPS);
	}
	if(uNinput>3){return E_DRVDAC_ARGUMENT;}
	else
	{
		l_data|=(uNinput<<DANS);
	}
	l_data|=((1<<DAOE)|(1<<DAOE_MASK)|(1<<ENDA)|(1<<ENDA_MASK));
	l_reg=R_DAC_CTRL1;
	outw(l_reg,l_data);

	if(uDAO>DABIT_MAX)
	{
	    return E_DRVDAC_ARGUMENT;
	}

	if(uDAO >= 2114)
	{
		if(uDAO >=2961)
		{
			if(uDAO >= 2987)
			{
				if(uDAO >= 3138)
				{
				    l_data=uDAO;
				    l_reg=R_DAC_CTRL2;
	                outw(l_reg,l_data);			   // 3138 ~ 4095
	                l_reg=R_DAC_CTRL1;
	                l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Disable_set;
	                outw(l_reg,l_data);
					//R_DAC_CTRL2 = uDAO;        // 3138 ~ 4095
					//R_DAC_CTRL1 = DADCS_Disable_set;
				}
				else
				{
				    l_data=uDAO-1;
				    l_reg=R_DAC_CTRL2;
	                outw(l_reg,l_data);			   // 2987 ~ 3137
	                l_reg=R_DAC_CTRL1;
	                l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Enable_set;
	                outw(l_reg,l_data);
					//R_DAC_CTRL2 = uDAO-1;      // 2987 ~ 3137
					//R_DAC_CTRL1 = DADCS_Enable_set;
				}
			}
			else
			{
			    l_data=uDAO-1;
				l_reg=R_DAC_CTRL2;
	            outw(l_reg,l_data);			       // 2961 ~ 2986
	            l_reg=R_DAC_CTRL1;
	            l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Disable_set;
	            outw(l_reg,l_data);
				//R_DAC_CTRL2 = uDAO-1;          // 2961 ~ 2986
				//R_DAC_CTRL1 = DADCS_Disable_set;
			}
		}
		else // <2961
		{
			if(uDAO >= 2890)
			{
				if(uDAO >= 2955)
				{

				    l_data=uDAO-1;
				    l_reg=R_DAC_CTRL2;
	                outw(l_reg,l_data);			        // 2955 ~ 2960
	                l_reg=R_DAC_CTRL1;
	                l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Enable_set;
	                outw(l_reg,l_data);
					//R_DAC_CTRL2 = uDAO-1;           // 2955 ~ 2960
					//R_DAC_CTRL1 = DADCS_Enable_set;
				}
				else
				{
				    l_data=uDAO-1;
				    l_reg=R_DAC_CTRL2;
	                outw(l_reg,l_data);			         // 2890 ~ 2954
	                l_reg=R_DAC_CTRL1;
	                l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Disable_set;
	                outw(l_reg,l_data);
					//R_DAC_CTRL2 = uDAO-1;             // 2890 ~ 2954
					//R_DAC_CTRL1 = DADCS_Disable_set;
				}
			}
			else
			{
			    l_data=uDAO-2;
				l_reg=R_DAC_CTRL2;
	            outw(l_reg,l_data);			           // 2114 ~ 2889
	            l_reg=R_DAC_CTRL1;
	            l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Enable_set;
	            outw(l_reg,l_data);
				//R_DAC_CTRL2 = uDAO-2;              // 2114 ~ 2889
				//R_DAC_CTRL1 = DADCS_Enable_set;
			}
		}
	}

	else // < 2114
	{
		if(uDAO >=  1486)
		{
			if(uDAO >= 1504)
			{
				if(uDAO >= 2112)
				{
					if(uDAO == 2113)
					{
					    l_data=uDAO-1;
				        l_reg=R_DAC_CTRL2;
	                    outw(l_reg,l_data);			   // 2113
	                    l_reg=R_DAC_CTRL1;
	                    l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Disable_set;
	                    outw(l_reg,l_data);
						//R_DAC_CTRL2 = uDAO-1;      // 2113
						//R_DAC_CTRL1 = DADCS_Disable_set;
					}
					else
					{
					    l_data=uDAO-1;
				        l_reg=R_DAC_CTRL2;
	                    outw(l_reg,l_data);			   // 2112
	                    l_reg=R_DAC_CTRL1;
	                    l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Enable_set;
	                    outw(l_reg,l_data);
						//R_DAC_CTRL2 = uDAO-1;       // 2112
						//R_DAC_CTRL1 = DADCS_Enable_set;
					}
				}
				else // <2112
				{
				    l_data=uDAO;
				    l_reg=R_DAC_CTRL2;
	                outw(l_reg,l_data);			   // 1504 ~ 2111
	                l_reg=R_DAC_CTRL1;
	                l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Disable_set;
	                outw(l_reg,l_data);
					//R_DAC_CTRL2 = uDAO;        // 1504 ~ 2111
					//R_DAC_CTRL1 = DADCS_Disable_set;
				}
			}
			else // <1504
			{
				if(uDAO >= 1488)
				{
					if(uDAO >= 1501)
					{
					    l_data=uDAO;
				        l_reg=R_DAC_CTRL2;
	                    outw(l_reg,l_data);			   // 1501 ~ 1503
	                    l_reg=R_DAC_CTRL1;
	                    l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Enable_set;
	                    outw(l_reg,l_data);
						//R_DAC_CTRL2 = uDAO;         // 1501 ~ 1503
						//R_DAC_CTRL1 = DADCS_Enable_set;
					}
					else // <1501
					{
						l_data=uDAO;
				        l_reg=R_DAC_CTRL2;
	                    outw(l_reg,l_data);			   // 1488 ~ 1500
	                    l_reg=R_DAC_CTRL1;
	                    l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Disable_set;
	                    outw(l_reg,l_data);
						//R_DAC_CTRL2 = uDAO;        // 1488 ~ 1500
						//R_DAC_CTRL1 = DADCS_Disable_set;
					}
				}
				else // <1488
				{
					l_data=uDAO;
				    l_reg=R_DAC_CTRL2;
	                outw(l_reg,l_data);			   // 1486 ~ 1487
	                l_reg=R_DAC_CTRL1;
	            	l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Enable_set;
	                outw(l_reg,l_data);
					//R_DAC_CTRL2 = uDAO;        // 1486 ~ 1487
					//R_DAC_CTRL1 = DADCS_Enable_set;
				}
			}
		}
		else // < 1486
		{
			if(uDAO >= 965)
			{
				if(uDAO >= 1441)
				{
					l_data=uDAO;
				    l_reg=R_DAC_CTRL2;
	                outw(l_reg,l_data);			   // 1441 ~ 1485
	                l_reg=R_DAC_CTRL1;
	                l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Disable_set;
	                outw(l_reg,l_data);
					//R_DAC_CTRL2 = uDAO;        // 1441 ~ 1485
					//R_DAC_CTRL1 = DADCS_Disable_set;
				}
				else // <1441
				{
					if(uDAO == 1440)
					{
						l_data=uDAO;
				        l_reg=R_DAC_CTRL2;
	                    outw(l_reg,l_data);			   // 1440
	                    l_reg=R_DAC_CTRL1;
	     	            l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Enable_set;
	                    outw(l_reg,l_data);
						//R_DAC_CTRL2 = uDAO;        // 1440
						//R_DAC_CTRL1 = DADCS_Enable_set;
					}
					else
					{
						l_data=uDAO+1;
				        l_reg=R_DAC_CTRL2;
	                    outw(l_reg,l_data);			   // 965 ~ 1439
	                    l_reg=R_DAC_CTRL1;
	                    l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Disable_set;
	                    outw(l_reg,l_data);
						//R_DAC_CTRL2 = uDAO+1;      // 965 ~ 1439
						//R_DAC_CTRL1 = DADCS_Disable_set;
					}

				}
			}
			else // <965
			{
				if(uDAO >= 888)
				{
					l_data=uDAO;
				    l_reg=R_DAC_CTRL2;
	                outw(l_reg,l_data);			       // 888 ~ 964
	                l_reg=R_DAC_CTRL1;
	                l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Enable_set;
	                outw(l_reg,l_data);
					//R_DAC_CTRL2 = uDAO;            // 888 ~ 964
					//R_DAC_CTRL1 = DADCS_Enable_set;
				}
				else
				{
				    l_data=uDAO;
				    l_reg=R_DAC_CTRL2;
	                outw(l_reg,l_data);			       // 0 ~ 887
	                l_reg=R_DAC_CTRL1;
	                l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Disable_set;
	                outw(l_reg,l_data);
					//R_DAC_CTRL2 = uDAO;            // 0 ~ 887
					//R_DAC_CTRL1 = DADCS_Disable_set;
				}
			}
		}
	}

	return ReturnVal;
}

void DrvDAC_Close(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_DAC_CTRL1;
	l_data=(inw(l_reg)&0x0F0F0000)|(1<<DAOE_MASK)|(1<<(ENDA_MASK));
	outw(l_reg,l_data);
}

void DrvDAC_Enable(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_DAC_CTRL1;
	l_data=(inw(l_reg)&0x0F0F0000)|(1<<ENDA)|(1<<(ENDA_MASK));
	outw(l_reg,l_data);
}

void DrvDAC_Disable(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_DAC_CTRL1;
	l_data=(inw(l_reg)&0x0F0F0000)|(1<<(ENDA_MASK));
	outw(l_reg,l_data);
}

void DrvDAC_EnableOutput(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_DAC_CTRL1;
	l_data=(inw(l_reg)&0x0F0F0000)|(1<<DAOE)|(1<<(DAOE_MASK));
	outw(l_reg,l_data);
}

void DrvDAC_DisableOutput(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_DAC_CTRL1;
	l_data=(inw(l_reg)&0x0F0F0000)|(1<<(DAOE_MASK));
	outw(l_reg,l_data);
}

/*******************************************************************
*name    : DrvDAC_Pinput(unsigned int uPinput)
*function: setting DAC positive input
*input   : uPinput
*output  : 0/others
*Version : v1.1
*date    : 2017-4-7
*modify  : NO
*********************************************************************/
unsigned int DrvDAC_Pinput(unsigned int uPinput)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	if(uPinput>7){return E_DRVDAC_ARGUMENT;}
	else
	{
    l_reg=R_DAC_CTRL1;
	l_data=(inw(l_reg)&0x0F000000)|(uPinput<<DAPS);  //uNinput keep the same status, only uPinput be changed
	outw(l_reg,l_data);
	}

	return ReturnVal;
}

unsigned int DrvDAC_Ninput(unsigned int uNinput)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	if(uNinput>3){return E_DRVDAC_ARGUMENT;}
	else
	{
	l_reg=R_DAC_CTRL1;
	l_data=(inw(l_reg)&0x000F0000)|(uNinput<<DANS);  //uPinput keep the same status, only uNinput be changed
	outw(l_reg,l_data);
	}

	return ReturnVal;
}

/*******************************************************************
*name    : DrvDAC_DABIT(unsigned int uDABIT)
*function: setting DAO value for controlling the output voltage
*input   : uDABIT
*output  : 0/others
*Version : v1.1
*date    : 2017-4-7
*modify  : Integrate DAC compensator function
*********************************************************************/
unsigned int DrvDAC_DABIT(unsigned int uDABIT)
{
	unsigned int l_reg, l_data, ReturnVal;
	unsigned int DADCS_Enable_set=0x0808,  DADCS_Disable_set=0x0800;
	ReturnVal=0;

	if(uDABIT>DABIT_MAX)
	{
		return E_DRVDAC_ARGUMENT;
	}
	if(uDABIT >= 2114)
	{
		if(uDABIT >=2961)
		{
			if(uDABIT >= 2987)
			{
				if(uDABIT >= 3138)
				{
				    l_data=uDABIT;
				    l_reg=R_DAC_CTRL2;
	                outw(l_reg,l_data);			   // 3138 ~ 4095
	                l_reg=R_DAC_CTRL1;
	                l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Disable_set;
	                outw(l_reg,l_data);
					//R_DAC_CTRL2 = uDABIT;        // 3138 ~ 4095
					//R_DAC_CTRL1 = DADCS_Disable_set;
				}
				else
				{
				    l_data=uDABIT-1;
				    l_reg=R_DAC_CTRL2;
	                outw(l_reg,l_data);			   // 2987 ~ 3137
	                l_reg=R_DAC_CTRL1;
	                l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Enable_set;
	                outw(l_reg,l_data);
					//R_DAC_CTRL2 = uDABIT-1;      // 2987 ~ 3137
					//R_DAC_CTRL1 = DADCS_Enable_set;
				}
			}
			else
			{
			    l_data=uDABIT-1;
				l_reg=R_DAC_CTRL2;
	            outw(l_reg,l_data);			       // 2961 ~ 2986
	            l_reg=R_DAC_CTRL1;
	            l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Disable_set;
	            outw(l_reg,l_data);
				//R_DAC_CTRL2 = uDABIT-1;          // 2961 ~ 2986
				//R_DAC_CTRL1 = DADCS_Disable_set;
			}
		}
		else // <2961
		{
			if(uDABIT >= 2890)
			{
				if(uDABIT >= 2955)
				{

				    l_data=uDABIT-1;
				    l_reg=R_DAC_CTRL2;
	                outw(l_reg,l_data);			        // 2955 ~ 2960
	                l_reg=R_DAC_CTRL1;
	                l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Enable_set;
	                outw(l_reg,l_data);
					//R_DAC_CTRL2 = uDABIT-1;           // 2955 ~ 2960
					//R_DAC_CTRL1 = DADCS_Enable_set;
				}
				else
				{
				    l_data=uDABIT-1;
				    l_reg=R_DAC_CTRL2;
	                outw(l_reg,l_data);			         // 2890 ~ 2954
	                l_reg=R_DAC_CTRL1;
	                l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Disable_set;
	                outw(l_reg,l_data);
					//R_DAC_CTRL2 = uDABIT-1;             // 2890 ~ 2954
					//R_DAC_CTRL1 = DADCS_Disable_set;
				}
			}
			else
			{
			    l_data=uDABIT-2;
				l_reg=R_DAC_CTRL2;
	            outw(l_reg,l_data);			           // 2114 ~ 2889
	            l_reg=R_DAC_CTRL1;
	            l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Enable_set;
	            outw(l_reg,l_data);
				//R_DAC_CTRL2 = uDABIT-2;              // 2114 ~ 2889
				//R_DAC_CTRL1 = DADCS_Enable_set;
			}
		}
	}
	else // < 2114
	{
		if(uDABIT >=  1486)
		{
			if(uDABIT >= 1504)
			{
				if(uDABIT >= 2112)
				{
					if(uDABIT == 2113)
					{
					    l_data=uDABIT-1;
				        l_reg=R_DAC_CTRL2;
	                    outw(l_reg,l_data);			   // 2113
	                    l_reg=R_DAC_CTRL1;
	                    l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Disable_set;
	                    outw(l_reg,l_data);
						//R_DAC_CTRL2 = uDABIT-1;      // 2113
						//R_DAC_CTRL1 = DADCS_Disable_set;
					}
					else
					{
					    l_data=uDABIT-1;
				        l_reg=R_DAC_CTRL2;
	                    outw(l_reg,l_data);			   // 2112
	                    l_reg=R_DAC_CTRL1;
	                    l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Enable_set;
	                    outw(l_reg,l_data);
						//R_DAC_CTRL2 = uDABIT-1;       // 2112
						//R_DAC_CTRL1 = DADCS_Enable_set;
					}
				}
				else // <2112
				{
				    l_data=uDABIT;
				    l_reg=R_DAC_CTRL2;
	                outw(l_reg,l_data);			   // 1504 ~ 2111
	                l_reg=R_DAC_CTRL1;
	                l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Disable_set;
	                outw(l_reg,l_data);
					//R_DAC_CTRL2 = uDABIT;        // 1504 ~ 2111
					//R_DAC_CTRL1 = DADCS_Disable_set;
				}
			}
			else // <1504
			{
				if(uDABIT >= 1488)
				{
					if(uDABIT >= 1501)
					{
					    l_data=uDABIT;
				        l_reg=R_DAC_CTRL2;
	                    outw(l_reg,l_data);			   // 1501 ~ 1503
	                    l_reg=R_DAC_CTRL1;
	                    l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Enable_set;
	                    outw(l_reg,l_data);
						//R_DAC_CTRL2 = uDABIT;         // 1501 ~ 1503
						//R_DAC_CTRL1 = DADCS_Enable_set;
					}
					else // <1501
					{
						l_data=uDABIT;
				        l_reg=R_DAC_CTRL2;
	                    outw(l_reg,l_data);			   // 1488 ~ 1500
	                    l_reg=R_DAC_CTRL1;
	                    l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Disable_set;
	                    outw(l_reg,l_data);
						//R_DAC_CTRL2 = uDABIT;        // 1488 ~ 1500
						//R_DAC_CTRL1 = DADCS_Disable_set;
					}
				}
				else // <1488
				{
					l_data=uDABIT;
				    l_reg=R_DAC_CTRL2;
	                outw(l_reg,l_data);			   // 1486 ~ 1487
	                l_reg=R_DAC_CTRL1;
	                l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Enable_set;
	                outw(l_reg,l_data);
					//R_DAC_CTRL2 = uDABIT;        // 1486 ~ 1487
					//R_DAC_CTRL1 = DADCS_Enable_set;
				}
			}
		}
		else // < 1486
		{
			if(uDABIT >= 965)
			{
				if(uDABIT >= 1441)
				{
					l_data=uDABIT;
				    l_reg=R_DAC_CTRL2;
	                outw(l_reg,l_data);			   // 1441 ~ 1485
	                l_reg=R_DAC_CTRL1;
	                l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Disable_set;
	                outw(l_reg,l_data);
					//R_DAC_CTRL2 = uDABIT;        // 1441 ~ 1485
					//R_DAC_CTRL1 = DADCS_Disable_set;
				}
				else // <1441
				{
					if(uDABIT == 1440)
					{
						l_data=uDABIT;
				        l_reg=R_DAC_CTRL2;
	                    outw(l_reg,l_data);			   // 1440
	                    l_reg=R_DAC_CTRL1;
	                    l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Enable_set;
	                    outw(l_reg,l_data);
						//R_DAC_CTRL2 = uDABIT;        // 1440
						//R_DAC_CTRL1 = DADCS_Enable_set;
					}
					else
					{
						l_data=uDABIT+1;
				        l_reg=R_DAC_CTRL2;
	                    outw(l_reg,l_data);			   // 965 ~ 1439
	                    l_reg=R_DAC_CTRL1;
	                    l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Disable_set;
	                    outw(l_reg,l_data);
						//R_DAC_CTRL2 = uDABIT+1;      // 965 ~ 1439
						//R_DAC_CTRL1 = DADCS_Disable_set;
					}

				}
			}
			else // <965
			{
				if(uDABIT >= 888)
				{
					l_data=uDABIT;
				    l_reg=R_DAC_CTRL2;
	                outw(l_reg,l_data);			       // 888 ~ 964
	                l_reg=R_DAC_CTRL1;
	                l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Enable_set;
	                outw(l_reg,l_data);
					//R_DAC_CTRL2 = uDABIT;            // 888 ~ 964
					//R_DAC_CTRL1 = DADCS_Enable_set;
				}
				else
				{
				    l_data=uDABIT;
				    l_reg=R_DAC_CTRL2;
	                outw(l_reg,l_data);			       // 0 ~ 887
	                l_reg=R_DAC_CTRL1;
	                l_data=(inw(l_reg)&0x0F0F0000)|DADCS_Disable_set;
	                outw(l_reg,l_data);
					//R_DAC_CTRL2 = uDABIT;            // 0 ~ 887
					//R_DAC_CTRL1 = DADCS_Disable_set;
				}
			}
		}
	}

	return ReturnVal;
}

unsigned char DrvDAC_DALH(unsigned char uDALH)
{
	unsigned int l_reg,l_data;
	l_reg=R_DAC_CTRL1;
	if(uDALH<(0x1+1))
		{
		    l_data=(inw(l_reg)&0x0F0F0400)|(uDALH<<2)|(1<<(2+8)); //set 0x41700[2]=xb
			outw(l_reg,l_data);
			return E_SUCCESS;
		}
	else return E_FAIL ;
}

