/*
 * DrvClock.h
 *
 *  Created on: 2016/08/15
 *  Author: Robert.Wang
 *  Version : V0.0, 2016/08/15
 *  
 */

#ifndef DRVCLOCK_H_
#define DRVCLOCK_H_

#include "HY16F3981.h"

#ifndef E_FAIL
#define E_FAIL		1
#endif
#define E_DRVCLOCK_ARGUMENT E_FAIL

#ifndef E_SUCCESS
#define E_SUCCESS		0
#endif

typedef enum
{
	E_INTERNAL = 0,
	E_EXTERNAL  = 1
} E_CLOCK_SOURCE;

typedef enum
{
	TRIM_HAO2MHZ= 0,
	TRIM_HAO4MHZ,
	TRIM_HAO10MHZ,
	TRIM_HAO16MHZ
} E_TRIM_FREQUEN;

#ifdef  CLOCK_BASE
#define R_CLOCK_CTRL1 (CLOCK_BASE+OFFSET00)
#define R_CLOCK_TRIM  (CLOCK_BASE+OFFSET04)
#define R_CLOCK_CTRL2 (CLOCK_BASE+OFFSET08)

#define Trim_HAO_2MHZ 0X42714
#endif

#define LSel    			6
#define HSel    			5
#define HAMO    			3
#define ENOLS    			2
#define ENOHS    			1
#define ENHAO    			0
#define LSel_MASK  			(LSel+MASK)
#define HSel_MASK  			(HSel+MASK)
#define HAMO_MASK  			(HAMO+MASK)
#define ENOLS_MASK 			(ENOLS+MASK)
#define ENOHS_MASK 			(ENOHS+MASK)
#define ENHAO_MASK 			(ENHAO+MASK)
#define HAMO_MAX  			3

#define HAOTR  			    0
#define HAOTR_MASK		    (HAOTR+MASK)
#define HAOTR_MAX  			255

#define ENMCD    			1
#define CSel    			0
#define ENMCD_MASK 			(ENMCD+MASK)
#define CSel_MASK  			(CSel+MASK)
#define ENMCD_MAX 			1
#define CSel_MAX  			1


unsigned int DrvCLOCK_EnableHighOSC(unsigned int uSource,unsigned int delay);
void DrvCLOCK_CloseEHOSC();
void DrvCLOCK_CloseIHOSC();
unsigned int DrvCLOCK_SelectIHOSC(unsigned int uMode);
unsigned int DrvCLOCK_EnableLowOSC(unsigned int uSource,unsigned int udelay);
void DrvCLOCK_CloseELOSC();
unsigned int DrvCLOCK_SelectMCUClock(unsigned int uSource,unsigned int uDiv);
unsigned int DrvCLOCK_TrimHAO(unsigned int uTrim);
void DrvCLOCK_CalibrateHAO(short int uMHZ);
unsigned int DrvCLOCK_SelectOHS_HS(unsigned int uMode);
//2021/09/06 Robert add
void DrvCLOCK_EnableENHAO(void);
void DrvCLOCK_DisableENHAO(void);
//2021/06/20 Robert add
unsigned int DrvCLOCK_SelectIHOSC_CalHAO(unsigned int uMode);
#endif /* DRVCLOCK_H_ */
