/*
 * 
 *  Created on: 2016/7/28
 *  Author: Robert.Wang
 *  Memo : HY16F3981 DrvClock.c is base on HY16F198B to modify
*/

#include "DrvClock.h"
#include "SpecialMacro.h"
/*******************************************************************
*name    : DrvCLOCK_EnableHighOSC
*function: 
*input   : usource/ delay
*output  : 0 success /1 fail
*Version : v1.1
*date    : 2014-2-12
*modify  : 
*********************************************************************/
unsigned int DrvCLOCK_EnableHighOSC(unsigned int uSource,unsigned int delay)
{
	unsigned int l_reg,l_data,ReturnVal,x,y;
	ReturnVal=0;
	l_reg=R_CLOCK_CTRL1;
	if(uSource>1){return E_DRVCLOCK_ARGUMENT;}
	else{
		if(uSource==1)
			l_data=(1<<ENOHS)|(1<<ENOHS_MASK);
		else
			l_data=(1<<ENHAO)|(1<<ENHAO_MASK);
		outw(l_reg,l_data);
		for(x=0;x<4*delay;x++)
		{
		   for(y=0;y<1000;y++)
			   asm("nop");
		}
		if(uSource==1)
			l_data=(uSource<<HSel)|(1<<HSel_MASK)|(1<<ENHAO_MASK);
		else
			l_data=(uSource<<HSel)|(1<<HSel_MASK)|(1<<ENOHS_MASK);
	}
	outw(l_reg,l_data);
	return ReturnVal;
}

void DrvCLOCK_CloseEHOSC()
{
	unsigned int l_reg,l_data;
	l_reg=R_CLOCK_CTRL1;
	l_data=(1<<ENOHS_MASK);
	outw(l_reg,l_data);
}

void DrvCLOCK_CloseIHOSC()
{
	unsigned int l_reg,l_data;
	l_reg=R_CLOCK_CTRL1;
	l_data=(1<<ENHAO_MASK);
	outw(l_reg,l_data);
}

unsigned int DrvCLOCK_SelectIHOSC(unsigned int uMode)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=R_CLOCK_CTRL1;
	if(uMode>HAMO_MAX){return E_DRVCLOCK_ARGUMENT;}
	else{
		l_data=(uMode<<HAMO)|(HAMO_MAX<<HAMO_MASK);
	}
	outw(l_reg,l_data);
	return ReturnVal;
}
/**********************************************************************
 * Name     : DrvCLOCK_EnableLowOSC(unsigned int uSource,unsigned int udelay)
 * function : choose the low clock source and setting the delay time self
 * input    : usource/udelay
 * output   : 0 success
 *            others: fail
 * version  : v1.1
 * date     : 13-12-4
 * modify   : add input parament to control the delay time.
 *********************************************************************/
unsigned int DrvCLOCK_EnableLowOSC(unsigned int uSource,unsigned int udelay)
{
	unsigned int l_reg,l_data,ReturnVal,x;
	ReturnVal=0;
	l_reg=R_CLOCK_CTRL1;
	if(uSource>1){return E_DRVCLOCK_ARGUMENT;}
	else{
		if(uSource==1){
			l_data=(1<<ENOLS)|(1<<ENOLS_MASK);
			outw(l_reg,l_data);
			for(x=0;x<udelay;x++) //(x=0;x<1300;x++)
			{
				   asm("nop");
			}
		}
	}
	l_data=(uSource<<LSel)|(1<<LSel_MASK);
	outw(l_reg,l_data);
	return ReturnVal;
}

void DrvCLOCK_CloseELOSC()
{
	unsigned int l_reg,l_data;
	l_reg=R_CLOCK_CTRL1;
	l_data=(1<<ENOLS_MASK);
	outw(l_reg,l_data);
}

unsigned int DrvCLOCK_SelectMCUClock(unsigned int uSource,unsigned int uDiv)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=R_CLOCK_CTRL2;
	if((uSource>CSel_MAX)|(uDiv>ENMCD_MAX)){return E_DRVCLOCK_ARGUMENT;}
	else{
		l_data=(uSource<<CSel)|(CSel_MAX<<CSel_MASK)|(uDiv<<ENMCD)|(ENMCD_MAX<<ENMCD_MASK);
	}
	outw(l_reg,l_data);
	return ReturnVal;
}

unsigned int DrvCLOCK_TrimHAO(unsigned int uTrim)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=R_CLOCK_TRIM;
	if(uTrim>HAOTR_MAX){return E_DRVCLOCK_ARGUMENT;}
	else{
		l_data=(uTrim<<HAOTR)|(HAOTR_MAX<<HAOTR_MASK);
	}
	outw(l_reg,l_data);
	return ReturnVal;
}

/********************************************************************
 * name    : DrvCLOCK_CalibrateHAO(short int uMHZ)
 * function: calibrate the HAO value
 * input   : uMHZ:0--2MHZ/1--4MHZ/2--10MHZ/3---16MHZ
 * output  : no
 * date    : 2016-7-26 (Author : Robert)
 * modify  : no
 ********************************************************************/
void DrvCLOCK_CalibrateHAO(short int uMHZ)
{
  unsigned int l_reg,l_data;
  if((uMHZ<=3)&&(uMHZ>=0))
  {

	switch(uMHZ)
	{
		case 3 :
				l_data=(inw(0xd0180)&0xff000000)>>24;  //read 0xd0183, 16MHz
			break;
		case 2 :
				l_data=(inw(0xd0180)&0x00ff0000)>>16; //read 0xd0182, 10MHz
			break;
		case 1 :
				l_data=(inw(0xd0180)&0x0000ff00)>>8; //read 0xd0181, 4MHz
		  break;
	    case 0 :
				l_data=inw(0xd0180)&0x000000ff;  //read 0xd0180, 2MHz
		   break;
		default :
			break;
	}
	l_reg=R_CLOCK_TRIM;
	outw(l_reg,l_data);

  }
}




unsigned int DrvCLOCK_SelectOHS_HS(unsigned int uMode)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=R_CLOCK_CTRL1;
	if(uMode<(1+1))
	{
		l_data=(uMode<<7)|(1<<(7+8));
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVCLOCK_ARGUMENT;
	return ReturnVal;
}

//2021/09/06 Robert add
void DrvCLOCK_EnableENHAO(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_CLOCK_CTRL1;
	l_data=(1<<ENHAO)|(1<<ENHAO_MASK);
	outw(l_reg,l_data);
}

void DrvCLOCK_DisableENHAO(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_CLOCK_CTRL1;
	l_data=(1<<ENHAO_MASK);
	outw(l_reg,l_data);
}

//2021/06/20 Robert add
unsigned int DrvCLOCK_SelectIHOSC_CalHAO(unsigned int uMode)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=R_CLOCK_CTRL1;
	if(uMode>HAMO_MAX){return E_DRVCLOCK_ARGUMENT;}
	else
  {
		l_data=(uMode<<HAMO)|(HAMO_MAX<<HAMO_MASK);
	}
	outw(l_reg,l_data);
  //CalibrateHAO
  if((uMode<=3)&&(uMode>=0))
  {
	  switch(uMode)
	  {
		  case 3 :
			  l_data=(inw(0xd0180)&0xff000000)>>24;  //read 0xd0183, 16MHz
			break;
		  case 2 :
			  l_data=(inw(0xd0180)&0x00ff0000)>>16; //read 0xd0182, 10MHz
			break;
		  case 1 :
				l_data=(inw(0xd0180)&0x0000ff00)>>8; //read 0xd0181, 4MHz
		  break;
	    case 0 :
				l_data=inw(0xd0180)&0x000000ff;  //read 0xd0180, 2MHz
		  break;
		  default :
			break;
	  }
	  l_reg=R_CLOCK_TRIM;
	  outw(l_reg,l_data);
  }
	return ReturnVal;  //return 0=success, return others=fail.
}