/*
 * DrvCMP.h
 *
 *  Created on: 2014/06/5
 *      Author: Eric.Lai
 * modify:
 * ޸ΪCPPS=4;CPNS=02014-9-12
 */

#ifndef DRVCMP_H_
#define DRVCMP_H_

#include "HY16F3981.h"


#ifndef E_FAIL
#define E_FAIL		1
#endif
#define E_DRVCMP_ARGUMENT E_FAIL

#ifndef E_SUCCESS
#define E_SUCCESS		0
#endif

#ifdef GPIO_BASE
#define GPIO_CMP_CTRL     (GPIO_BASE+OFFSET40)
#endif

#ifdef  CMP_BASE
#define CMP_INPUT CMP_BASE+OFFSET04; //OFFSET00;
#define CMP_CTRL0 CMP_BASE;
#define CMP_CTRL1 CMP_BASE+OFFSET04;
#define CMP_CTRL2 CMP_BASE+OFFSET08
#endif

#ifdef INTERRUPT_BASE
#define CMP_INTERRUPT_CTRL  (INTERRUPT_BASE+OFFSET0C)
#endif
typedef enum
{
	E_CMP_DISABLE = 0,
	E_CMP_CPI = 1,
	E_CMP_VDD3V = 2,
	E_CMP_VDD18 = 3
} E_NON_OVERLAP_VREF;
typedef enum
{
	E_CL1 = 0,
	E_CL2 = 1,
	E_CL3 = 2,
	E_CL4 = 3,
	E_CL5 = 4,
	E_CL6 = 5,
	E_CL7 = 6,
	E_CL8 = 7
} E_NON_OVERLAP_PIN;
typedef enum
{
	E_CH1 = 0,
	E_CH2 = 1,
	E_CH3 = 2,
	E_V12 = 3,
	E_RLO = 3
} E_CMP_PIN;

//0x41800
#define CMPO     		    16
#define CPIS     		    4
#define CPOR                3
#define CPDF     		    2
#define CMPLP     	    1
#define ENCMP               0
#define CPIS_MASK  	    (CPIS+MASK)
#define CPOR_MASK           (CPOR+MASK)
#define CPDF_MASK 	    (CPDF+MASK)
#define CMPLP_MASK 	    (CMPLP+MASK)
#define ENCMP_MASK          (ENCMP+MASK)

//0x41804
#define CPDM     		    20
#define CPDA     		    16
#define CPPS     		    4 //0
#define CPNS                0 //4
#define CPDM_MASK  	    (CPDM+MASK)
#define CPDA_MASK  	    (CPDA+MASK)
#define CPPS_MASK  	    (CPPS+MASK)
#define OPNS_MASK           (OPNS+MASK)

//0x41808
#define CPCLS               17
#define ENCLIN              16
#define CPRLS     	    4
#define CPRH     		    0
#define CPCLS_MASK          (CPCLS+MASK)
#define ENCLIN_MASK 	    (ENCLIN+MASK)
#define CPRLS_MASK 	    (CPRLS+MASK)
#define CPRH_MASK  	    (CPRH+MASK)

#define CPPS_MAX            3
#define CPNS_MAX            3
#define CPRLS_MAX  	    1
#define CPRH_MAX   	    7


#define CPDM_MAX            15
#define CPDA_MAX            15
#define CPOR_MAX            1
#define CMPLP_MAX           1
#define CPIS_MAX            1
#define ENCLIN_MAX          1
#define CPCLS_MAX           7 //3
#define CPDF_MAX            1


#define CPPTE               16
#define CPPTS               17
#define CPPTE_MASK          (CPPTE+MASK)
#define CPPTS_MASK          (CPPTS+MASK)
#define CPPTS_MAX           1


#define CMPIE     	    17
#define CMPIF     	    1
#define CMPIE_MASK          (CMPIE+MASK)
#define CMPIF_MASK          (CMPIF+MASK)



unsigned int DrvCMP_Open (unsigned int uPowerMode ,unsigned int uCPDF,unsigned int uCPOR);
void DrvCMP_Close(void);
void DrvCMP_Enable(void);
unsigned int DrvCMP_Input(unsigned int uPositiveInput,unsigned int uNegativeInput,unsigned int uInputSwitch);
unsigned int DrvCMP_RLO_Ctrl(unsigned int uCPDA ,unsigned int uCPDM);
unsigned int DrvCMP_RLO_refV(unsigned int uCPRH,unsigned int uCPRLS);
unsigned int DrvCMP_PInput(unsigned int uCPPS);
unsigned int DrvCMP_NInput(unsigned int uCPNS);
unsigned int DrvCMP_InputSwitch (unsigned int uInputSwitch);
unsigned int DrvCMP_OutputFilter(unsigned int uFilter);
unsigned int DrvCMP_OutputPinEnable(unsigned int uPin);
void DrvCMP_OutputPinDisable(void);
unsigned int DrvCMP_OutputInverse(unsigned int uInv);
void DrvCMP_EnableInt(void);
void DrvCMP_DisableInt(void);
unsigned int DrvCMP_ReadIntFlag(void);
void DrvCMP_ClearIntFlag(void);
unsigned int DrvCMP_ReadData (void);
unsigned int DrvCMP_EnableNonOverlap(E_NON_OVERLAP_PIN uInput);
void DrvCMP_DisableNonOverlap(void);

#endif /* DRVCMP_H_ */
