/*
 * DrvCMP.c
 *
 *  Created on: 2015/06/05
 *  Author: CJ.LEE
 */
#include "DrvCMP.h"
#include "SpecialMacro.h"

unsigned int DrvCMP_Open (unsigned int uPowerMode ,unsigned int uCPDF,unsigned int uCPOR)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=CMP_CTRL0; //CMP_CTRL;
	if((uPowerMode<(CMPLP_MAX+1))&&(uCPDF<(CPDF_MAX+1))&&(uCPOR<(CPOR_MAX+1)))
	{
		(uPowerMode==1) ? (l_data=(1<<CMPLP)):(l_data=(0<<CMPLP));
		(uCPDF==1) ? (l_data+=(1<<CPDF)):(l_data+=(0<<CPDF));
		(uCPOR==1) ? (l_data+=(1<<CPOR)):(l_data+=(0<<CPOR));
		l_data+=(1<<CMPLP_MASK)|(1<<CPDF_MASK)|(1<<CPOR_MASK)|(1<<ENCMP)|(1<<ENCMP_MASK);
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVCMP_ARGUMENT;
	return ReturnVal;
}

void DrvCMP_Close(void)
{
	unsigned int l_reg,l_data;
	l_reg=CMP_CTRL0; //CMP_CTRL;
	l_data=1<<ENCMP_MASK;
	outw(l_reg,l_data);
}

unsigned int DrvCMP_Input(unsigned int uPositiveInput,unsigned int uNegativeInput,unsigned int uInputSwitch)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=CMP_INPUT;
	if((uPositiveInput<(CPPS_MAX+1))&&(uNegativeInput<(CPNS_MAX+1))&&(uInputSwitch<(CPIS_MAX+1)))
	{
		l_data=(uPositiveInput<<CPPS)|(CPPS_MAX<<(CPPS+MASK))|(uNegativeInput<<CPNS)|(CPNS_MAX<<(CPNS+MASK))|(inw(l_reg)&0x00ff0000);
		outw(l_reg,l_data);
		l_reg=CMP_CTRL0; //CMP_CTRL;
		l_data=(uInputSwitch<<CPIS)|(CPIS_MAX<<CPIS_MASK);
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVCMP_ARGUMENT;
	return ReturnVal;
}

void DrvCMP_Enable(void)
{
	unsigned int l_reg,l_data;
	l_reg=CMP_CTRL0;
	l_data=(1<<ENCMP)|(1<<ENCMP_MASK);
	outw(l_reg,l_data);
}

void DrvCMP_Disable(void)
{
	unsigned int l_reg,l_data;
	l_reg=CMP_CTRL0;
	l_data=(1<<ENCMP_MASK);
	outw(l_reg,l_data);
}

unsigned int DrvCMP_PInput(unsigned int uCPPS)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=CMP_INPUT;
	if(uCPPS<(CPPS_MAX+1))
	{
		l_data=(uCPPS<<CPPS)|(CPPS_MAX<<(CPPS+MASK))|(inw(l_reg)&0x00ff0000);
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVCMP_ARGUMENT;
	return ReturnVal;
}

unsigned int DrvCMP_NInput(unsigned int uCPNS)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=CMP_INPUT;
	if(uCPNS<(CPNS_MAX+1))
	{
	    l_data=(uCPNS<<CPNS)|(CPNS_MAX<<(CPNS+MASK))|(inw(l_reg)&0x00ff0000);
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVCMP_ARGUMENT;
	return ReturnVal;
}

unsigned int DrvCMP_InputSwitch (unsigned int uInputSwitch)
{
	
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=CMP_CTRL0;
	if(uInputSwitch<(CPIS_MAX+1))
	{
		l_data=(uInputSwitch<<CPIS)|(CPIS_MAX<<CPIS_MASK);
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVCMP_ARGUMENT;
	return ReturnVal;

}
/**************************************************************
*name   : DrvCMP_OutputFilter();
*input  : uFilter
*output : 
*version: v1.0
*date   : 2014-5-30
*modify : NO
***************************************************************/
unsigned int DrvCMP_OutputFilter(unsigned int uFilter)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=CMP_CTRL0;
	if(uFilter<(CPDF_MAX+1))
	{
		l_data=(uFilter<<CPDF)|(1<<CPDF_MASK);
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVCMP_ARGUMENT;
	return ReturnVal;
}

unsigned int DrvCMP_OutputPinEnable(unsigned int uPin)
{
	unsigned int l_reg,l_data;
	if (uPin<CPPTS_MAX+1)
	{
		l_reg=GPIO_CMP_CTRL;
		l_data=(1<<CPPTE)|(1<<CPPTE_MASK)|(uPin<<CPPTS)|(1<<CPPTS_MASK);
		outw(l_reg,l_data);
	}else return E_DRVCMP_ARGUMENT;
	return E_SUCCESS;
}

void DrvCMP_OutputPinDisable(void)
{
	unsigned int l_reg,l_data;
	l_reg=GPIO_CMP_CTRL;
	l_data=(1<<CPPTE_MASK);
	outw(l_reg,l_data);
}

unsigned int DrvCMP_OutputInverse(unsigned int uInv)
{
	unsigned int l_reg,l_data;
	l_reg=CMP_CTRL0;
	if(uInv<2)
	{
	    l_data=(uInv<<CPOR)|(1<<CPOR_MASK);
	    outw(l_reg,l_data);
	}else return E_DRVCMP_ARGUMENT;
	return E_SUCCESS;
}

void DrvCMP_EnableInt(void)
{
	unsigned int l_reg,l_data;
	l_reg=CMP_INTERRUPT_CTRL;
	l_data=(1<<CMPIE)|(1<<CMPIE_MASK);
	outw(l_reg,l_data);
    //l_data=__nds32__mfsr(NDS32_SR_INT_MASK);
    //SETBIT(l_data,3);
    //__nds32__mtsr(l_data, NDS32_SR_INT_MASK);

}

void DrvCMP_DisableInt(void)
{
	unsigned int l_reg,l_data;
	l_reg=CMP_INTERRUPT_CTRL;
	l_data=(1<<CMPIE_MASK);
	outw(l_reg,l_data);
	//l_data=__nds32__mfsr(NDS32_SR_INT_MASK);
	//CLRBIT(l_data,3);
	//__nds32__mtsr(l_data, NDS32_SR_INT_MASK);
}
/**************************************************************
*name   : DrvCMP_ReadIntFlag();
*input  : NO
*output : CMP interrupt flag value
*version: v1.0
*date   : 2014-5-30
*modify : NO
***************************************************************/
unsigned int DrvCMP_ReadIntFlag(void)
{
	unsigned int l_reg,ReturnVal;
	ReturnVal=0;
	l_reg=CMP_INTERRUPT_CTRL;
	ReturnVal=(inw(l_reg)>>CMPIF)&0x01;
	return ReturnVal;
}

void DrvCMP_ClearIntFlag(void)
{
	unsigned int l_reg,l_data;
	l_reg=CMP_INTERRUPT_CTRL;
	l_data=(1<<CMPIF_MASK);
	outw(l_reg,l_data);
}

unsigned int DrvCMP_RLO_Ctrl(unsigned int uCPDA ,unsigned int uCPDM)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=CMP_CTRL1;
	if((uCPDA<(CPDA_MAX+1))&&(uCPDM<(CPDM_MAX+1)))
	{
		l_data=(uCPDA<<CPDA)|(CPDA_MAX<<(CPDA+MASK))|(uCPDM<<CPDM)|(CPDM_MAX<<(CPDM+MASK));
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVCMP_ARGUMENT;
	return ReturnVal;
}
/**************************************************************
*name   : DrvCMP_RLO_refV();
*input  : uCPRH, uCPRLS
*	    uCPRH: 0 OFF
*		     1 CP_I
*		     2 VDD3V
*                3 VDD18
*         uCPRLS: 0 comparator resitor short switch be disable
*                 1 comparator resitor short switch be enable
*output : 
*version: v1.1
*date   : 2015-6-5
*modify : Ӷȡд0x41808[19:16][3]λֵܣⱻ0x41804ֵȡ
***************************************************************/
unsigned int DrvCMP_RLO_refV(unsigned int uCPRH,unsigned int uCPRLS)
{
	unsigned int l_reg,l_data,ReturnVal,l_data_rest,l_mask_rest;
	ReturnVal=0;
  l_mask_rest=((0xff00ff00) ^ (((CPRH_MAX<<CPRH)|(CPRLS_MAX<<CPRLS))<<8)); // REST_MASK = (ALL_MASK) XOR (WRITE_MASK)
	l_data_rest=(((l_mask_rest)>>8) & (*((volatile unsigned int*)(CMP_CTRL2)))); //REST_DATA = (REST_MASK>>8) AND (REGISTER_DATA)
	l_reg=CMP_CTRL2; //CMP_INPUT;
	if((uCPRH<(CPRH_MAX+1))&&(uCPRLS<(CPRLS_MAX+1)))
	{
		if(uCPRH==0)
			l_data=0|(CPRH_MAX<<+MASK);
		else
			l_data=(0X1<<(uCPRH-1))|(CPRH_MAX<<MASK);
		l_data=l_data|(uCPRLS<<CPRLS)|(CPRLS_MAX<<(CPRLS+MASK));
		l_data=(l_data | l_data_rest | l_mask_rest); // Combining the rest bits
		outw(l_reg,l_data);
	}
	else
		ReturnVal=E_DRVCMP_ARGUMENT;
	return ReturnVal;
}

uint32_t DrvCMP_EnableNonOverlap(E_NON_OVERLAP_PIN uInput)
{
	unsigned int l_reg,l_data,ReturnVal,l_data_rest,l_mask_rest;
	ReturnVal=0;
    l_mask_rest=((0xFF00FF00) ^ (((CPCLS_MAX<<CPCLS) | (ENCLIN_MAX<<ENCLIN))<<8));// REST_MASK = (ALL_MASK) XOR (WRITE_MASK)
    l_data_rest=(((l_mask_rest)>>8) & (*((volatile unsigned int*)(CMP_CTRL2))));//REST_DATA = (REST_MASK>>8) AND (REGISTER_DATA)
	l_reg=CMP_CTRL2;
	if(uInput<(CPCLS_MAX+1))
	{
		l_data=(uInput<<CPCLS)|(CPCLS_MAX<<(CPCLS+MASK))|(1<<ENCLIN)|(ENCLIN_MAX<<(ENCLIN+MASK));
		l_data=(l_data | l_data_rest | l_mask_rest); // Combining the other bits
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVCMP_ARGUMENT;
	return ReturnVal;
}


void DrvCMP_DisableNonOverlap(void)
{
	unsigned int l_reg,l_data,l_data_rest,l_mask_rest;
	l_mask_rest=((0xff00ff00) ^ ((ENCLIN_MAX<<ENCLIN)<<8));// REST_MASK = (ALL_MASK) XOR (WRITE_MASK)
	l_data_rest=(((l_mask_rest)>>8) & (*((volatile unsigned int*)(CMP_CTRL2))));//REST_DATA = (REST_MASK>>8) AND (REGISTER_DATA)
	l_reg=CMP_CTRL2;
	l_data=(ENCLIN_MAX<<(ENCLIN+MASK));
	l_data=(l_data | l_data_rest | l_mask_rest); // Combining the rest bits
	outw(l_reg,l_data);
}

unsigned int DrvCMP_ReadData (void)
{
	unsigned int l_reg,ReturnVal;
	l_reg=CMP_CTRL0;
	ReturnVal=((inw(l_reg)&(1<<CMPO))>>CMPO);
	return ReturnVal;
}






