/*
 * DrvADC.h
 *
 *  Created on: 2016/08/15
 *  Author: Robert.Wang
 *  Version : V0.0, 2016/08/15
 *  
 */

#ifndef DRVADC_H_
#define DRVADC_H_

#include "HY16F3981.h"

#ifndef E_FAIL
#define E_FAIL      1
#endif
#define E_DRVADC_ARGUMENT E_FAIL

#ifndef E_SUCCESS
#define E_SUCCESS       0
#endif

#ifdef  ADC_BASE
#define R_ADC_CTRL1 (ADC_BASE+OFFSET00);
#define R_ADC_CTRL2 (ADC_BASE+OFFSET04);
#define R_ADC_ADO   (ADC_BASE+OFFSET08);
#endif

#ifdef  CLOCK_BASE
#define R_ADC_CLOCK (CLOCK_BASE+OFFSET0C);
#endif

#ifdef  INTERRUPT_BASE
#define ADC_INTERRUPT_CTRL  (INTERRUPT_BASE+OFFSET08)
#endif

typedef enum
{
    OP_OP = 0,
    OP_ON,
    ADC_Input_AIO2,
    ADC_Input_AIO3,
    ADC_Input_AIO4,
    ADC_Input_AIO5,
    ADC_Input_AIO6,
    ADC_Input_AIO7,
    TPS0_TPS1, //8
    TPS1_TPS0, //9
    REFO_I, //10
    VDDA_VSSA,  //11
    R2ROPO,  //12
    DAOI,  //13
    ADC_Input_AIO8,  //14
    VDD3V5_VSS  //15
} E_ADC_INPUT_CHANNEL;

typedef enum
{
    External = 0,
    Internal,
} E_ADC_REFV;

/*
typedef enum
{
    ADC_PGA_Disable = 0,
    ADC_PGA_8=1,
    ADC_PGA_16=3,
    ADC_PGA_32=7
} E_ADC_PGA;
*/

typedef enum
{
    ADC_ADGN_1 = 0,
    ADC_ADGN_2 = 1,
    ADC_ADGN_4 = 3,
    ADC_ADGN_8 = 7
} E_ADC_ADGN;

typedef enum
{
    OPEN = 0,
    SHORT,
} E_ADC_SIGNAL_SHORT;

typedef enum
{
    VDDA = 0,
    AIO2,
    AIO4,
    REF_BUFFER_OUT
} E_ADC_VRPS_REF_VOLTAGE;

typedef enum
{
    VSSA = 0,
    AIO3 = 1,
    AIO5
    //REF_BUFFER_OUT
}E_ADC_VRNS_REF_VOLTAGE;


//C Library use definition
//0x41100
#define VISHR               21
#define VRSHR               20
#define VRPS                18
#define VRNS                16
//#define ADFDR             6
#define OSR                 2
#define CFRST               1
#define ADCEN               0
#define VISHR_MASK          (VISHR+MASK)
#define VRSHR_MASK          (VRSHR+MASK)
#define VRPS_MASK           (VRPS+MASK)
#define VRNS_MASK           (VRNS+MASK)
//#define ADFDR_MASK            (ADFDR+MASK)
#define OSR_MASK            (OSR+MASK)
#define CFRST_MASK          (CFRST+MASK)
#define ADCEN_MASK          (ADCEN+MASK)
#define VISHR_MAX           1
#define VRSHR_MAX           1
#define VRPS_MAX            3
#define VRNS_MAX            3
//#define ADFDR_MAX         1
#define OSR_MAX             15
#define CFRST_MAX           1

//0x41104
#define DCSET               24
//#define ADGN              20
#define ADGN                16
#define FRb                 19
//#define PGA               16
#define ADINP               4
#define ADINN               0
#define DCSET_MASK          (DCSET+MASK)
#define ADGN_MASK           (ADGN+MASK)
#define FRb_MASK            (FRb+MASK)
//#define PGA_MASK          (PGA+MASK)
#define ADINP_MASK          (ADINP+MASK)
#define ADINN_MASK          (ADINN+MASK)
#define DCSET_MAX           15
//#define ADGN_MAX          3
#define ADGN_MAX            7
#define FRb_MAX             1
//#define PGA_MAX           7
#define ADINP_MAX           15
#define ADINN_MAX           15

#define ADO                 0
#define ENACD               1
#define ADC_CLK_PH          7
#define ADC_CLK_EN          6
#define ADC_CLK_DIV         4
#define ADC_CLK_PH_MASK     (ADC_CLK_PH+MASK)
#define ADC_CLK_EN_MASK     (ADC_CLK_EN+MASK)
#define ADC_CLK_DIV_MASK    (ADC_CLK_DIV+MASK)
#define ADC_CLK_PH_MAX      1
#define ADC_CLK_EN_MAX      1
#define ADC_CLK_DIV_MAX     7

#define ADCIE               16
#define ADCIF               0
#define ADCIE_MASK          (ADCIE+MASK)
#define ADCIF_MASK          (ADCIF+MASK)

//C Library Function definition
unsigned int DrvADC_PInputChannel(unsigned int uINP);
unsigned int DrvADC_NInputChannel(unsigned int uINN);
unsigned int DrvADC_SetADCInputChannel(unsigned int uINP,unsigned int uINN);
unsigned int DrvADC_InputSwitch(unsigned int uVISHR);
unsigned int DrvADC_RefInputShort(unsigned int uVrshr);
unsigned int DrvADC_ADGain(unsigned int uADgain);
unsigned int DrvADC_DCoffset(unsigned int uDCoffset);
unsigned int DrvADC_RefVoltage(unsigned int uVrps,unsigned int uVrns);
unsigned int DrvADC_FullRefRange(unsigned int uFullRange);
unsigned int DrvADC_OSR(unsigned int uADCOSR);
unsigned int DrvADC_ClkEnable(unsigned int uADCD);
void DrvADC_ClkDisable(void);
unsigned int DrvADC_CombFilter(unsigned int uCFRST);
void DrvADC_EnableInt(void);
void DrvADC_DisableInt(void);
unsigned int DrvADC_ReadIntFlag(void);
void DrvADC_Enable(void);
void DrvADC_Disable(void);
int DrvADC_GetConversionData(void);



#endif /* DRVADC_H_ */
