/*
 *  Created on: 2016/7/28
 *  Author: Robert.Wang
 *  Memo : HY16F3981 DrvADC.c is base on HY16F198B to modify
 *  Version : V0.0 2016/7/28, V0.1 2016/8/15
 *  
*/

#include "DrvADC.h"
#include "SpecialMacro.h"

unsigned int DrvADC_PInputChannel(unsigned int uINP)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=R_ADC_CTRL2;
	if(uINP<(ADINP_MAX+1))
	{
		l_data=inw(l_reg)&0xffff0f0f;
		l_data|=(uINP<<ADINP)|(15<<(ADINP+MASK));
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVADC_ARGUMENT;
	return ReturnVal;
}

unsigned int DrvADC_NInputChannel(unsigned int uINN)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=R_ADC_CTRL2;
	if(uINN<(ADINN_MAX+1))
	{
		l_data=inw(l_reg)&0xfffff0f0;
		l_data|=(uINN<<ADINN)|(15<<(ADINN+MASK));
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVADC_ARGUMENT;
	return ReturnVal;
}

unsigned int DrvADC_SetADCInputChannel(unsigned int uINP,unsigned int uINN)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=R_ADC_CTRL2;
	if((uINP<(ADINP_MAX+1))&&(uINN<(ADINN_MAX+1)))
	{
		l_data=inw(l_reg)&0xffff0000;
		l_data|=(uINP<<ADINP)|(0xf<<(ADINP+MASK))|(uINN<<ADINN)|(0xf<<(ADINN+MASK));
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVADC_ARGUMENT;
	return ReturnVal;
}

unsigned int DrvADC_InputSwitch(unsigned int uVISHR)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=R_ADC_CTRL1;
	if(uVISHR<(VISHR_MAX+1))
	{
		l_data=(uVISHR<<VISHR)|(VISHR_MAX<<(VISHR+MASK));
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVADC_ARGUMENT;
	return ReturnVal;
}

unsigned int DrvADC_RefInputShort(unsigned int uVrshr)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=R_ADC_CTRL1;
	if(uVrshr<(VRSHR_MAX+1))
	{
		l_data=(uVrshr<<VRSHR)|(VRSHR_MAX<<(VRSHR+MASK));
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVADC_ARGUMENT;
	return ReturnVal;
}


//Robert add 2016/7/17
unsigned int DrvADC_ADGain(unsigned int uADgain)
//unsigned int DrvADC_ADGain(unsigned int uPGA)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=R_ADC_CTRL2;
	if(uADgain<(ADGN_MAX+1))
	{
		l_data=(inw(l_reg)&(0xffffffff-(ADGN_MAX<<ADGN)));
		l_data|=(uADgain<<ADGN);
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVADC_ARGUMENT;
	return ReturnVal;
}


unsigned int DrvADC_DCoffset(unsigned int uDCoffset)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=R_ADC_CTRL2;
	if(uDCoffset<(DCSET_MAX+1))
	{
		l_data=(inw(l_reg)&(0xffffffff-(DCSET_MAX<<DCSET)));
		l_data|=(uDCoffset<<DCSET);
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVADC_ARGUMENT;
	return ReturnVal;
}

unsigned int DrvADC_RefVoltage(unsigned int uVrps,unsigned int uVrns)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=R_ADC_CTRL1;
	if((uVrps<(VRPS_MAX+1))&&(uVrns<(VRNS_MAX+1)))
	{
		l_data=(uVrps<<VRPS)|(VRPS_MAX<<(VRPS+MASK))|(uVrns<<VRNS)|(VRNS_MAX<<(VRNS+MASK));
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVADC_ARGUMENT;
	return ReturnVal;
}

unsigned int DrvADC_FullRefRange(unsigned int uFullRange)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=R_ADC_CTRL2;
	if(uFullRange<(FRb_MAX+1))
	{
		l_data=(inw(l_reg)&(0xffffffff-(FRb_MAX<<FRb)));
		l_data|=(uFullRange<<FRb);
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVADC_ARGUMENT;
	return ReturnVal;
}

unsigned int DrvADC_OSR(unsigned int uADCOSR)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=R_ADC_CTRL1;
	if(uADCOSR<(OSR_MAX+1))
	{
		l_data=(uADCOSR<<OSR)|(OSR_MAX<<(OSR_MASK));
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVADC_ARGUMENT;
	return ReturnVal;
}
/*******************************************************************
*name    : DrvADC_ClkEnable(unsigned int uADCD)
*function: Enable ADC CLOCK,set the clock divider,the ADC clock adjustment
*input   : uADCD
*output  : 0 success
*          others: fail
*date    : 2016-7-19 (Authot Robert)
*modify  : no
*********************************************************************/
unsigned int DrvADC_ClkEnable(unsigned int uADCD)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=R_ADC_CLOCK;
	if((uADCD<(ADC_CLK_DIV_MAX+1))&&(uADCD!=0))
	{
		l_data=inw(l_reg)&0x00007000;
		l_data|=(uADCD<<ADINP)|(15<<(ADINP+MASK));  //set 0X4030C[6:4]=xxxb
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVADC_ARGUMENT;
	return ReturnVal;
}

/*******************************************************************
*name    : DrvADC_ClkDisable(void)
*function: /set 0X4030C[6:4]=000b
*input   : no
*output  : no
*          others: no
*date    : 2016-7-19 (Authot Robert)
*modify  : no
*********************************************************************/
void DrvADC_ClkDisable(void)
{
	unsigned int l_reg,l_data; //Robert modify 2016/7/17
	l_reg=R_ADC_CLOCK;
    l_data=0x00007000; //set 0X4030C[6:4]=000b
	outw(l_reg,l_data);
}


unsigned int DrvADC_CombFilter(unsigned int uCFRST)
{
	unsigned int l_reg,l_data,ReturnVal;
	ReturnVal=0;
	l_reg=R_ADC_CTRL1;
	if(uCFRST<(CFRST_MAX+1))
	{
		l_data=(uCFRST<<CFRST)|(CFRST_MAX<<(CFRST_MASK));
		outw(l_reg,l_data);
	}else ReturnVal=E_DRVADC_ARGUMENT;
	return ReturnVal;
}

void DrvADC_EnableInt(void)
{
	unsigned int l_reg,l_data;
	l_reg=ADC_INTERRUPT_CTRL;
	l_data=(1<<ADCIE)|(1<<ADCIE_MASK);
	outw(l_reg,l_data);
}

void DrvADC_DisableInt(void)
{
	unsigned int l_reg,l_data;
	l_reg=ADC_INTERRUPT_CTRL;
	l_data=(1<<ADCIE_MASK);
	outw(l_reg,l_data);
}
/*******************************************************************
*name    : DrvADC_ReadIntFlag(void)
*function: Get the ADC interrupt flag
*input   : NO
*output  : 0 ADC flag is 0,have no interrupt
*          1 ADC flag is 1,it's ADC interrupt
*date    : 2013-11-29
*modify  : modify the operation about get ADC flag correctly
*********************************************************************/
unsigned int DrvADC_ReadIntFlag(void)
{
	unsigned int l_reg,ReturnVal;
	ReturnVal=0;
	l_reg=ADC_INTERRUPT_CTRL;
	//Robert add 2016/8/5
	ReturnVal=((inw(l_reg)&0x01)>>(ADCIF)); //Read 0X40008[0]
	//ReturnVal=((inw(l_reg)&(0x01<<ADCIF))>>(ADCIF));
	return ReturnVal;
}
void DrvADC_Enable(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_ADC_CTRL1;
	l_data=(1<<ADCEN)|(1<<ADCEN_MASK);
	outw(l_reg,l_data);
}


void DrvADC_Disable(void)
{
	unsigned int l_reg,l_data;
	l_reg=R_ADC_CTRL1;
	l_data=(1<<ADCEN_MASK);
	outw(l_reg,l_data);
}


/*******************************************************************
*name    : DrvADC_GetConversionData()
*function: read the ADC register 32bit
*input   : no
*output  : ADC register 32bit
*date    : 2013-11-29
*modify  : modify the return data type from 'unsigned int' to 'int'
*********************************************************************/
 int DrvADC_GetConversionData(void)
{
      unsigned int l_reg;
      int l_data;
	l_reg=R_ADC_ADO;
	l_data=inw(l_reg);
	return l_data;
}

