;======================
;thermocouple measure
;six channel thermocouple
;;========================
include hy11p12.inc
include macro.asm  

	org 00h
	jmp	start
	
      org 04h
	BTSZ INTF1,ADCIF
      JMP  ADCINT
      btsz intf1,E0IF
      jmp  int0
      btsz intf1,E1IF
      JMP  INT1
      clrf	intf1 ;+
      RETI 
		
start:
      call  sysini0
start0:
      jmp  key_scan
keyend:
      btsz flag,b_off
      jmp  power_end
      btsz sys_flag,deal_f 
      JMP   DEAL  
      cwdt
      nop
      jmp   start0
include calibration.asm       
include intrrupt.asm
INCLUDE I2C.ASM
include deal.asm
include KEYSCAN00.asm
include hextobcd.asm
INCLUDE SYSINI.ASM
INCLUDE DISPALY.ASM
inCLude lib.asm 
INclude TABLE2.ASM
INCLUDE TABLE.ASM 
include def_mem.asm
include poweroff.asm 

;	org 0600h
;
;;===========================                                     
;; TABLE FOR K TYPE thermocouple                                  
;;=============================                                   
;readv2th:                                                        
;	 nop     	                                                             
;	 nop		                                                           
;       mvl     High  V2TH             ; PCLATH sD_l}(b
;       mvf     PCLATH,F,ACCE                                     
;       mvf     dl,W,ACCE                                  
;       addl    Low   V2TH            ; ոDȻP JPBmۥ[
;       btss    status,c,ACCE                                     
;       jmp     V2THPRE                                           
;       inf     PCLATH,F,ACCE         ; pGWL0x100h [PCLATU,PC
; V2THPRE:                                                        
;       mvl     V2TH                                              
;       addf    dl,W,ACCE                                  
;       mvf     PCLATL,F,ACCE                                                                                                      
;V2Th:                                                                                                                             
;      retl 	000H 	      ;0   	    0          0                   
;      retl 	003H            ;32  	    1          0               
;      retl 	006H            ;64  	    2          10              
;      retl 	009H            ;96  	    3          20              
;      retl 	00CH            ;128 	    4          30              
;      retl 	00FH            ;160 	    5          30              
;      retl 	012H           ;192 	    6          40              
;      retl 	015H           ;224 	    7          50              
;      retl 	018H           ;256 	    8          60              
;      retl 	01BH           ;288 	    9          70              
;      retl 	01EH           ;320 	    A          70              
;      retl 	021H           ;352 	    B          80              
;      retl 	024H           ;384 	    C          90              
;      retl 	027H           ;416 	    D          100             
;      retl 	02AH           ;448 	    E          100             
;      retl 	02DH           ;480 	    F          110             
;      retl 	030H           ;512      10         120              
;      retl 	033H           ;544      11         130              
;      retl 	036H           ;576      12         140              
;      retl 	03AH           ;608      13         140              
;      retl 	03DH           ;640      14         150              
;      retl 	040H           ;672      15         160              
;      retl 	043H           ;704      16         170              
;      retl 	046H           ;736      17         180              
;      retl 	049H           ;768      18         180              
;      retl 	04CH           ;800      19         190              
;      retl 	04FH           ;832      1A         200              
;      retl 	053H           ;864      1B         210              
;      retl 	056H           ;896      1C         220              
;      retl 	059H           ;928      1D         220              
;      retl 	05CH           ;960      1E         230              
;      retl 	05FH           ;992      1F         240              
;      retl 	062H           ;1024     20         250              
;      retl 	065H           ;1056     21         250              
;      retl 	068H           ;1088     22         260              
;      retl   06BH              ;1120     23         270          
;      retl   06EH              ;1152     24         280          
;      retl   071H              ;1184     25         290          
;      retl   074H              ;1216     26         290          
;      retl   077H              ;1248     27         300          
;      retl   07AH              ;1280     28         310          
;      retl   07DH              ;1312     29         320          
;      retl   080H              ;1344     2A         320          
;      retl   083H              ;1376     2B         330          
;      retl   086H              ;1408     2C         340          
;      retl   089H              ;1440     2D         350          
;      retl   08CH              ;1472     2E         360          
;      retl   08FH              ;1504     2F         360          
;      retl   092H              ;1536     30         370          
;      retl   095H              ;1568     31         380          
;      retl   098H              ;1600     32         390          
;      retl   09BH              ;1632     33         390          
;      retl   09EH              ;1664     34         400          
;      retl   0A1H              ;1696     35         410          
;      retl   0A4H              ;1728     36         420          
;      retl   0A7H              ;1760     37         420          
;      retl   0AAH              ;1792     38         430          
;      retl   0ADH              ;1824     39         440          
;      retl   0B0H              ;1856     3A         450          
;      retl   0B3H              ;1888     3B         450          
;      retl   0B6H              ;1920     3C         460          
;      retl   0B9H              ;1952     3D         470          
;      retl   0BBH              ;1984     3E         480          
;      retl   0BEH              ;2016     3F         480          
;      retl   0C1H              ;2048     40         490          
;      retl   0C4H              ;2080     41         500          
;      retl   0C7H              ;2112     42         510          
;      retl   0CAH              ;2144     43         520          
;      retl   0CDH              ;2176     44         530          
;      retl   0D0H              ;2208     45         540          
;      retl   0D3H              ;2240     46         550          
;                                    ;2272                        
;                                                                 
;readv2tl:				                                                 
;       mvl     High  V2TL             ; PCLATH sD_l}(b
;       mvf     PCLATH,F,ACCE                                     
;       mvf     DL,W,ACCE                                         
;       addl    Low   V2Tl             ; ոDȻP JPBm?
;       btss    status,c,ACCE                                     
;       jmp     V2TLPRE                                           
;       inf     PCLATH,F,ACCE         ; pGWL0x100h [PCLATU,PC
; V2TLPRE:                                                        
;       mvl     V2TL                                              
;       addf    DL,W,ACCE                                         
;       mvf     PCLATL,F,ACCE                                     
;                                                                 
;                                                                 
;v2tl:                                                            
;              retl  000H   	      ;0   	    0          0         
;              retl  026H 	            ;32  	    1          0     
;              retl  045H 	            ;64  	    2          10    
;              retl  05FH 	            ;96  	    3          20    
;              retl  073H 	            ;128 	    4          30    
;              retl  083H 	            ;160 	    5          30    
;              retl  08DH	            ;192 	    6          40    
;              retl  094H	            ;224 	    7          50    
;              retl  099H	            ;256 	    8          60    
;              retl  09DH	            ;288 	    9          70    
;              retl  09FH	            ;320 	    A          70    
;              retl  0A2H	            ;352 	    B          80    
;              retl  0A5H	            ;384 	    C          90    
;              retl  0AAH	            ;416 	    D          100   
;              retl  0B1H	            ;448 	    E          100   
;              retl  0BCH	            ;480 	    F          110   
;              retl  0C9H	            ;512      10         120   
;              retl  0DAH	            ;544      11         130   
   ;              retl  0EFH	            ;576      12         140   
   ;              retl  007H	            ;608      13         140   
   ;              retl  023H	            ;640      14         150   
   ;              retl  041H	            ;672      15         160   
   ;              retl  060H	            ;704      16         170   
   ;              retl  082H	            ;736      17         180   
   ;              retl  0A3H	            ;768      18         180   
   ;              retl  0C5H	            ;800      19         190   
   ;              retl  0E5H	            ;832      1A         200   
   ;              retl  004H	            ;864      1B         210   
   ;              retl  021H	            ;896      1C         220   
   ;              retl  03CH	            ;928      1D         220   
   ;              retl  054H	            ;960      1E         230   
   ;              retl  069H	            ;992      1F         240   
   ;              retl  07CH	            ;1024     20         250   
   ;              retl  08CH	            ;1056     21         250   
   ;              retl  09AH	            ;1088     22         260   
   ;              retl  0A5H               ;1120     23         270  
   ;              retl  0AEH               ;1152     24         280  
   ;              retl  0B5H               ;1184     25         290  
   ;              retl  0BAH               ;1216     26         290  
   ;              retl  0BDH               ;1248     27         300  
   ;              retl  0C0H               ;1280     28         310  
   ;              retl  0C0H               ;1312     29         320  
   ;              retl  0C0H               ;1344     2A         320  
   ;              retl  0BEH               ;1376     2B         330  
   ;              retl  0BAH               ;1408     2C         340  
   ;              retl  0B6H               ;1440     2D         350  
   ;              retl  0B1H               ;1472     2E         360  
   ;              retl  0ABH               ;1504     2F         360  
   ;              retl  0A4H               ;1536     30         370  
   ;              retl  09BH               ;1568     31         380  
   ;              retl  093H               ;1600     32         390  
   ;              retl  089H               ;1632     33         390  
   ;              retl  07EH               ;1664     34         400  
   ;              retl  073H               ;1696     35         410  
   ;              retl  067H               ;1728     36         420  
   ;              retl  05AH               ;1760     37         420  
   ;              retl  04CH               ;1792     38         430  
   ;              retl  03EH               ;1824     39         440  
   ;              retl  02FH               ;1856     3A         450  
   ;              retl  020H               ;1888     3B         450  
   ;              retl  011H               ;1920     3C         460  
   ;              retl  000H               ;1952     3D         470  
   ;              retl  0F0H               ;1984     3E         480  
   ;              retl  0DFH               ;2016     3F         480  
   ;              retl  0CEH               ;2048     40         490  
   ;              retl  0BDH               ;2080     41         500  
   ;              retl  0ABH               ;2112     42         510  
   ;              retl  09AH               ;2144     43         520  
   ;              retl  088H               ;2176     44         530  
   ;              retl  076H               ;2208     45         540  
   ;              retl  065H               ;2240     46         550  
    include lcdindx.asm
   end