;=============================
;calibration the TPS and the gain
;=================================
cal: 
	    MVFF     keycnt,DL
;      mvl      High  caltable             ; PCLATH sD_l}(bit 15~8)
;      mvf     PCLATH,F,ACCE
;      mvf     keycnt,W,ACCE
;      addl    Low   caltable             ; ոDȻP JPBmۥ[O_WL0x100
;      btss    status,c,ACCE
;      jmp     caltablePRE
;      inf     PCLATH,F,ACCE         ; pGWL0x100h [PCLATU,PCLATH] + 1
; caltablePRE:    
;       mvl     caltable
;       addf    keycnt,W,ACCE
;       mvf     PCLATL,F,ACCE 
;caltable:
    MVL  00H
    XORF DL,W,ACCE
    BTSZ STATUS,Z
    jmp showcal      ;jump to show cal
    
     MVL  01H        
     XORF DL,W,ACCE 
     BTSZ STATUS,Z       
     jmp show25c     ;jump to show 50
     MVL  02H        
     XORF DL,W,ACCE 
     BTSZ STATUS,Z   

    jmp showadc     ;jump to show 50 ADC
    MVL  03H        
     XORF DL,W,ACCE 
     BTSZ STATUS,Z 
    jmp saveadc25   ;save the 50 ADC 
    
     MVL  04H        
     XORF DL,W,ACCE 
     BTSZ STATUS,Z 
    jmp show250c    ;JUMP TO SHOW 250
    
    MVL  05H        
     XORF DL,W,ACCE 
     BTSZ STATUS,Z 
    jmp showadc     ;JUMP TO SHOW ADC
    
    MVL  06H        
     XORF DL,W,ACCE 
     BTSZ STATUS,Z 
     jmp save250adc  ;JUMP TO SAVE 250 ADC
     
     ;MVL  00H        
     ;XORL 00H,W,ACCE 
     ;BTSZ STATUS,Z 
     jmp calend1

showcal:
    mvl LCDNUMC
    mvf lcd0,f,acce
    mvl LCDNUMa
    mvf lcd1,f,acce
    mvl LCDNUMl
    mvf lcd2,f,acce
    jmp CALEND
;============================
; show 25C to lcd
;=================================
show25c:
   CLRF AH
   clrf eal 
   MVl  50
   mvf  AL,F,ACCE
   CALL 24bithextobcd   ;HEX ת ѹBCD
   MVF  AL,W,ACCE
   MVF  LCDTMP1,F,ACCE
   CLRF LCDTMP2
   CALL DISPLAY
   mvl    0e1h
   mvf    FSR0l,f,acce
   mvl 	02h
   mvf	i2crwcnt,f,acce
   mvl     04h
   mvf	i2caddr,f,acce
   call   I2C_READ
   mvl    55h
   subf   0e1h,w,acce
   mvl    0aah
   subc   0e2h,w,acce
   btsz   status,z
   jmp    25cnoflash
   inf    wdtcnt,f,acce
   jmp    calend
25cnoflash:
   inf   noflash,f,acce
   btss  noflash,3
   jmp   calend
   clrf  noflash
   mvl   04h
   mvf   keycnt,f,acce
   jmp   calend
;============================
; show the adc counter to lcd
;=================================
showadc:
   clrf eah
   clrf ebh
   clrf ebl
   clrf eal
  ;mvff ADCCH1H,ah
   ;mvff adcch1m,al
   ;mvff adcch1l,al
   ;mvff OFFSETHch1,bh
   ;mvff OFFSETmch1,bl
   ;mvff OFFSETlch1,bl
   ;call  AX_BX
   ;btsz  ah,7
   ;btss   status,c
   ;call comfax
   MVFF  ADCMATHH,AH
   MVFF  ADCMATHL,AL

   ;call  24bithextobcd   ;HEX ת ѹBCD
   MVF  AL,W,ACCE          
   MVF  LCDTMP1,F,ACCE     
   MVF  AH,W,ACCE
   MVF  LCDTMP2,F,ACCE            
   CALL DISPLAY
   ;CLRF LCD3
   ;BSF  LCD0,3
   jmp  calend
;==============================
;SAVE THE 25C ADC to 24c02
;==============================
saveadc25:
   clrf eah
   clrf ebh
   clrf ebl
   clrf eal
   MVFF  ADCMATHH,AH
   MVFF  ADCMATHL,AL
              
   MVFF AH,CAL25H
   MVFF AL,CAL25L
   MVL  55H
   MVF  0E1H,F,ACCE
   MVL  0AAH
   mvf  0e2h,f,acce
   MVL	04H
   MVF	I2CRWCNT,F,ACCE
   MVL	04h             ;04H
   MVF	I2CADDR,F,ACCE
   mvl      0E1H
   CALL	I2C_WRITE ;öȡ12C
   inf   keycnt,f,acce
   CALL  EAX_ECH
CALEND:   
   jmp  dealend
   
;============================
; show 25C to lcd
;=================================
show250c: 
   clrf eal 
   MVL  0fah
   mvf  AL,F,ACCE
   CLRF AH
   CALL 24bithextobcd   ;HEX ת ѹBCD
   MVF  AL,W,ACCE
   MVF  LCDTMP1,F,ACCE
   MVFF AH,LCDTMP2
   CALL DISPLAY 
   mvl    0e5h
   mvf    FSR0l,f,acce
   mvl 	02h
   mvf	i2crwcnt,f,acce
   mvl	08h
   mvf	i2caddr,f,acce
   call   I2C_READ
   mvl    55h
   subf   0e5h,w,acce
   mvl    0aah
   subc   0e6h,w,acce
   btsz   status,z
   jmp    250cnoflash
   inf    wdtcnt,f,acce
   jmp    calend
250cnoflash:
   inf   noflash,f,acce
   btss  noflash,4
   jmp   calend
   clrf  noflash
   mvl   07h
   mvf   keycnt,f,acce
   jmp   calend
;=================================         
;THGIAN=100h*(3F7H-64H)/(CAL250-CAL25)      
;================================= 
;==============================
;SAVE THE 25C ADC to 24c02
;==============================        
save250adc:   
   clrf eah
   clrf ebh
   clrf ebl
   clrf eal
   MVFF  ADCMATHH,AH
   MVFF  ADCMATHL,AL


   MVFF AH,CAL250H         ;CAL250H/L
   MVFF AL,CAL250L
   MVL  55H                             
   MVF  0E5H,F,ACCE                     
   MVL  0AAH                            
   mvf  0e6h,f,acce                     
   MVL	04H                         
   MVF	I2CRWCNT,F,ACCE             
   MVL	08H                         
   MVF	I2CADDR,F,ACCE              
   mvl      0E5H                        
   CALL	I2C_WRITE ;öȡ12C 
   CALL      delay100ms
;=============================================
;deal the tps gain
;=========================================
 			MVFF CAL250H,AH        ;CAL250H/L
 			MVFF CAL250L,AL 
 			mvl   02dh
			mvf   bl,f,acce
			mvl   03h
			mvf   bh,f,acce
			call  16BITMUL16BITU
			MVF   CAL25L,W,ACCE
      SUBF  CAL250L,W,ACCE
      MVF   CL,F,ACCE
      MVF   CAL25H,W,ACCE
      SUBC  CAL250H,W,ACCE
      MVF   CH,F,ACCE
      BTSz  CH,7
      CALL  COMFCX
			CALL  32BITDIV16BITU
			;mvf   tpv_L,w,acce
			;addf  al,f,acce
			;mvf   tpv_h,w,acce
			;addc  ah,f,acce
			MVFF  AL,T1_L
			MVFF  AH,T1_H
			MVL   020H
			MVF   CL,F,ACCE
			MVL   00H
			MVF   CH,F,ACCE
			CALL  32BITDIV16BITU
			;MVFF  AH,BUFF_H       
			MVFF  AL,BUFF_H   ;TABALE INDEX      ;TABLE  DIFFRENCE
			MVL   020H     
      MVF   BL,F,ACCE
      MVL   00H      
      MVF   BH,F,ACCE
      CALL  16BITMUL16BITU
      MVFF AH,BH
      MVFF AL,BL
      MVFF T1_L,AL
      MVFF T1_H,AH
      CALL AX_BX
      ;MVL   020H             
      ;MVF   CL,F,ACCE        
      ;MVL   00H              
      ;MVF   CH,F,ACCE        
      ;CALL  32BITDIV16BITU 
      MVFF  AL,BUFF_L
      
      MVF   BUFF_H,W,ACCE   
      mvf   DL,f,acce
	call	readv2th
	mvf   t1_H,f,acce
	MVF   BUFF_H,W,ACce
      mvf   DL,f,acce  
      call	readv2tl   
      mvf   t1_l,f,acce
      
      INF	BUFF_H,F,ACCE
      MVF   BUFF_H,W,ACCE 
      mvf   DL,f,acce   
      call	readv2th    
      mvf   t2_H,f,acce        
      MVF   BUFF_H,W,ACce 
      mvf   DL,f,acce   
      call	readv2tl    
      mvf   t2_l,f,acce     
			                            
      CLRF  EAH
      CLRF  EAL  
      MVFF  T2_H,AH
      MVFF  T2_L,AL
      MVFF  T1_H,BH                      
      MVFF  T1_L,BL
      CALL  AX_BX
      MVL   00H
      MVF   BH,F,ACCE
      MVFF  BUFF_L,BL
      CALL  16BITMUL16BITU
      MVL   00H
      MVF   CH,F,ACCE
      MVL   020H
      MVF   CL,F,ACCE
      CALL  32BITDIV16BITU
      MVFF  T1_H,BH  
      MVFF  T1_L,BL
      CALL  AXADDBX
      mvl   64h
      mvf   cl,f,acce
      clrf   ch
      call	 32BITDIV16BITU
      MVL   0FAH
      MVF   CL,F,ACCE
      CLRF  CH
      MVF   AL,W,ACCE
      SUBF	CL,F,ACCE
      MVF   AH,W,ACCE
      SUBC	CH,F,ACCE
      MVFF  CL,TS_l
      MVFF  CH,TS_h
      
;=====================
;GET THE tps TEMP
;=====================      
  
  		mvff  TPS1H,bh
  		mvff  TPS1M,bl
  		mvff  TPS0H,ch   
  		mvff  TPS0M,cl
  		call  bx_cx
  		btsz  bh,7
  		call  comfbx
  		;MVF   BL,W,ACCE
  		;MVF   AL,F,ACCE
  		;MVF   BH,W,ACCE
  		;MVF	  AH,F,ACCE
  		;CLRF  EAL
  		;CLRF  EAH
  		;MVFF  TS_l,CL
  		;MVFF  TS_h,CH
  		;MVL   021H
  		;ADDF	CL,F,ACCE
  		;MVL   01H
  		;ADDC	CH,F,ACCE
  		;CALL  32BITDIV16BITU
  		MVFF  TS_l,tpsl
  		MVFF  BL,TPGAINL
  		MVFF  BH,TPGAINH
  		
  		
  		
  	
  		MVL  55H                             
  		MVF  0a8H,F,ACCE                     
  		MVL  0AAH                            
  		mvf  0a9h,f,acce 
  		mvl    0a8H
  		mvf    FSR0l,f,acce
  		MVL	05H
  		MVF	I2CRWCNT,F,ACCE
  		MVL	00H
  		MVF	I2CADDR,F,ACCE
  		mvl      0A8H
  		CALL	I2C_WRITE ;öȡ12C
calend1:
   		 bcf  sys_flag,ERR_F    
   		CALL     DISPAS
   		bCf      flag,b_cal
   		clrf    keycnt
   		JMP      dealend
   
   
   
   
   
   
    