;==========================
;FILE NAME:I2C.ASM
;CONPANY: HYCON TEK
;DEVICE:  HY11P SERISE
;VERSION: 1.0
;UPDATE:  2009.1.20
;CYCLE:
;FUNCTON: READ AND WERIT THE EEPROM
;===================================
SDA  EQU  3
SCL  EQU  2
;==============
;ʼͨѶI2C I/O
;================
I2C_INI:
  SCL_0
  BSF TRISC2,SCL
  SDA_OUT
  SDA_0
  SCL_1
  RET
  
DELAY:		
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	RET
;=================
;ȴEEPROMӦź
;======================
WAITACK:
   scl_0
   nop
   nop
   nop
   SDA_IN
   nop
   nop
   nop
   scl_1
   nop
   nop
   nop
   nop
   BTSZ PT2,SDA
   JMP NOACK
   SCL_0
   BCF SYS_FLAG,ERR_F
   RET
NOACK:
   BSF SYS_FLAG,ERR_F
   RET
;=====================================
;CPUһݺEEPROMһӦź
;=====================================
master_ack:
   send_0
   ret
;===================================
; EEPROM д
;==================================
I2C_START:
   SCL_0
   SDA_1
   SCL_1
   SDA_0
   RET
;====================
;ֹͣ EEPROM 
;====================
I2C_STOP:
   SDA_OUT
   SCL_0
   SDA_0
   SCL_1
   SDA_1
   RET
;=======================================
;
;=======================================
I2C_WRITE:
  MVF	FSR0L,F,ACCE
  bcf pt2,3 
  CALL I2C_INI          ;ʼI2CͨѶӿ
  call i2c_start        ;EEPROMʼź
  mvl  10100000b 
  ;mvf  e2p_addr,f,acce  ;CHIPCODEд
  call send_data
  CALL WAITACK          ;ȴӦź
  ;MVL  20H
  MVF  I2CADDR,W,ACCE  ;EEPROMݵĴŵַ
  CALL SEND_DATA
  CALL WAITACK
  ;mvF  08h              ;ֽ
  ;mvf  counter1,f,acce
  ;mvl  e2pdata+1
  ;mvf  fsr0l,f,acce
wrlp:
  mvf indf0,W,ACCE
  call send_data        ;÷ӳ
   CALL WAITACK
  inf  fsr0l,f,acce
  dcsz I2crwcnt,f,acce
  jmp wrlp
  call i2c_stop
  bsf  pt2,3
  ret

  
;=========================================
;READROM
;==========================================
I2c_read:
  CALL I2C_INI       ;ʼͨѶI/O
  CALL I2C_START     ;EEPROM
  MVL 10100000b       
  ;MVF E2P_ADDR,F,ACCE ;CHIPCODEд
  CALL SEND_DATA
  CALL WAITACK

  ;MVL  20H
  MVF  I2CADDR,W,ACCE ;Ҫȡݵĵַ
  CALL SEND_DATA
  CALL WAITACK
  call i2c_start
  bcf  status,c

  MVL  10100001B        ;CHIPCODE ȡ
  ;MVF  E2P_ADDR,F,ACCE
  CALL SEND_DATA
  CALL WAITACK

RD:
   ;CLRF FSR0H
  ;MVL 08H
  ;MVF COUNTER1,F,ACCE
RDLP:
   CALL READ_DATA     ;ȡ
   mvf  indf0,f,acce
   call  master_ack    ;EEPROM һź
   inf  fsr0l,f,acce
   CALL DELAY
   DCSZ I2CRWCNT,F,ACCE
   JMP RDLP
   RET
;==========================
;1 ֽ
;==========================
SEND_DATA:
   MVF	I2CSHIFT,F,ACCE
   SDA_OUT
   MVL 08H
   MVF i2ccnt,f,acce
SEND_DATA1:
   RLFC I2CSHIFT,F,ACCE
   BTSZ STATUS,C
   jmp send_bit1
send_bit0:
   send_0
   jmp send_bit_com
send_bit1:
    send_1   
send_bit_com:   
   DCSZ i2ccnt,F,ACCE
   JMP  SEND_DATA1 
   RET

;==============================
;1ֽ
;==============================
READ_DATA:
   CLRF INDF0
   MVL 08H
   MVF i2ccnt,F,ACCE
READ_LP:
   SCL_0
   SDA_IN
   SCL_1
   ;RLFC INDF0,F,ACCE
   BCF  STATUS,C
   BTSZ PT2,SDA
   BSF  STATUS,C
   RLFC wreg,F,ACCE
   DCSZ i2ccnt,f,acce
   JMP  READ_LP
   RET